/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.hapi.ServerMeta;
import uk.ac.starlink.util.IOSupplier;
import uk.ac.starlink.util.URLUtils;

public class ServerListing {
    private final String name_;
    private final IOSupplier<String[]> lineSupplier_;
    private ServerMeta[] servers_;
    private static final String SERVERS_URL = "https://raw.githubusercontent.com/hapi-server/servers/master/";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.hapi");
    public static final ServerListing ALL;
    public static final ServerListing ALL_;
    public static final ServerListing DEV;
    public static final ServerListing FALLBACK;
    public static final ServerListing[] LISTINGS;

    private ServerListing(String name, IOSupplier<String[]> lineSupplier) {
        this.name_ = name;
        this.lineSupplier_ = lineSupplier;
    }

    public ServerMeta[] getServers() {
        if (this.servers_ == null) {
            String[] lines;
            try {
                lines = this.lineSupplier_.get();
            }
            catch (IOException e) {
                logger_.log(Level.WARNING, "Failed to load HAPI server list", e);
                lines = new String[]{};
            }
            this.servers_ = ServerListing.parseServerLines(lines);
        }
        return this.servers_;
    }

    public String toString() {
        return this.name_;
    }

    private static ServerListing createUrlListing(String name, String url) {
        return new ServerListing(name, () -> {
            logger_.info("Reading HAPI servers from " + url);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(URLUtils.newURL(url).openStream()));){
                String[] stringArray = (String[])in.lines().toArray(String[]::new);
                return stringArray;
            }
        });
    }

    private static ServerListing createFixedListing(String name) {
        String[] lines = new String[]{"https://cdaweb.gsfc.nasa.gov/hapi", "https://imag-data.bgs.ac.uk/GIN_V1/hapi", "http://hapi-server.org/servers/SSCWeb/hapi", "https://iswa.gsfc.nasa.gov/IswaSystemWebApp/hapi", "http://lasp.colorado.edu/lisird/hapi", "http://hapi-server.org/servers/TestData2.0/hapi", "https://amda.irap.omp.eu/service/hapi", "https://vires.services/hapi", "https://api.helioviewer.org/hapi/Helioviewer/hapi"};
        return new ServerListing(name, () -> lines);
    }

    private static ServerMeta[] parseServerLines(String[] lines) {
        ArrayList<1> list = new ArrayList<1>();
        for (String line : lines) {
            boolean urlOk;
            String[] words = line.split(" *, *", -1);
            int nw = words.length;
            if (nw <= 0) continue;
            final String url = words[0];
            try {
                URLUtils.newURL(url);
                urlOk = true;
            }
            catch (MalformedURLException e) {
                urlOk = false;
            }
            if (!urlOk) continue;
            final String name = nw >= 2 ? words[1] : words[0];
            final String title = nw >= 5 ? words[2] : null;
            final String contact = nw >= 5 ? words[3] : null;
            final String email = nw >= 5 ? words[4] : null;
            list.add(new ServerMeta(){

                @Override
                public String getUrl() {
                    return url;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public String getTitle() {
                    return title;
                }

                @Override
                public String getContact() {
                    return contact;
                }

                @Override
                public String getEmail() {
                    return email;
                }
            });
        }
        return list.toArray(new ServerMeta[0]);
    }

    static {
        ALL_ = ServerListing.createUrlListing("All + Metadata", "https://raw.githubusercontent.com/hapi-server/servers/master/all_.txt");
        LISTINGS = new ServerListing[]{ALL_, ALL = ServerListing.createUrlListing("All", "https://raw.githubusercontent.com/hapi-server/servers/master/all.txt"), DEV = ServerListing.createUrlListing("Dev", "https://raw.githubusercontent.com/hapi-server/servers/master/dev.txt"), FALLBACK = ServerListing.createFixedListing("Fallback")};
    }
}

