/*
 * Decompiled with CFR 0.152.
 */
package net.ladypleaser.rmilite.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.Set;
import net.ladypleaser.rmilite.RemoteInvocationException;
import net.ladypleaser.rmilite.impl.LocalInvocationHandlerImpl;
import net.ladypleaser.rmilite.impl.RemoteInvocationHandler;

public class RemoteInvocationHandlerImpl
extends UnicastRemoteObject
implements RemoteInvocationHandler {
    private Object impl;
    private Set exportedInterfaces;

    public RemoteInvocationHandlerImpl(Object impl, Set exportedInterfaces) throws RemoteException {
        this.impl = impl;
        this.exportedInterfaces = exportedInterfaces;
    }

    public Object invoke(String methodName, Class[] paramTypes, Object[] args) throws RemoteException {
        try {
            if (args == null) {
                args = new Object[]{};
            }
            int i = 0;
            while (i < args.length) {
                if (args[i] instanceof RemoteInvocationHandler) {
                    RemoteInvocationHandler handler = (RemoteInvocationHandler)args[i];
                    args[i] = LocalInvocationHandlerImpl.create(paramTypes[i], handler, this.exportedInterfaces);
                }
                ++i;
            }
            Method method = this.impl.getClass().getMethod(methodName, paramTypes);
            Object returnValue = method.invoke(this.impl, args);
            if (this.exportedInterfaces.contains(method.getReturnType())) {
                RemoteInvocationHandlerImpl remoteHandler = new RemoteInvocationHandlerImpl(returnValue, this.exportedInterfaces);
                returnValue = RemoteObject.toStub(remoteHandler);
            }
            return returnValue;
        }
        catch (InvocationTargetException e) {
            throw new RemoteInvocationException(methodName, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteInvocationException(methodName, e);
        }
    }
}

