/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;

public class BooleanParameter
extends Parameter<Boolean> {
    public BooleanParameter(String name) {
        super(name, Boolean.class, false);
        this.setNullPermitted(false);
    }

    @Override
    public void setNullPermitted(boolean isNullPermitted) {
        super.setNullPermitted(isNullPermitted);
        this.setUsage(isNullPermitted ? "true|false|null" : "true|false");
    }

    public boolean booleanValue(Environment env) throws TaskException {
        return (Boolean)this.objectValue(env);
    }

    public void setBooleanDefault(boolean dflt) {
        this.setStringDefault(dflt ? "true" : "false");
    }

    @Override
    public Boolean stringToObject(Environment env, String stringval) throws ParameterValueException {
        if ("TRUE".equalsIgnoreCase(stringval) || "YES".equalsIgnoreCase(stringval)) {
            return Boolean.TRUE;
        }
        if ("FALSE".equalsIgnoreCase(stringval) || "NO".equalsIgnoreCase(stringval)) {
            return Boolean.FALSE;
        }
        throw new ParameterValueException(this, stringval + " is not true/false/yes/no");
    }
}

