/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;

public class LongParameter
extends Parameter<Long> {
    private long min_ = Long.MIN_VALUE;
    private long max_ = Long.MAX_VALUE;

    public LongParameter(String name) {
        super(name, Long.class, false);
        this.setUsage("<longint-value>");
    }

    @Override
    public Long stringToObject(Environment env, String stringval) throws ParameterValueException {
        long longval;
        try {
            longval = Long.parseLong(stringval.replaceAll("_", ""));
        }
        catch (NumberFormatException e) {
            throw new ParameterValueException(this, e.getMessage());
        }
        if (longval < this.min_) {
            throw new ParameterValueException(this, longval + " < minimum value " + this.min_);
        }
        if (longval > this.max_) {
            throw new ParameterValueException(this, longval + " < maximum value " + this.max_);
        }
        return longval;
    }

    public long longValue(Environment env) throws TaskException {
        return (Long)this.objectValue(env);
    }

    public void setMinimum(long min) {
        this.min_ = min;
    }

    public void setMaximum(long max) {
        this.max_ = max;
    }
}

