/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.stream.Collectors;
import uk.ac.starlink.task.AbstractChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.MultiParameter;
import uk.ac.starlink.task.TaskException;

public class MultiChoiceParameter<C>
extends AbstractChoiceParameter<C[], C>
implements MultiParameter {
    private final Class<C> optClazz_;
    private final char valueSep_;
    private final String allToken_;
    private final C[] allOpts_;
    private boolean usageSet_;

    public MultiChoiceParameter(String name, Class<C> optClazz, char valueSep, C[] options, String allToken) {
        super(name, Array.newInstance(optClazz, 0).getClass(), optClazz, options);
        this.optClazz_ = optClazz;
        this.valueSep_ = valueSep;
        this.allToken_ = allToken;
        this.allOpts_ = allToken != null ? (Object[])options.clone() : null;
    }

    @Override
    public char getValueSeparator() {
        return this.valueSep_;
    }

    @Override
    public C[] stringToObject(Environment env, String sval) throws TaskException {
        if (this.allToken_ != null && this.allToken_.equalsIgnoreCase(sval)) {
            return (Object[])this.allOpts_.clone();
        }
        String[] words = sval.split(Character.toString(this.valueSep_));
        int nobj = words.length;
        Object[] objs = (Object[])Array.newInstance(this.optClazz_, nobj);
        for (int iobj = 0; iobj < nobj; ++iobj) {
            objs[iobj] = this.stringToChoice(words[iobj]);
        }
        return objs;
    }

    @Override
    public String objectToString(Environment env, C[] objVal) {
        return this.choicesToString(objVal);
    }

    @Override
    public void setUsage(String usage) {
        this.usageSet_ = true;
        super.setUsage(usage);
    }

    @Override
    public String getUsage() {
        if (this.usageSet_) {
            return super.getUsage();
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("[").append(this.getOptionValueList().stream().map(this::getName).collect(Collectors.joining("|"))).append(", ...").append("]");
        if (this.allToken_ != null) {
            sbuf.append(" | ").append(this.allToken_);
        }
        return sbuf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDefaultOptions(C[] options) {
        if (options == null) {
            if (!this.isNullPermitted()) throw new IllegalArgumentException("null value not allowed");
            this.setStringDefault(null);
            return;
        } else {
            this.setStringDefault(this.choicesToString(options));
        }
    }

    private String choicesToString(C[] options) {
        return Arrays.asList(options).stream().map(this::choiceToString).collect(Collectors.joining(Character.toString(this.valueSep_)));
    }
}

