/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Comparator;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;

public abstract class Parameter<T> {
    private final Class<T> clazz_;
    private boolean allowClassnameValue_;
    private String name_;
    private String prompt_;
    private String description_;
    private String usage_ = "<value>";
    private String stringDflt_;
    private int pos_;
    private boolean nullPermitted_;
    private boolean preferExplicit_;
    private String stringValue_;
    private T objectValue_;
    private boolean gotValue_;
    public static final Comparator<Parameter<?>> BY_NAME = new Comparator<Parameter<?>>(){

        @Override
        public int compare(Parameter<?> p1, Parameter<?> p2) {
            return p1.getName().compareTo(p2.getName());
        }
    };

    public Parameter(String name, Class<T> clazz, boolean allowClassnameValue) {
        this.name_ = name;
        this.clazz_ = clazz;
        this.allowClassnameValue_ = allowClassnameValue;
    }

    public abstract T stringToObject(Environment var1, String var2) throws TaskException;

    public String objectToString(Environment env, T objectVal) throws TaskException {
        return objectVal == null ? null : objectVal.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValueFromString(Environment env, String stringval) throws TaskException {
        T oval;
        String sval;
        if (stringval == null || stringval.trim().length() == 0) {
            if (!this.isNullPermitted()) throw new ParameterValueException(this, "Null value not permitted");
            sval = null;
            oval = null;
        } else {
            T ov;
            sval = stringval;
            try {
                ov = this.stringToObject(env, stringval);
            }
            catch (TaskException e) {
                if (!this.allowClassnameValue_) throw e;
                T instance = this.attemptGetClassInstance(stringval);
                if (instance == null) throw e;
                ov = instance;
            }
            oval = ov;
        }
        this.setValue(sval, oval);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValueFromObject(Environment env, T objectValue) throws TaskException {
        String stringValue;
        if (objectValue == null) {
            if (!this.isNullPermitted()) throw new ParameterValueException(this, "Null value not permitted");
            stringValue = null;
        } else {
            stringValue = this.objectToString(env, objectValue);
        }
        this.setValue(stringValue, objectValue);
    }

    public final String stringValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.stringValue_;
    }

    public final T objectValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.objectValue_;
    }

    public void clearValue(Environment env) {
        env.clearValue(this);
        this.stringValue_ = null;
        this.objectValue_ = null;
        this.gotValue_ = false;
    }

    protected void setValue(String stringValue, T objectValue) {
        this.stringValue_ = stringValue;
        this.objectValue_ = objectValue;
        this.gotValue_ = true;
    }

    public Class<T> getValueClass() {
        return this.clazz_;
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String getPrompt() {
        return this.prompt_;
    }

    public void setPrompt(String prompt) {
        this.prompt_ = prompt;
    }

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String description) {
        this.description_ = description;
    }

    public void setDescription(String[] descLines) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < descLines.length; ++i) {
            sbuf.append(descLines[i]).append('\n');
        }
        this.setDescription(sbuf.toString());
    }

    public void setUsage(String usage) {
        this.usage_ = usage;
    }

    public String getUsage() {
        return this.usage_;
    }

    public void setNullPermitted(boolean permitted) {
        this.nullPermitted_ = permitted;
    }

    public boolean isNullPermitted() {
        return this.nullPermitted_;
    }

    public boolean getPreferExplicit() {
        return this.preferExplicit_;
    }

    public void setPreferExplicit(boolean prefer) {
        this.preferExplicit_ = prefer;
    }

    public String getStringDefault() {
        return this.stringDflt_;
    }

    public void setStringDefault(String stringDflt) {
        this.stringDflt_ = stringDflt;
    }

    public int getPosition() {
        return this.pos_;
    }

    public void setPosition(int pos) {
        this.pos_ = pos;
    }

    public T[] toArray(Collection<T> collection) {
        Object[] array = (Object[])Array.newInstance(this.clazz_, collection.size());
        return collection.toArray(array);
    }

    public String toString() {
        return this.name_;
    }

    private void checkGotValue(Environment env) throws TaskException {
        if (!this.gotValue_) {
            env.acquireValue(this);
            assert (this.gotValue_) : "Environment did not call setValue";
        }
    }

    private T attemptGetClassInstance(String cname) throws ParameterValueException {
        Class<?> vclazz;
        try {
            vclazz = Class.forName(cname);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        Class<T> clazz = this.getValueClass();
        if (clazz.isAssignableFrom(vclazz)) {
            Constructor<T> constructor;
            Class<T> vtclazz = vclazz.asSubclass(clazz);
            try {
                constructor = vtclazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ParameterValueException(this, "No no-arg constructor for " + vtclazz);
            }
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Throwable e) {
                throw new ParameterValueException(this, "Error constructing " + vtclazz, e);
            }
        }
        throw new ParameterValueException(this, vclazz + " is not of type " + clazz);
    }
}

