/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.pdf.PdfPCell;
import java.util.ArrayList;
import java.util.Iterator;

public class Cell
extends Rectangle
implements TextElementArray {
    protected ArrayList arrayList = null;
    protected int horizontalAlignment = -1;
    protected int verticalAlignment = -1;
    protected float width;
    protected boolean percentage = false;
    protected int colspan = 1;
    protected int rowspan = 1;
    float leading = Float.NaN;
    protected int maxLines = Integer.MAX_VALUE;
    String showTruncation;
    protected boolean useAscender = false;
    protected boolean useDescender = false;
    protected boolean useBorderPadding;
    protected boolean groupChange = true;

    public Cell() {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(-1);
        this.setBorderWidth(0.5f);
        this.arrayList = new ArrayList();
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 20;
    }

    public ArrayList getChunks() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.arrayList.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((Element)iterator.next()).getChunks());
        }
        return arrayList;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    public float getWidth() {
        return this.width;
    }

    public void setColspan(int n) {
        this.colspan = n;
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setRowspan(int n) {
        this.rowspan = n;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public float getLeading() {
        if (Float.isNaN(this.leading)) {
            return 16.0f;
        }
        return this.leading;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public String getShowTruncation() {
        return this.showTruncation;
    }

    public boolean isUseAscender() {
        return this.useAscender;
    }

    public boolean isUseDescender() {
        return this.useDescender;
    }

    public boolean isUseBorderPadding() {
        return this.useBorderPadding;
    }

    public boolean getGroupChange() {
        return this.groupChange;
    }

    public int size() {
        return this.arrayList.size();
    }

    public Iterator getElements() {
        return this.arrayList.iterator();
    }

    void fill() {
        if (this.size() == 0) {
            this.arrayList.add(new Paragraph(0.0f));
        }
    }

    public boolean isTable() {
        return this.size() == 1 && ((Element)this.arrayList.get(0)).type() == 22;
    }

    public PdfPCell createPdfPCell() throws BadElementException {
        if (this.rowspan > 1) {
            throw new BadElementException("PdfPCells can't have a rowspan > 1");
        }
        if (this.isTable()) {
            return new PdfPCell(((Table)this.arrayList.get(0)).createPdfPTable());
        }
        PdfPCell pdfPCell = new PdfPCell();
        pdfPCell.setVerticalAlignment(this.verticalAlignment);
        pdfPCell.setHorizontalAlignment(this.horizontalAlignment);
        pdfPCell.setColspan(this.colspan);
        pdfPCell.setUseBorderPadding(this.useBorderPadding);
        pdfPCell.setUseDescender(this.useDescender);
        pdfPCell.setLeading(this.getLeading(), 0.0f);
        pdfPCell.cloneNonPositionParameters(this);
        pdfPCell.setNoWrap(this.getMaxLines() == 1);
        Iterator iterator = this.getElements();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (element.type() == 11 || element.type() == 12) {
                Paragraph paragraph = new Paragraph((Phrase)element);
                paragraph.setAlignment(this.horizontalAlignment);
                element = paragraph;
            }
            pdfPCell.addElement(element);
        }
        return pdfPCell;
    }

    public float getTop() {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public float getBottom() {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public float getLeft() {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public float getRight() {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }
}

