/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.LargeElement;
import com.lowagie.text.MarkedObject;
import com.lowagie.text.MarkedSection;
import com.lowagie.text.Paragraph;
import com.lowagie.text.TextElementArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Section
extends ArrayList
implements TextElementArray,
LargeElement {
    protected Paragraph title = new Paragraph();
    protected String bookmarkTitle;
    protected int numberDepth = 1;
    protected int numberStyle = 0;
    protected float indentationLeft;
    protected float indentationRight;
    protected float indentation;
    protected boolean bookmarkOpen = true;
    protected boolean triggerNewPage = false;
    protected int subsections = 0;
    protected ArrayList numbers = null;
    protected boolean complete = true;
    protected boolean addedCompletely = false;
    protected boolean notAddedYet = true;

    protected Section() {
    }

    public boolean process(ElementListener elementListener) {
        try {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                elementListener.add(element);
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 13;
    }

    public ArrayList getChunks() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((Element)iterator.next()).getChunks());
        }
        return arrayList;
    }

    public boolean isContent() {
        return true;
    }

    public boolean isNestable() {
        return false;
    }

    public void add(int n, Object object) {
        if (this.isAddedCompletely()) {
            throw new IllegalStateException("This LargeElement has already been added to the Document.");
        }
        try {
            Element element = (Element)object;
            if (!element.isNestable()) {
                throw new ClassCastException("You can't add a " + element.getClass().getName() + " to a Section.");
            }
            super.add(n, element);
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("Insertion of illegal Element: " + classCastException.getMessage());
        }
    }

    public boolean add(Object object) {
        if (this.isAddedCompletely()) {
            throw new IllegalStateException("This LargeElement has already been added to the Document.");
        }
        try {
            Element element = (Element)object;
            if (element.type() == 13) {
                Section section = (Section)object;
                section.setNumbers(++this.subsections, this.numbers);
                return super.add(section);
            }
            if (object instanceof MarkedSection && ((MarkedObject)object).element.type() == 13) {
                MarkedSection markedSection = (MarkedSection)object;
                Section section = (Section)markedSection.element;
                section.setNumbers(++this.subsections, this.numbers);
                return super.add(markedSection);
            }
            if (element.isNestable()) {
                return super.add(object);
            }
            throw new ClassCastException("You can't add a " + element.getClass().getName() + " to a Section.");
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("Insertion of illegal Element: " + classCastException.getMessage());
        }
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return true;
    }

    public Paragraph getTitle() {
        return Section.constructTitle(this.title, this.numbers, this.numberDepth, this.numberStyle);
    }

    public static Paragraph constructTitle(Paragraph paragraph, ArrayList arrayList, int n, int n2) {
        if (paragraph == null) {
            return null;
        }
        int n3 = Math.min(arrayList.size(), n);
        if (n3 < 1) {
            return paragraph;
        }
        StringBuffer stringBuffer = new StringBuffer(" ");
        for (int i = 0; i < n3; ++i) {
            stringBuffer.insert(0, ".");
            stringBuffer.insert(0, (Integer)arrayList.get(i));
        }
        if (n2 == 1) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 2);
        }
        Paragraph paragraph2 = new Paragraph(paragraph);
        paragraph2.add(0, new Chunk(stringBuffer.toString(), paragraph.getFont()));
        return paragraph2;
    }

    public float getIndentationLeft() {
        return this.indentationLeft;
    }

    public float getIndentationRight() {
        return this.indentationRight;
    }

    public float getIndentation() {
        return this.indentation;
    }

    public boolean isBookmarkOpen() {
        return this.bookmarkOpen;
    }

    public boolean isTriggerNewPage() {
        return this.triggerNewPage && this.notAddedYet;
    }

    public Paragraph getBookmarkTitle() {
        if (this.bookmarkTitle == null) {
            return this.getTitle();
        }
        return new Paragraph(this.bookmarkTitle);
    }

    public void setChapterNumber(int n) {
        this.numbers.set(this.numbers.size() - 1, new Integer(n));
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Section)) continue;
            ((Section)e).setChapterNumber(n);
        }
    }

    public int getDepth() {
        return this.numbers.size();
    }

    private void setNumbers(int n, ArrayList arrayList) {
        this.numbers = new ArrayList();
        this.numbers.add(new Integer(n));
        this.numbers.addAll(arrayList);
    }

    public boolean isNotAddedYet() {
        return this.notAddedYet;
    }

    public void setNotAddedYet(boolean bl) {
        this.notAddedYet = bl;
    }

    protected boolean isAddedCompletely() {
        return this.addedCompletely;
    }

    protected void setAddedCompletely(boolean bl) {
        this.addedCompletely = bl;
    }

    public void flushContent() {
        this.setNotAddedYet(false);
        this.title = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (element instanceof Section) {
                Section section = (Section)element;
                if (!section.isComplete() && this.size() == 1) {
                    section.flushContent();
                    return;
                }
                section.setAddedCompletely(true);
            }
            iterator.remove();
        }
    }

    public boolean isComplete() {
        return this.complete;
    }
}

