/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Element;
import com.lowagie.text.Rectangle;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import java.util.ArrayList;
import java.util.Iterator;

public class SimpleCell
extends Rectangle
implements PdfPCellEvent,
TextElementArray {
    private ArrayList content = new ArrayList();
    private float width = 0.0f;
    private float widthpercentage = 0.0f;
    private float spacing_left = Float.NaN;
    private float spacing_right = Float.NaN;
    private float spacing_top = Float.NaN;
    private float spacing_bottom = Float.NaN;
    private float padding_left = Float.NaN;
    private float padding_right = Float.NaN;
    private float padding_top = Float.NaN;
    private float padding_bottom = Float.NaN;
    private int colspan = 1;
    private int horizontalAlignment = -1;
    private int verticalAlignment = -1;
    private boolean cellgroup = false;
    protected boolean useAscender = false;
    protected boolean useDescender = false;
    protected boolean useBorderPadding;

    public SimpleCell(boolean bl) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.cellgroup = bl;
        this.setBorder(15);
    }

    public PdfPCell createPdfPCell(SimpleCell simpleCell) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        PdfPCell pdfPCell = new PdfPCell();
        pdfPCell.setBorder(0);
        SimpleCell simpleCell2 = new SimpleCell(false);
        simpleCell2.setSpacing_left(this.spacing_left);
        simpleCell2.setSpacing_right(this.spacing_right);
        simpleCell2.setSpacing_top(this.spacing_top);
        simpleCell2.setSpacing_bottom(this.spacing_bottom);
        simpleCell2.cloneNonPositionParameters(simpleCell);
        simpleCell2.softCloneNonPositionParameters(this);
        pdfPCell.setCellEvent(simpleCell2);
        pdfPCell.setHorizontalAlignment(simpleCell.horizontalAlignment);
        pdfPCell.setVerticalAlignment(simpleCell.verticalAlignment);
        pdfPCell.setUseAscender(simpleCell.useAscender);
        pdfPCell.setUseBorderPadding(simpleCell.useBorderPadding);
        pdfPCell.setUseDescender(simpleCell.useDescender);
        pdfPCell.setColspan(this.colspan);
        if (this.horizontalAlignment != -1) {
            pdfPCell.setHorizontalAlignment(this.horizontalAlignment);
        }
        if (this.verticalAlignment != -1) {
            pdfPCell.setVerticalAlignment(this.verticalAlignment);
        }
        if (this.useAscender) {
            pdfPCell.setUseAscender(this.useAscender);
        }
        if (this.useBorderPadding) {
            pdfPCell.setUseBorderPadding(this.useBorderPadding);
        }
        if (this.useDescender) {
            pdfPCell.setUseDescender(this.useDescender);
        }
        if (Float.isNaN(f5 = this.spacing_left)) {
            f5 = 0.0f;
        }
        if (Float.isNaN(f4 = this.spacing_right)) {
            f4 = 0.0f;
        }
        if (Float.isNaN(f3 = this.spacing_top)) {
            f3 = 0.0f;
        }
        if (Float.isNaN(f2 = this.spacing_bottom)) {
            f2 = 0.0f;
        }
        if (Float.isNaN(f = this.padding_left)) {
            f = 0.0f;
        }
        pdfPCell.setPaddingLeft(f + f5);
        f = this.padding_right;
        if (Float.isNaN(f)) {
            f = 0.0f;
        }
        pdfPCell.setPaddingRight(f + f4);
        f = this.padding_top;
        if (Float.isNaN(f)) {
            f = 0.0f;
        }
        pdfPCell.setPaddingTop(f + f3);
        f = this.padding_bottom;
        if (Float.isNaN(f)) {
            f = 0.0f;
        }
        pdfPCell.setPaddingBottom(f + f2);
        Iterator iterator = this.content.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            pdfPCell.addElement(element);
        }
        return pdfPCell;
    }

    public void cellLayout(PdfPCell pdfPCell, Rectangle rectangle, PdfContentByte[] pdfContentByteArray) {
        float f;
        float f2;
        float f3;
        float f4 = this.spacing_left;
        if (Float.isNaN(f4)) {
            f4 = 0.0f;
        }
        if (Float.isNaN(f3 = this.spacing_right)) {
            f3 = 0.0f;
        }
        if (Float.isNaN(f2 = this.spacing_top)) {
            f2 = 0.0f;
        }
        if (Float.isNaN(f = this.spacing_bottom)) {
            f = 0.0f;
        }
        Rectangle rectangle2 = new Rectangle(rectangle.getLeft(f4), rectangle.getBottom(f), rectangle.getRight(f3), rectangle.getTop(f2));
        rectangle2.cloneNonPositionParameters(this);
        pdfContentByteArray[1].rectangle(rectangle2);
        rectangle2.setBackgroundColor(null);
        pdfContentByteArray[2].rectangle(rectangle2);
    }

    public void setPadding(float f) {
        if (Float.isNaN(this.padding_right)) {
            this.setPadding_right(f);
        }
        if (Float.isNaN(this.padding_left)) {
            this.setPadding_left(f);
        }
        if (Float.isNaN(this.padding_top)) {
            this.setPadding_top(f);
        }
        if (Float.isNaN(this.padding_bottom)) {
            this.setPadding_bottom(f);
        }
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setPadding_bottom(float f) {
        this.padding_bottom = f;
    }

    public void setPadding_left(float f) {
        this.padding_left = f;
    }

    public void setPadding_right(float f) {
        this.padding_right = f;
    }

    public void setPadding_top(float f) {
        this.padding_top = f;
    }

    public float getSpacing_left() {
        return this.spacing_left;
    }

    public float getSpacing_right() {
        return this.spacing_right;
    }

    public float getSpacing_top() {
        return this.spacing_top;
    }

    public float getSpacing_bottom() {
        return this.spacing_bottom;
    }

    public void setSpacing(float f) {
        this.spacing_left = f;
        this.spacing_right = f;
        this.spacing_top = f;
        this.spacing_bottom = f;
    }

    public void setSpacing_left(float f) {
        this.spacing_left = f;
    }

    public void setSpacing_right(float f) {
        this.spacing_right = f;
    }

    public void setSpacing_top(float f) {
        this.spacing_top = f;
    }

    public void setSpacing_bottom(float f) {
        this.spacing_bottom = f;
    }

    public float getWidth() {
        return this.width;
    }

    public float getWidthpercentage() {
        return this.widthpercentage;
    }

    ArrayList getContent() {
        return this.content;
    }

    public int type() {
        return 20;
    }
}

