/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Set;

public class Utilities {
    public static Set getKeySet(Hashtable hashtable) {
        return hashtable == null ? Collections.EMPTY_SET : hashtable.keySet();
    }

    public static Object[][] addToArray(Object[][] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            objectArray = new Object[][]{objectArray2};
            return objectArray;
        }
        Object[][] objectArray3 = new Object[objectArray.length + 1][];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        objectArray3[objectArray.length] = objectArray2;
        return objectArray3;
    }

    public static void skip(InputStream inputStream, int n) throws IOException {
        long l;
        while (n > 0 && (l = inputStream.skip(n)) > 0L) {
            n = (int)((long)n - l);
        }
    }

    public static boolean isSurrogateHigh(char c) {
        return c >= '\ud800' && c <= '\udbff';
    }

    public static boolean isSurrogateLow(char c) {
        return c >= '\udc00' && c <= '\udfff';
    }

    public static boolean isSurrogatePair(String string, int n) {
        if (n < 0 || n > string.length() - 2) {
            return false;
        }
        return Utilities.isSurrogateHigh(string.charAt(n)) && Utilities.isSurrogateLow(string.charAt(n + 1));
    }

    public static boolean isSurrogatePair(char[] cArray, int n) {
        if (n < 0 || n > cArray.length - 2) {
            return false;
        }
        return Utilities.isSurrogateHigh(cArray[n]) && Utilities.isSurrogateLow(cArray[n + 1]);
    }

    public static int convertToUtf32(char c, char c2) {
        return (c - 55296) * 1024 + (c2 - 56320) + 65536;
    }

    public static int convertToUtf32(char[] cArray, int n) {
        return (cArray[n] - 55296) * 1024 + (cArray[n + 1] - 56320) + 65536;
    }

    public static int convertToUtf32(String string, int n) {
        return (string.charAt(n) - 55296) * 1024 + (string.charAt(n + 1) - 56320) + 65536;
    }
}

