/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html;

import com.lowagie.text.html.WebColors;
import java.awt.Color;
import java.util.Properties;
import java.util.StringTokenizer;

public class Markup {
    public static float parseLength(String string) {
        int n = 0;
        int n2 = string.length();
        boolean bl = true;
        block3: while (bl && n < n2) {
            switch (string.charAt(n)) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++n;
                    continue block3;
                }
            }
            bl = false;
        }
        if (n == 0) {
            return 0.0f;
        }
        if (n == n2) {
            return Float.parseFloat(string + "f");
        }
        float f = Float.parseFloat(string.substring(0, n) + "f");
        if ((string = string.substring(n)).startsWith("in")) {
            return f * 72.0f;
        }
        if (string.startsWith("cm")) {
            return f / 2.54f * 72.0f;
        }
        if (string.startsWith("mm")) {
            return f / 25.4f * 72.0f;
        }
        if (string.startsWith("pc")) {
            return f * 12.0f;
        }
        return f;
    }

    public static Color decodeColor(String string) {
        if (string == null) {
            return null;
        }
        string = string.toLowerCase().trim();
        try {
            return WebColors.getRGBColor(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static Properties parseAttributes(String string) {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string2 = stringTokenizer2.nextToken().trim();
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string3 = stringTokenizer2.nextToken().trim();
            if (string3.startsWith("\"")) {
                string3 = string3.substring(1);
            }
            if (string3.endsWith("\"")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            properties.setProperty(string2.toLowerCase(), string3);
        }
        return properties;
    }
}

