/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;

public abstract class PdfObject {
    protected byte[] bytes;
    protected int type;
    protected PRIndirectReference indRef;

    protected PdfObject(int n) {
        this.type = n;
    }

    protected PdfObject(int n, String string) {
        this.type = n;
        this.bytes = PdfEncodings.convertToBytes(string, null);
    }

    protected PdfObject(int n, byte[] byArray) {
        this.bytes = byArray;
        this.type = n;
    }

    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        if (this.bytes != null) {
            outputStream.write(this.bytes);
        }
    }

    public String toString() {
        if (this.bytes == null) {
            return super.toString();
        }
        return PdfEncodings.convertToString(this.bytes, null);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean canBeInObjStm() {
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    protected void setContent(String string) {
        this.bytes = PdfEncodings.convertToBytes(string, null);
    }

    public int type() {
        return this.type;
    }

    public boolean isNull() {
        return this.type == 8;
    }

    public boolean isNumber() {
        return this.type == 2;
    }

    public boolean isString() {
        return this.type == 3;
    }

    public boolean isName() {
        return this.type == 4;
    }

    public boolean isArray() {
        return this.type == 5;
    }

    public boolean isDictionary() {
        return this.type == 6;
    }

    public boolean isStream() {
        return this.type == 7;
    }

    public boolean isIndirect() {
        return this.type == 10;
    }

    public PRIndirectReference getIndRef() {
        return this.indRef;
    }

    public void setIndRef(PRIndirectReference pRIndirectReference) {
        this.indRef = pRIndirectReference;
    }
}

