/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfNumberTree;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.HashMap;

public class PdfPageLabels {
    static PdfName[] numberingStyle = new PdfName[]{PdfName.D, PdfName.R, new PdfName("r"), PdfName.A, new PdfName("a")};
    private HashMap map = new HashMap();

    public PdfPageLabels() {
        this.addPageLabel(1, 0, null, 1);
    }

    public void addPageLabel(int n, int n2, String string, int n3) {
        if (n < 1 || n3 < 1) {
            throw new IllegalArgumentException("In a page label the page numbers must be greater or equal to 1.");
        }
        PdfDictionary pdfDictionary = new PdfDictionary();
        if (n2 >= 0 && n2 < numberingStyle.length) {
            pdfDictionary.put(PdfName.S, numberingStyle[n2]);
        }
        if (string != null) {
            pdfDictionary.put(PdfName.P, new PdfString(string, "UnicodeBig"));
        }
        if (n3 != 1) {
            pdfDictionary.put(PdfName.ST, new PdfNumber(n3));
        }
        this.map.put(new Integer(n - 1), pdfDictionary);
    }

    PdfDictionary getDictionary(PdfWriter pdfWriter) {
        try {
            return PdfNumberTree.writeTree(this.map, pdfWriter);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }
}

