/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.exceptions.InvalidPdfException;
import com.lowagie.text.exceptions.UnsupportedPdfException;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.LZWDecoder;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.internal.PdfViewerPreferencesImp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.zip.InflaterInputStream;

public class PdfReader {
    static final PdfName[] pageInhCandidates = new PdfName[]{PdfName.MEDIABOX, PdfName.ROTATE, PdfName.RESOURCES, PdfName.CROPBOX};
    static final byte[] endstream = PdfEncodings.convertToBytes("endstream", null);
    static final byte[] endobj = PdfEncodings.convertToBytes("endobj", null);
    protected PRTokeniser tokens;
    protected int[] xref;
    protected IntHashtable objStmToOffset;
    private ArrayList xrefObj;
    PdfDictionary rootPages;
    protected PdfDictionary catalog;
    protected PageRefs pageRefs;
    protected PRAcroForm acroForm = null;
    protected boolean acroFormParsed = false;
    protected boolean encrypted = false;
    protected boolean rebuilt = false;
    protected boolean tampered = false;
    protected PdfEncryption decrypt;
    protected byte[] password = null;
    protected Key certificateKey = null;
    protected Certificate certificate = null;
    protected String certificateKeyProvider = null;
    private boolean ownerPasswordUsed;
    protected ArrayList strings = new ArrayList();
    protected boolean sharedStreams = true;
    protected boolean consolidateNamedDestinations = false;
    private int objNum;
    private int objGen;
    private int lastXrefPartial = -1;
    private boolean partial;
    private PdfViewerPreferencesImp viewerPreferences = new PdfViewerPreferencesImp();
    private boolean appendable;
    private int readDepth = 0;

    protected PdfReader() {
    }

    public RandomAccessFileOrArray getSafeFile() {
        return this.tokens.getSafeFile();
    }

    protected PdfReaderInstance getPdfReaderInstance(PdfWriter pdfWriter) {
        return new PdfReaderInstance(this, pdfWriter);
    }

    public int getNumberOfPages() {
        return this.pageRefs.size();
    }

    public PdfDictionary getCatalog() {
        return this.catalog;
    }

    int getPageRotation(PdfDictionary pdfDictionary) {
        PdfNumber pdfNumber = pdfDictionary.getAsNumber(PdfName.ROTATE);
        if (pdfNumber == null) {
            return 0;
        }
        int n = pdfNumber.intValue();
        return (n %= 360) < 0 ? n + 360 : n;
    }

    public Rectangle getPageSizeWithRotation(PdfDictionary pdfDictionary) {
        Rectangle rectangle = this.getPageSize(pdfDictionary);
        for (int i = this.getPageRotation(pdfDictionary); i > 0; i -= 90) {
            rectangle = rectangle.rotate();
        }
        return rectangle;
    }

    public Rectangle getPageSize(int n) {
        return this.getPageSize(this.pageRefs.getPageNRelease(n));
    }

    public Rectangle getPageSize(PdfDictionary pdfDictionary) {
        PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.MEDIABOX);
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public static Rectangle getNormalizedRectangle(PdfArray pdfArray) {
        float f = ((PdfNumber)PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(0))).floatValue();
        float f2 = ((PdfNumber)PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(1))).floatValue();
        float f3 = ((PdfNumber)PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(2))).floatValue();
        float f4 = ((PdfNumber)PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(3))).floatValue();
        return new Rectangle(Math.min(f, f3), Math.min(f2, f4), Math.max(f, f3), Math.max(f2, f4));
    }

    public static PdfObject getPdfObjectRelease(PdfObject pdfObject) {
        PdfObject pdfObject2 = PdfReader.getPdfObject(pdfObject);
        PdfReader.releaseLastXrefPartial(pdfObject);
        return pdfObject2;
    }

    public static PdfObject getPdfObject(PdfObject pdfObject) {
        if (pdfObject == null) {
            return null;
        }
        if (!pdfObject.isIndirect()) {
            return pdfObject;
        }
        try {
            PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
            int n = pRIndirectReference.getNumber();
            boolean bl = pRIndirectReference.getReader().appendable;
            pdfObject = pRIndirectReference.getReader().getPdfObject(n);
            if (pdfObject == null) {
                return null;
            }
            if (bl) {
                switch (pdfObject.type()) {
                    case 8: {
                        pdfObject = new PdfNull();
                        break;
                    }
                    case 1: {
                        pdfObject = new PdfBoolean(((PdfBoolean)pdfObject).booleanValue());
                        break;
                    }
                    case 4: {
                        pdfObject = new PdfName(pdfObject.getBytes());
                    }
                }
                pdfObject.setIndRef(pRIndirectReference);
            }
            return pdfObject;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static PdfObject getPdfObjectRelease(PdfObject pdfObject, PdfObject pdfObject2) {
        PdfObject pdfObject3 = PdfReader.getPdfObject(pdfObject, pdfObject2);
        PdfReader.releaseLastXrefPartial(pdfObject);
        return pdfObject3;
    }

    public static PdfObject getPdfObject(PdfObject pdfObject, PdfObject pdfObject2) {
        if (pdfObject == null) {
            return null;
        }
        if (!pdfObject.isIndirect()) {
            PRIndirectReference pRIndirectReference = null;
            if (pdfObject2 != null && (pRIndirectReference = pdfObject2.getIndRef()) != null && pRIndirectReference.getReader().isAppendable()) {
                switch (pdfObject.type()) {
                    case 8: {
                        pdfObject = new PdfNull();
                        break;
                    }
                    case 1: {
                        pdfObject = new PdfBoolean(((PdfBoolean)pdfObject).booleanValue());
                        break;
                    }
                    case 4: {
                        pdfObject = new PdfName(pdfObject.getBytes());
                    }
                }
                pdfObject.setIndRef(pRIndirectReference);
            }
            return pdfObject;
        }
        return PdfReader.getPdfObject(pdfObject);
    }

    public PdfObject getPdfObjectRelease(int n) {
        PdfObject pdfObject = this.getPdfObject(n);
        this.releaseLastXrefPartial();
        return pdfObject;
    }

    public PdfObject getPdfObject(int n) {
        try {
            this.lastXrefPartial = -1;
            if (n < 0 || n >= this.xrefObj.size()) {
                return null;
            }
            PdfObject pdfObject = (PdfObject)this.xrefObj.get(n);
            if (!this.partial || pdfObject != null) {
                return pdfObject;
            }
            if (n * 2 >= this.xref.length) {
                return null;
            }
            pdfObject = this.readSingleObject(n);
            this.lastXrefPartial = -1;
            if (pdfObject != null) {
                this.lastXrefPartial = n;
            }
            return pdfObject;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void releaseLastXrefPartial() {
        if (this.partial && this.lastXrefPartial != -1) {
            this.xrefObj.set(this.lastXrefPartial, null);
            this.lastXrefPartial = -1;
        }
    }

    public static void releaseLastXrefPartial(PdfObject pdfObject) {
        if (pdfObject == null) {
            return;
        }
        if (!pdfObject.isIndirect()) {
            return;
        }
        if (!(pdfObject instanceof PRIndirectReference)) {
            return;
        }
        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
        PdfReader pdfReader = pRIndirectReference.getReader();
        if (pdfReader.partial && pdfReader.lastXrefPartial != -1 && pdfReader.lastXrefPartial == pRIndirectReference.getNumber()) {
            pdfReader.xrefObj.set(pdfReader.lastXrefPartial, null);
        }
        pdfReader.lastXrefPartial = -1;
    }

    protected PdfObject readSingleObject(int n) throws IOException {
        PdfObject pdfObject;
        this.strings.clear();
        int n2 = n * 2;
        int n3 = this.xref[n2];
        if (n3 < 0) {
            return null;
        }
        if (this.xref[n2 + 1] > 0) {
            n3 = this.objStmToOffset.get(this.xref[n2 + 1]);
        }
        if (n3 == 0) {
            return null;
        }
        this.tokens.seek(n3);
        this.tokens.nextValidToken();
        if (this.tokens.getTokenType() != 1) {
            this.tokens.throwError("Invalid object number.");
        }
        this.objNum = this.tokens.intValue();
        this.tokens.nextValidToken();
        if (this.tokens.getTokenType() != 1) {
            this.tokens.throwError("Invalid generation number.");
        }
        this.objGen = this.tokens.intValue();
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("obj")) {
            this.tokens.throwError("Token 'obj' expected.");
        }
        try {
            pdfObject = this.readPRObject();
            for (int i = 0; i < this.strings.size(); ++i) {
                PdfString pdfString = (PdfString)this.strings.get(i);
                pdfString.decrypt(this);
            }
            if (pdfObject.isStream()) {
                this.checkPRStreamLength((PRStream)pdfObject);
            }
        }
        catch (Exception exception) {
            pdfObject = null;
        }
        if (this.xref[n2 + 1] > 0) {
            pdfObject = this.readOneObjStm((PRStream)pdfObject, this.xref[n2]);
        }
        this.xrefObj.set(n, pdfObject);
        return pdfObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PdfObject readOneObjStm(PRStream pRStream, int n) throws IOException {
        int n2 = pRStream.getAsNumber(PdfName.FIRST).intValue();
        byte[] byArray = PdfReader.getStreamBytes(pRStream, this.tokens.getFile());
        PRTokeniser pRTokeniser = this.tokens;
        this.tokens = new PRTokeniser(byArray);
        try {
            int n3 = 0;
            boolean bl = true;
            ++n;
            for (int i = 0; i < n && (bl = this.tokens.nextToken()); ++i) {
                if (this.tokens.getTokenType() != 1) {
                    bl = false;
                    break;
                }
                bl = this.tokens.nextToken();
                if (!bl) break;
                if (this.tokens.getTokenType() != 1) {
                    bl = false;
                    break;
                }
                n3 = this.tokens.intValue() + n2;
            }
            if (!bl) {
                throw new InvalidPdfException("Error reading ObjStm");
            }
            this.tokens.seek(n3);
            PdfObject pdfObject = this.readPRObject();
            return pdfObject;
        }
        finally {
            this.tokens = pRTokeniser;
        }
    }

    private void checkPRStreamLength(PRStream pRStream) throws IOException {
        int n;
        block8: {
            Object object;
            int n2 = this.tokens.length();
            int n3 = pRStream.getOffset();
            boolean bl = false;
            n = 0;
            PdfObject pdfObject = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.LENGTH));
            if (pdfObject != null && pdfObject.type() == 2) {
                n = ((PdfNumber)pdfObject).intValue();
                if (n + n3 > n2 - 20) {
                    bl = true;
                } else {
                    this.tokens.seek(n3 + n);
                    object = this.tokens.readString(20);
                    if (!(((String)object).startsWith("\nendstream") || ((String)object).startsWith("\r\nendstream") || ((String)object).startsWith("\rendstream") || ((String)object).startsWith("endstream"))) {
                        bl = true;
                    }
                }
            } else {
                bl = true;
            }
            if (bl) {
                int n4;
                object = new byte[16];
                this.tokens.seek(n3);
                do {
                    n4 = this.tokens.getFilePointer();
                    if (!this.tokens.readLineSegment((byte[])object)) break block8;
                    if (!PdfReader.equalsn((byte[])object, endstream)) continue;
                    n = n4 - n3;
                    break block8;
                } while (!PdfReader.equalsn((byte[])object, endobj));
                this.tokens.seek(n4 - 16);
                String string = this.tokens.readString(16);
                int n5 = string.indexOf("endstream");
                if (n5 >= 0) {
                    n4 = n4 - 16 + n5;
                }
                n = n4 - n3;
            }
        }
        pRStream.setLength(n);
    }

    protected PdfDictionary readDictionary() throws IOException {
        PdfDictionary pdfDictionary = new PdfDictionary();
        while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() == 8) break;
            if (this.tokens.getTokenType() != 3) {
                this.tokens.throwError("Dictionary key is not a name.");
            }
            PdfName pdfName = new PdfName(this.tokens.getStringValue(), false);
            PdfObject pdfObject = this.readPRObject();
            int n = pdfObject.type();
            if (-n == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            if (-n == 6) {
                this.tokens.throwError("Unexpected ']'");
            }
            pdfDictionary.put(pdfName, pdfObject);
        }
        return pdfDictionary;
    }

    protected PdfArray readArray() throws IOException {
        PdfObject pdfObject;
        int n;
        PdfArray pdfArray = new PdfArray();
        while (-(n = (pdfObject = this.readPRObject()).type()) != 6) {
            if (-n == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            pdfArray.add(pdfObject);
        }
        return pdfArray;
    }

    protected PdfObject readPRObject() throws IOException {
        this.tokens.nextValidToken();
        int n = this.tokens.getTokenType();
        switch (n) {
            case 7: {
                boolean bl;
                ++this.readDepth;
                PdfDictionary pdfDictionary = this.readDictionary();
                --this.readDepth;
                int n2 = this.tokens.getFilePointer();
                while ((bl = this.tokens.nextToken()) && this.tokens.getTokenType() == 4) {
                }
                if (bl && this.tokens.getStringValue().equals("stream")) {
                    int n3;
                    while ((n3 = this.tokens.read()) == 32 || n3 == 9 || n3 == 0 || n3 == 12) {
                    }
                    if (n3 != 10) {
                        n3 = this.tokens.read();
                    }
                    if (n3 != 10) {
                        this.tokens.backOnePosition(n3);
                    }
                    PRStream pRStream = new PRStream(this, this.tokens.getFilePointer());
                    pRStream.putAll(pdfDictionary);
                    pRStream.setObjNum(this.objNum, this.objGen);
                    return pRStream;
                }
                this.tokens.seek(n2);
                return pdfDictionary;
            }
            case 5: {
                ++this.readDepth;
                PdfArray pdfArray = this.readArray();
                --this.readDepth;
                return pdfArray;
            }
            case 1: {
                return new PdfNumber(this.tokens.getStringValue());
            }
            case 2: {
                PdfString pdfString = new PdfString(this.tokens.getStringValue(), null).setHexWriting(this.tokens.isHexString());
                pdfString.setObjNum(this.objNum, this.objGen);
                if (this.strings != null) {
                    this.strings.add(pdfString);
                }
                return pdfString;
            }
            case 3: {
                PdfName pdfName = (PdfName)PdfName.staticNames.get(this.tokens.getStringValue());
                if (this.readDepth > 0 && pdfName != null) {
                    return pdfName;
                }
                return new PdfName(this.tokens.getStringValue(), false);
            }
            case 9: {
                int n4 = this.tokens.getReference();
                PRIndirectReference pRIndirectReference = new PRIndirectReference(this, n4, this.tokens.getGeneration());
                return pRIndirectReference;
            }
        }
        String string = this.tokens.getStringValue();
        if ("null".equals(string)) {
            if (this.readDepth == 0) {
                return new PdfNull();
            }
            return PdfNull.PDFNULL;
        }
        if ("true".equals(string)) {
            if (this.readDepth == 0) {
                return new PdfBoolean(true);
            }
            return PdfBoolean.PDFTRUE;
        }
        if ("false".equals(string)) {
            if (this.readDepth == 0) {
                return new PdfBoolean(false);
            }
            return PdfBoolean.PDFFALSE;
        }
        return new PdfLiteral(-n, this.tokens.getStringValue());
    }

    public static byte[] FlateDecode(byte[] byArray) {
        byte[] byArray2 = PdfReader.FlateDecode(byArray, true);
        if (byArray2 == null) {
            return PdfReader.FlateDecode(byArray, false);
        }
        return byArray2;
    }

    public static byte[] decodePredictor(byte[] byArray, PdfObject pdfObject) {
        if (pdfObject == null || !pdfObject.isDictionary()) {
            return byArray;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
        PdfObject pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.PREDICTOR));
        if (pdfObject2 == null || !pdfObject2.isNumber()) {
            return byArray;
        }
        int n = ((PdfNumber)pdfObject2).intValue();
        if (n < 10) {
            return byArray;
        }
        int n2 = 1;
        pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.COLUMNS));
        if (pdfObject2 != null && pdfObject2.isNumber()) {
            n2 = ((PdfNumber)pdfObject2).intValue();
        }
        int n3 = 1;
        pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.COLORS));
        if (pdfObject2 != null && pdfObject2.isNumber()) {
            n3 = ((PdfNumber)pdfObject2).intValue();
        }
        int n4 = 8;
        pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.BITSPERCOMPONENT));
        if (pdfObject2 != null && pdfObject2.isNumber()) {
            n4 = ((PdfNumber)pdfObject2).intValue();
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        int n5 = n3 * n4 / 8;
        int n6 = (n3 * n2 * n4 + 7) / 8;
        byte[] byArray2 = new byte[n6];
        byte[] byArray3 = new byte[n6];
        while (true) {
            int n7 = 0;
            try {
                n7 = dataInputStream.read();
                if (n7 < 0) {
                    return byteArrayOutputStream.toByteArray();
                }
                dataInputStream.readFully(byArray2, 0, n6);
            }
            catch (Exception exception) {
                return byteArrayOutputStream.toByteArray();
            }
            switch (n7) {
                case 0: {
                    break;
                }
                case 1: {
                    for (int i = n5; i < n6; ++i) {
                        int n8 = i;
                        byArray2[n8] = (byte)(byArray2[n8] + byArray2[i - n5]);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n6; ++i) {
                        int n9 = i;
                        byArray2[n9] = (byte)(byArray2[n9] + byArray3[i]);
                    }
                    break;
                }
                case 3: {
                    int n10;
                    for (n10 = 0; n10 < n5; ++n10) {
                        int n11 = n10;
                        byArray2[n11] = (byte)(byArray2[n11] + byArray3[n10] / 2);
                    }
                    for (n10 = n5; n10 < n6; ++n10) {
                        int n12 = n10;
                        byArray2[n12] = (byte)(byArray2[n12] + ((byArray2[n10 - n5] & 0xFF) + (byArray3[n10] & 0xFF)) / 2);
                    }
                    break;
                }
                case 4: {
                    int n13;
                    for (n13 = 0; n13 < n5; ++n13) {
                        int n14 = n13;
                        byArray2[n14] = (byte)(byArray2[n14] + byArray3[n13]);
                    }
                    n13 = n5;
                    while (n13 < n6) {
                        int n15 = byArray2[n13 - n5] & 0xFF;
                        int n16 = byArray3[n13] & 0xFF;
                        int n17 = byArray3[n13 - n5] & 0xFF;
                        int n18 = n15 + n16 - n17;
                        int n19 = Math.abs(n18 - n15);
                        int n20 = Math.abs(n18 - n16);
                        int n21 = Math.abs(n18 - n17);
                        int n22 = n19 <= n20 && n19 <= n21 ? n15 : (n20 <= n21 ? n16 : n17);
                        int n23 = n13++;
                        byArray2[n23] = (byte)(byArray2[n23] + (byte)n22);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("PNG filter unknown.");
                }
            }
            try {
                byteArrayOutputStream.write(byArray2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] byArray4 = byArray3;
            byArray3 = byArray2;
            byArray2 = byArray4;
        }
    }

    public static byte[] FlateDecode(byte[] byArray, boolean bl) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[bl ? 4092 : 1];
        try {
            int n;
            while ((n = inflaterInputStream.read(byArray2)) >= 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            inflaterInputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (bl) {
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static byte[] ASCIIHexDecode(byte[] byArray) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = true;
        int n2 = 0;
        for (int i = 0; i < byArray.length && (n = byArray[i] & 0xFF) != 62; ++i) {
            if (PRTokeniser.isWhitespace(n)) continue;
            int n3 = PRTokeniser.getHex(n);
            if (n3 == -1) {
                throw new RuntimeException("Illegal character in ASCIIHexDecode.");
            }
            if (bl) {
                n2 = n3;
            } else {
                byteArrayOutputStream.write((byte)((n2 << 4) + n3));
            }
            bl = !bl;
        }
        if (!bl) {
            byteArrayOutputStream.write((byte)(n2 << 4));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] ASCII85Decode(byte[] byArray) {
        int n;
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        int[] nArray = new int[5];
        for (n2 = 0; n2 < byArray.length && (n = byArray[n2] & 0xFF) != 126; ++n2) {
            if (PRTokeniser.isWhitespace(n)) continue;
            if (n == 122 && n3 == 0) {
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
                continue;
            }
            if (n < 33 || n > 117) {
                throw new RuntimeException("Illegal character in ASCII85Decode.");
            }
            nArray[n3] = n - 33;
            if (++n3 != 5) continue;
            n3 = 0;
            int n4 = 0;
            for (int i = 0; i < 5; ++i) {
                n4 = n4 * 85 + nArray[i];
            }
            byteArrayOutputStream.write((byte)(n4 >> 24));
            byteArrayOutputStream.write((byte)(n4 >> 16));
            byteArrayOutputStream.write((byte)(n4 >> 8));
            byteArrayOutputStream.write((byte)n4);
        }
        n2 = 0;
        if (n3 == 2) {
            n2 = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85 + 614125 + 7225 + 85;
            byteArrayOutputStream.write((byte)(n2 >> 24));
        } else if (n3 == 3) {
            n2 = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85 + nArray[2] * 85 * 85 + 7225 + 85;
            byteArrayOutputStream.write((byte)(n2 >> 24));
            byteArrayOutputStream.write((byte)(n2 >> 16));
        } else if (n3 == 4) {
            n2 = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85 + nArray[2] * 85 * 85 + nArray[3] * 85 + 85;
            byteArrayOutputStream.write((byte)(n2 >> 24));
            byteArrayOutputStream.write((byte)(n2 >> 16));
            byteArrayOutputStream.write((byte)(n2 >> 8));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] LZWDecode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LZWDecoder lZWDecoder = new LZWDecoder();
        lZWDecoder.decode(byArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public PdfDictionary getPageN(int n) {
        PdfDictionary pdfDictionary = this.pageRefs.getPageN(n);
        if (pdfDictionary == null) {
            return null;
        }
        if (this.appendable) {
            pdfDictionary.setIndRef(this.pageRefs.getPageOrigRef(n));
        }
        return pdfDictionary;
    }

    public PdfDictionary getPageNRelease(int n) {
        PdfDictionary pdfDictionary = this.getPageN(n);
        this.pageRefs.releasePage(n);
        return pdfDictionary;
    }

    public PRIndirectReference getPageOrigRef(int n) {
        return this.pageRefs.getPageOrigRef(n);
    }

    public byte[] getPageContent(int n, RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        PdfDictionary pdfDictionary = this.getPageNRelease(n);
        if (pdfDictionary == null) {
            return null;
        }
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.CONTENTS));
        if (pdfObject == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (pdfObject.isStream()) {
            return PdfReader.getStreamBytes((PRStream)pdfObject, randomAccessFileOrArray);
        }
        if (pdfObject.isArray()) {
            PdfArray pdfArray = (PdfArray)pdfObject;
            byteArrayOutputStream = new ByteArrayOutputStream();
            for (int i = 0; i < pdfArray.size(); ++i) {
                PdfObject pdfObject2 = PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(i));
                if (pdfObject2 == null || !pdfObject2.isStream()) continue;
                byte[] byArray = PdfReader.getStreamBytes((PRStream)pdfObject2, randomAccessFileOrArray);
                byteArrayOutputStream.write(byArray);
                if (i == pdfArray.size() - 1) continue;
                byteArrayOutputStream.write(10);
            }
            return byteArrayOutputStream.toByteArray();
        }
        return new byte[0];
    }

    public static byte[] getStreamBytes(PRStream pRStream, RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.FILTER));
        byte[] byArray = PdfReader.getStreamBytesRaw(pRStream, randomAccessFileOrArray);
        ArrayList arrayList = new ArrayList();
        if (pdfObject != null) {
            if (pdfObject.isName()) {
                arrayList.add(pdfObject);
            } else if (pdfObject.isArray()) {
                arrayList = ((PdfArray)pdfObject).getArrayList();
            }
        }
        ArrayList arrayList2 = new ArrayList();
        PdfObject pdfObject2 = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.DECODEPARMS));
        if (pdfObject2 == null || !pdfObject2.isDictionary() && !pdfObject2.isArray()) {
            pdfObject2 = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.DP));
        }
        if (pdfObject2 != null) {
            if (pdfObject2.isDictionary()) {
                arrayList2.add(pdfObject2);
            } else if (pdfObject2.isArray()) {
                arrayList2 = ((PdfArray)pdfObject2).getArrayList();
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            PdfObject pdfObject3;
            String string = ((PdfName)PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(i))).toString();
            if (string.equals("/FlateDecode") || string.equals("/Fl")) {
                byArray = PdfReader.FlateDecode(byArray);
                pdfObject3 = null;
                if (i >= arrayList2.size()) continue;
                pdfObject3 = (PdfObject)arrayList2.get(i);
                byArray = PdfReader.decodePredictor(byArray, pdfObject3);
                continue;
            }
            if (string.equals("/ASCIIHexDecode") || string.equals("/AHx")) {
                byArray = PdfReader.ASCIIHexDecode(byArray);
                continue;
            }
            if (string.equals("/ASCII85Decode") || string.equals("/A85")) {
                byArray = PdfReader.ASCII85Decode(byArray);
                continue;
            }
            if (string.equals("/LZWDecode")) {
                byArray = PdfReader.LZWDecode(byArray);
                pdfObject3 = null;
                if (i >= arrayList2.size()) continue;
                pdfObject3 = (PdfObject)arrayList2.get(i);
                byArray = PdfReader.decodePredictor(byArray, pdfObject3);
                continue;
            }
            if (string.equals("/Crypt")) continue;
            throw new UnsupportedPdfException("The filter " + string + " is not supported.");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getStreamBytes(PRStream pRStream) throws IOException {
        RandomAccessFileOrArray randomAccessFileOrArray = pRStream.getReader().getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            byte[] byArray = PdfReader.getStreamBytes(pRStream, randomAccessFileOrArray);
            return byArray;
        }
        finally {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] getStreamBytesRaw(PRStream pRStream, RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        byte[] byArray;
        PdfReader pdfReader = pRStream.getReader();
        if (pRStream.getOffset() < 0) {
            byArray = pRStream.getBytes();
        } else {
            byArray = new byte[pRStream.getLength()];
            randomAccessFileOrArray.seek(pRStream.getOffset());
            randomAccessFileOrArray.readFully(byArray);
            PdfEncryption pdfEncryption = pdfReader.getDecrypt();
            if (pdfEncryption != null) {
                PdfObject pdfObject = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.FILTER));
                ArrayList arrayList = new ArrayList();
                if (pdfObject != null) {
                    if (pdfObject.isName()) {
                        arrayList.add(pdfObject);
                    } else if (pdfObject.isArray()) {
                        arrayList = ((PdfArray)pdfObject).getArrayList();
                    }
                }
                boolean bl = false;
                for (int i = 0; i < arrayList.size(); ++i) {
                    PdfObject pdfObject2 = PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(i));
                    if (pdfObject2 == null || !pdfObject2.toString().equals("/Crypt")) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    pdfEncryption.setHashKey(pRStream.getObjNum(), pRStream.getObjGen());
                    byArray = pdfEncryption.decryptByteArray(byArray);
                }
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getStreamBytesRaw(PRStream pRStream) throws IOException {
        RandomAccessFileOrArray randomAccessFileOrArray = pRStream.getReader().getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            byte[] byArray = PdfReader.getStreamBytesRaw(pRStream, randomAccessFileOrArray);
            return byArray;
        }
        finally {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
        }
    }

    public int getXrefSize() {
        return this.xrefObj.size();
    }

    PdfEncryption getDecrypt() {
        return this.decrypt;
    }

    static boolean equalsn(byte[] byArray, byte[] byArray2) {
        int n = byArray2.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public void close() {
        if (!this.partial) {
            return;
        }
        try {
            this.tokens.close();
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public boolean isAppendable() {
        return this.appendable;
    }

    public final boolean isOpenedWithFullPermissions() {
        return !this.encrypted || this.ownerPasswordUsed;
    }

    static class PageRefs {
        private PdfReader reader;
        private IntHashtable refsp;
        private ArrayList refsn;
        private int lastPageRead;
        private int sizep;
        private boolean keepPages;

        int size() {
            if (this.refsn != null) {
                return this.refsn.size();
            }
            return this.sizep;
        }

        public PdfDictionary getPageN(int n) {
            PRIndirectReference pRIndirectReference = this.getPageOrigRef(n);
            return (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
        }

        public PdfDictionary getPageNRelease(int n) {
            PdfDictionary pdfDictionary = this.getPageN(n);
            this.releasePage(n);
            return pdfDictionary;
        }

        public PRIndirectReference getPageOrigRef(int n) {
            try {
                if (--n < 0 || n >= this.size()) {
                    return null;
                }
                if (this.refsn != null) {
                    return (PRIndirectReference)this.refsn.get(n);
                }
                int n2 = this.refsp.get(n);
                if (n2 == 0) {
                    PRIndirectReference pRIndirectReference = this.getSinglePage(n);
                    this.lastPageRead = this.reader.lastXrefPartial == -1 ? -1 : n;
                    this.reader.lastXrefPartial = -1;
                    this.refsp.put(n, pRIndirectReference.getNumber());
                    if (this.keepPages) {
                        this.lastPageRead = -1;
                    }
                    return pRIndirectReference;
                }
                if (this.lastPageRead != n) {
                    this.lastPageRead = -1;
                }
                if (this.keepPages) {
                    this.lastPageRead = -1;
                }
                return new PRIndirectReference(this.reader, n2);
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }

        public void releasePage(int n) {
            if (this.refsp == null) {
                return;
            }
            if (--n < 0 || n >= this.size()) {
                return;
            }
            if (n != this.lastPageRead) {
                return;
            }
            this.lastPageRead = -1;
            this.reader.lastXrefPartial = this.refsp.get(n);
            this.reader.releaseLastXrefPartial();
            this.refsp.remove(n);
        }

        /*
         * Unable to fully structure code
         */
        protected PRIndirectReference getSinglePage(int var1_1) {
            var2_2 = new PdfDictionary();
            var3_3 = this.reader.rootPages;
            var4_4 = 0;
            while (true) lbl-1000:
            // 5 sources

            {
                for (var5_6 = 0; var5_6 < PdfReader.pageInhCandidates.length; ++var5_6) {
                    var6_7 = var3_3.get(PdfReader.pageInhCandidates[var5_6]);
                    if (var6_7 == null) continue;
                    var2_2.put(PdfReader.pageInhCandidates[var5_6], (PdfObject)var6_7);
                }
                var5_5 = (PdfArray)PdfReader.getPdfObjectRelease(var3_3.get(PdfName.KIDS));
                var6_7 = var5_5.listIterator();
                while (true) {
                    if (!var6_7.hasNext()) ** continue;
                    var7_8 = (PRIndirectReference)var6_7.next();
                    var8_9 = (PdfDictionary)PdfReader.getPdfObject(var7_8);
                    var9_10 = PdfReader.access$300(this.reader);
                    var10_11 = PdfReader.getPdfObjectRelease(var8_9.get(PdfName.COUNT));
                    PdfReader.access$302(this.reader, var9_10);
                    var11_12 = 1;
                    if (var10_11 != null && var10_11.type() == 2) {
                        var11_12 = ((PdfNumber)var10_11).intValue();
                    }
                    if (var1_1 < var4_4 + var11_12) {
                        if (var10_11 == null) {
                            var8_9.mergeDifferent(var2_2);
                            return var7_8;
                        }
                        this.reader.releaseLastXrefPartial();
                        var3_3 = var8_9;
                        ** continue;
                    }
                    this.reader.releaseLastXrefPartial();
                    var4_4 += var11_12;
                }
                break;
            }
        }
    }
}

