/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.internal.PdfViewerPreferencesImp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

class PdfStamperImp
extends PdfWriter {
    HashMap readers2intrefs;
    HashMap readers2file;
    RandomAccessFileOrArray file;
    PdfReader reader;
    IntHashtable myXref;
    protected AcroFields acroFields;
    protected boolean useVp;
    protected PdfViewerPreferencesImp viewerPreferences;
    protected HashMap fieldTemplates;
    protected boolean fieldsAdded;
    protected int sigFlags;
    protected boolean append;
    protected IntHashtable marked;
    protected int initialXrefSize;
    protected PdfAction openAction;

    protected int getNewObjectNumber(PdfReader pdfReader, int n, int n2) {
        IntHashtable intHashtable = (IntHashtable)this.readers2intrefs.get(pdfReader);
        if (intHashtable != null) {
            int n3 = intHashtable.get(n);
            if (n3 == 0) {
                n3 = this.getIndirectReferenceNumber();
                intHashtable.put(n, n3);
            }
            return n3;
        }
        if (this.currentPdfReaderInstance == null) {
            if (this.append && n < this.initialXrefSize) {
                return n;
            }
            int n4 = this.myXref.get(n);
            if (n4 == 0) {
                n4 = this.getIndirectReferenceNumber();
                this.myXref.put(n, n4);
            }
            return n4;
        }
        return this.currentPdfReaderInstance.getNewObjectNumber(n, n2);
    }

    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        if (this.readers2intrefs.containsKey(pdfReader)) {
            RandomAccessFileOrArray randomAccessFileOrArray = (RandomAccessFileOrArray)this.readers2file.get(pdfReader);
            if (randomAccessFileOrArray != null) {
                return randomAccessFileOrArray;
            }
            return pdfReader.getSafeFile();
        }
        if (this.currentPdfReaderInstance == null) {
            return this.file;
        }
        return this.currentPdfReaderInstance.getReaderFile();
    }

    AcroFields getAcroFields() {
        if (this.acroFields == null) {
            this.acroFields = new AcroFields(this.reader, this);
        }
        return this.acroFields;
    }

    public PdfIndirectReference getPageReference(int n) {
        PRIndirectReference pRIndirectReference = this.reader.getPageOrigRef(n);
        if (pRIndirectReference == null) {
            throw new IllegalArgumentException("Invalid page number " + n);
        }
        return pRIndirectReference;
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        throw new RuntimeException("Unsupported in this context. Use PdfStamper.addAnnotation()");
    }

    void addDocumentField(PdfIndirectReference pdfIndirectReference) {
        PdfArray pdfArray;
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ACROFORM), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.ACROFORM, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        if ((pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.FIELDS), pdfDictionary2)) == null) {
            pdfArray = new PdfArray();
            pdfDictionary2.put(PdfName.FIELDS, pdfArray);
            this.markUsed(pdfDictionary2);
        }
        if (!pdfDictionary2.contains(PdfName.DA)) {
            pdfDictionary2.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
            this.markUsed(pdfDictionary2);
        }
        pdfArray.add(pdfIndirectReference);
        this.markUsed(pdfArray);
    }

    void expandFields(PdfFormField pdfFormField, ArrayList arrayList) {
        arrayList.add(pdfFormField);
        ArrayList arrayList2 = pdfFormField.getKids();
        if (arrayList2 != null) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                this.expandFields((PdfFormField)arrayList2.get(i), arrayList);
            }
        }
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, PdfDictionary pdfDictionary) {
        try {
            ArrayList<PdfAnnotation> arrayList = new ArrayList<PdfAnnotation>();
            if (pdfAnnotation.isForm()) {
                this.fieldsAdded = true;
                this.getAcroFields();
                PdfFormField pdfFormField = (PdfFormField)pdfAnnotation;
                if (pdfFormField.getParent() != null) {
                    return;
                }
                this.expandFields(pdfFormField, arrayList);
            } else {
                arrayList.add(pdfAnnotation);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object;
                pdfAnnotation = (PdfAnnotation)arrayList.get(i);
                if (pdfAnnotation.getPlaceInPage() > 0) {
                    pdfDictionary = this.reader.getPageN(pdfAnnotation.getPlaceInPage());
                }
                if (pdfAnnotation.isForm()) {
                    if (!pdfAnnotation.isUsed() && (object = pdfAnnotation.getTemplates()) != null) {
                        this.fieldTemplates.putAll(object);
                    }
                    if (((PdfFormField)(object = (PdfFormField)pdfAnnotation)).getParent() == null) {
                        this.addDocumentField(((PdfAnnotation)object).getIndirectReference());
                    }
                }
                if (pdfAnnotation.isAnnotation()) {
                    PdfRectangle pdfRectangle;
                    object = PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS), pdfDictionary);
                    PdfArray pdfArray = null;
                    if (object == null || !((PdfObject)object).isArray()) {
                        pdfArray = new PdfArray();
                        pdfDictionary.put(PdfName.ANNOTS, pdfArray);
                        this.markUsed(pdfDictionary);
                    } else {
                        pdfArray = (PdfArray)object;
                    }
                    pdfArray.add(pdfAnnotation.getIndirectReference());
                    this.markUsed(pdfArray);
                    if (!(pdfAnnotation.isUsed() || (pdfRectangle = (PdfRectangle)pdfAnnotation.get(PdfName.RECT)) == null || pdfRectangle.left() == 0.0f && pdfRectangle.right() == 0.0f && pdfRectangle.top() == 0.0f && pdfRectangle.bottom() == 0.0f)) {
                        int n = this.reader.getPageRotation(pdfDictionary);
                        Rectangle rectangle = this.reader.getPageSizeWithRotation(pdfDictionary);
                        switch (n) {
                            case 90: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.getTop() - pdfRectangle.bottom(), pdfRectangle.left(), rectangle.getTop() - pdfRectangle.top(), pdfRectangle.right()));
                                break;
                            }
                            case 180: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.getRight() - pdfRectangle.left(), rectangle.getTop() - pdfRectangle.bottom(), rectangle.getRight() - pdfRectangle.right(), rectangle.getTop() - pdfRectangle.top()));
                                break;
                            }
                            case 270: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(pdfRectangle.bottom(), rectangle.getRight() - pdfRectangle.left(), pdfRectangle.top(), rectangle.getRight() - pdfRectangle.right()));
                            }
                        }
                    }
                }
                if (pdfAnnotation.isUsed()) continue;
                pdfAnnotation.setUsed();
                this.addToBody((PdfObject)pdfAnnotation, pdfAnnotation.getIndirectReference());
            }
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, int n) {
        pdfAnnotation.setPage(n);
        this.addAnnotation(pdfAnnotation, this.reader.getPageN(n));
    }

    public void setViewerPreferences(int n) {
        this.useVp = true;
        this.viewerPreferences.setViewerPreferences(n);
    }

    public void addViewerPreference(PdfName pdfName, PdfObject pdfObject) {
        this.useVp = true;
        this.viewerPreferences.addViewerPreference(pdfName, pdfObject);
    }

    public void setSigFlags(int n) {
        this.sigFlags |= n;
    }

    public void setPageAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    public void setDuration(int n) {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    public void setTransition(PdfTransition pdfTransition) {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    protected void markUsed(PdfObject pdfObject) {
        if (this.append && pdfObject != null) {
            PRIndirectReference pRIndirectReference = null;
            pRIndirectReference = pdfObject.type() == 10 ? (PRIndirectReference)pdfObject : pdfObject.getIndRef();
            if (pRIndirectReference != null) {
                this.marked.put(pRIndirectReference.getNumber(), 1);
            }
        }
    }

    boolean isAppend() {
        return this.append;
    }

    public void setAdditionalAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        if (!(pdfName.equals(DOCUMENT_CLOSE) || pdfName.equals(WILL_SAVE) || pdfName.equals(DID_SAVE) || pdfName.equals(WILL_PRINT) || pdfName.equals(DID_PRINT))) {
            throw new PdfException("Invalid additional action type: " + pdfName.toString());
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog().getAsDict(PdfName.AA);
        if (pdfDictionary == null) {
            if (pdfAction == null) {
                return;
            }
            pdfDictionary = new PdfDictionary();
            this.reader.getCatalog().put(PdfName.AA, pdfDictionary);
        }
        this.markUsed(pdfDictionary);
        if (pdfAction == null) {
            pdfDictionary.remove(pdfName);
        } else {
            pdfDictionary.put(pdfName, pdfAction);
        }
    }

    public void setOpenAction(PdfAction pdfAction) {
        this.openAction = pdfAction;
    }

    public void setOpenAction(String string) {
        throw new UnsupportedOperationException("Open actions by name are not supported.");
    }

    public void setThumbnail(Image image) {
        throw new UnsupportedOperationException("Use PdfStamper.setThumbnail().");
    }

    public PdfContentByte getDirectContentUnder() {
        throw new UnsupportedOperationException("Use PdfStamper.getUnderContent() or PdfStamper.getOverContent()");
    }

    public PdfContentByte getDirectContent() {
        throw new UnsupportedOperationException("Use PdfStamper.getUnderContent() or PdfStamper.getOverContent()");
    }
}

