/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;

public class Range
implements Comparable<Range> {
    public long[] r;
    public int sz;
    protected static final ValueIterator EMPTY_ITER = new ValueIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public long next() {
            throw new NoSuchElementException();
        }
    };

    @Override
    public int compareTo(Range o1) {
        long nval1;
        long nval0 = this.nval();
        return nval0 > (nval1 = o1.nval()) ? 1 : (nval0 < nval1 ? -1 : 0);
    }

    public Range(long[] buf) {
        this(buf, buf.length);
    }

    public Range(long[] buf, int size) {
        this.r = buf;
        this.sz = size;
    }

    public void sortAndFix() {
        ArrayList<Ran> list = new ArrayList<Ran>(this.sz);
        int j = 0;
        while (j < this.sz) {
            list.add(new Ran(this.r[j], this.r[j + 1]));
            j += 2;
        }
        Collections.sort(list);
        long[] r1 = new long[list.size() * 2];
        long min = -1L;
        long max = -1L;
        int n = 0;
        for (Ran ran : list) {
            if (ran.min > max) {
                if (max != -1L) {
                    r1[n++] = min;
                    r1[n++] = max;
                }
                min = ran.min;
                max = ran.max;
                continue;
            }
            if (ran.max <= max) continue;
            max = ran.max;
        }
        if (max != -1L) {
            r1[n++] = min;
            r1[n++] = max;
        }
        this.r = r1;
        this.sz = n;
    }

    public long getMem() {
        return this.r == null ? 0L : (long)this.r.length * 8L;
    }

    public Range degrade(int shift) {
        if (shift == 0) {
            return new Range(this);
        }
        Range r1 = new Range(this.sz / 2);
        long mask = -1L << shift;
        int i = 0;
        while (i < this.sz) {
            long a = this.r[i] & mask;
            long b = (this.r[i + 1] - 1L >>> shift) + 1L << shift;
            r1.append(a, b);
            i += 2;
        }
        r1.trimIfTooLarge();
        return r1;
    }

    public Range() {
        this(4);
    }

    public Range(int cap) {
        if (cap < 0) {
            throw new IllegalArgumentException("capacity must be positive");
        }
        this.r = new long[cap << 1];
        this.sz = 0;
    }

    public Range(Range other) {
        this.sz = other.sz;
        this.r = new long[this.sz];
        System.arraycopy(other.r, 0, this.r, 0, this.sz);
    }

    public void checkConsistency() {
        if ((this.sz & 1) != 0) {
            throw new IllegalArgumentException("invalid number of entries");
        }
        int i = 1;
        while (i < this.sz) {
            if (this.r[i] <= this.r[i - 1]) {
                throw new IllegalArgumentException("inconsistent entries");
            }
            ++i;
        }
    }

    public void resize(int newsize) {
        if (newsize < this.sz) {
            throw new IllegalArgumentException("requested array size too small");
        }
        if (newsize == this.r.length) {
            return;
        }
        long[] nRange = new long[newsize];
        System.arraycopy(this.r, 0, nRange, 0, this.sz);
        this.r = nRange;
    }

    public void ensureCapacity(int cap) {
        if (this.r.length < cap) {
            this.resize(Math.max(2 * this.r.length, cap));
        }
    }

    public void trimSize() {
        this.resize(this.sz);
    }

    public void trimIfTooLarge() {
        if (this.r.length - this.sz >= this.sz) {
            this.resize(this.sz);
        }
    }

    public int indexOf(long val) {
        int count = this.sz;
        int first = 0;
        while (count > 0) {
            int step = count >>> 1;
            int it = first + step;
            if (this.r[it] <= val) {
                first = ++it;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first - 1;
    }

    public void append(long val) {
        this.append(val, val + 1L);
    }

    public void append(long a, long b) {
        if (a >= b) {
            return;
        }
        if (this.sz > 0 && a <= this.r[this.sz - 1]) {
            if (a < this.r[this.sz - 2]) {
                throw new IllegalArgumentException("bad append operation");
            }
            if (b > this.r[this.sz - 1]) {
                this.r[this.sz - 1] = b;
            }
            return;
        }
        this.ensureCapacity(this.sz + 2);
        this.r[this.sz++] = a;
        this.r[this.sz++] = b;
    }

    public void append(Range other) {
        int i = 0;
        while (i < other.sz) {
            this.append(other.r[i], other.r[i + 1]);
            i += 2;
        }
    }

    public int nranges() {
        return this.sz >>> 1;
    }

    public boolean isEmpty() {
        return this.sz == 0;
    }

    public long begins(int i) {
        return this.r[2 * i];
    }

    public long ends(int i) {
        return this.r[2 * i + 1];
    }

    public void clear() {
        this.sz = 0;
    }

    public void push(long v) {
        this.ensureCapacity(this.sz + 1);
        this.r[this.sz++] = v;
    }

    protected static int strategy(int sza, int szb) {
        int shi;
        double fct1 = 1.0;
        double fct2 = 1.0;
        double cost1 = 1.0 * (double)(sza + szb);
        int slo = sza < szb ? sza : szb;
        double cost2 = 1.0 * (double)slo * Math.max(1.0, (double)Range.ilog2(shi = sza < szb ? szb : sza));
        return cost1 <= cost2 ? 1 : (slo == sza ? 2 : 3);
    }

    public static int ilog2(long arg) {
        return 63 - Long.numberOfLeadingZeros(Math.max(arg, 1L));
    }

    private static boolean generalAllOrNothing1(Range a, Range b, boolean flip_a, boolean flip_b) {
        boolean state_a = flip_a;
        boolean state_b = flip_b;
        boolean state_res = state_a || state_b;
        int ia = 0;
        int ea = a.sz;
        int ib = 0;
        int eb = b.sz;
        boolean runa = ia != ea;
        boolean runb = ib != eb;
        while (runa || runb) {
            boolean adv_b;
            long va = runa ? a.r[ia] : 0L;
            long vb = runb ? b.r[ib] : 0L;
            boolean adv_a = runa && (!runb || va <= vb);
            boolean bl = adv_b = runb && (!runa || vb <= va);
            if (adv_a) {
                state_a = !state_a;
                boolean bl2 = runa = ++ia != ea;
            }
            if (adv_b) {
                state_b = !state_b;
                runb = ++ib != eb;
            }
            if ((state_a || state_b) == state_res) continue;
            return false;
        }
        return true;
    }

    private static boolean generalAllOrNothing2(Range a, Range b, boolean flip_a, boolean flip_b) {
        int iva = flip_a ? 0 : -1;
        while (iva < a.sz) {
            if (iva == -1) {
                if (!flip_b || b.r[0] < a.r[0]) {
                    return false;
                }
            } else if (iva == a.sz - 1) {
                if (!flip_b || b.r[b.sz - 1] > a.r[a.sz - 1]) {
                    return false;
                }
            } else {
                int ivb = b.indexOf(a.r[iva]);
                if (ivb != b.sz - 1 && b.r[ivb + 1] < a.r[iva + 1]) {
                    return false;
                }
                if (flip_b == ((ivb & 1) == 0)) {
                    return false;
                }
            }
            iva += 2;
        }
        return true;
    }

    protected static boolean generalAllOrNothing(Range a, Range b, boolean flip_a, boolean flip_b) {
        if (a.isEmpty()) {
            return flip_a ? true : b.isEmpty();
        }
        if (b.isEmpty()) {
            return flip_b ? true : a.isEmpty();
        }
        int strat = Range.strategy(a.nranges(), b.nranges());
        return strat == 1 ? Range.generalAllOrNothing1(a, b, flip_a, flip_b) : (strat == 2 ? Range.generalAllOrNothing2(a, b, flip_a, flip_b) : Range.generalAllOrNothing2(b, a, flip_b, flip_a));
    }

    private static Range generalUnion1(Range a, Range b, boolean flip_a, boolean flip_b) {
        Range res = new Range();
        boolean state_a = flip_a;
        boolean state_b = flip_b;
        boolean state_res = state_a || state_b;
        int ia = 0;
        int ea = a.sz;
        int ib = 0;
        int eb = b.sz;
        boolean runa = ia != ea;
        boolean runb = ib != eb;
        while (runa || runb) {
            boolean adv_b;
            long va = runa ? a.r[ia] : 0L;
            long vb = runb ? b.r[ib] : 0L;
            boolean adv_a = runa && (!runb || va <= vb);
            boolean bl = adv_b = runb && (!runa || vb <= va);
            if (adv_a) {
                state_a = !state_a;
                boolean bl2 = runa = ++ia != ea;
            }
            if (adv_b) {
                state_b = !state_b;
                runb = ++ib != eb;
            }
            if ((state_a || state_b) == state_res) continue;
            res.push(adv_a ? va : vb);
            boolean bl3 = state_res = !state_res;
        }
        return res;
    }

    private static Range generalUnion2(Range a, Range b, boolean flip_a, boolean flip_b) {
        Range res = new Range();
        int iva = flip_a ? 0 : -1;
        while (iva < a.sz) {
            int ivb = iva == -1 ? -1 : b.indexOf(a.r[iva]);
            boolean state_b = flip_b ^ (ivb & 1) == 0;
            if (iva > -1 && !state_b) {
                res.push(a.r[iva]);
            }
            while (ivb < b.sz - 1 && (iva == a.sz - 1 || b.r[ivb + 1] < a.r[iva + 1])) {
                state_b = !state_b;
                res.push(b.r[++ivb]);
            }
            if (iva < a.sz - 1 && !state_b) {
                res.push(a.r[iva + 1]);
            }
            iva += 2;
        }
        return res;
    }

    private static Range generalUnion(Range a, Range b, boolean flip_a, boolean flip_b) {
        if (a.isEmpty()) {
            return flip_a ? new Range() : new Range(b);
        }
        if (b.isEmpty()) {
            return flip_b ? new Range() : new Range(a);
        }
        int strat = Range.strategy(a.nranges(), b.nranges());
        return strat == 1 ? Range.generalUnion1(a, b, flip_a, flip_b) : (strat == 2 ? Range.generalUnion2(a, b, flip_a, flip_b) : Range.generalUnion2(b, a, flip_b, flip_a));
    }

    public Range complement(long min, long max) {
        Range r1 = new Range(this.sz / 2 + 1);
        if (this.sz == 0) {
            r1.sz = 2;
            r1.r[0] = min;
            r1.r[r1.sz - 1] = max;
        } else {
            boolean addMin = this.r[0] != min;
            boolean addMax = this.r[this.sz - 1] != max;
            int n = this.sz;
            if (!addMin) {
                --n;
            }
            if (!addMax) {
                --n;
            }
            System.arraycopy(this.r, addMin ? 0 : 1, r1.r, addMin ? 1 : 0, n);
            r1.sz = n + (addMin ? 1 : 0) + (addMax ? 1 : 0);
            if (addMin) {
                r1.r[0] = min;
            }
            if (addMax) {
                r1.r[r1.sz - 1] = max;
            }
        }
        return r1;
    }

    public Range union(Range other) {
        return Range.generalUnion(this, other, false, false);
    }

    public Range intersection(Range other) {
        return Range.generalUnion(this, other, true, true);
    }

    public Range difference(Range other) {
        return Range.generalUnion(this, other, true, false);
    }

    public boolean contains(Range other) {
        return Range.generalAllOrNothing(this, other, false, true);
    }

    public boolean overlaps(Range other) {
        return !Range.generalAllOrNothing(this, other, true, true);
    }

    public boolean contains(long a) {
        return (this.indexOf(a) & 1) == 0;
    }

    public boolean overlaps(long a, long b) {
        int res = this.indexOf(a);
        if ((res & 1) == 0) {
            return true;
        }
        if (res == this.sz - 1) {
            return false;
        }
        return this.r[res + 1] < b;
    }

    public boolean contains(long a, long b) {
        int res = this.indexOf(a);
        if ((res & 1) != 0) {
            return false;
        }
        return b <= this.r[res + 1];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        if (other.sz != this.sz) {
            return false;
        }
        int i = 0;
        while (i < this.sz) {
            if (other.r[i] != this.r[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        if (this.sz == 0) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < this.sz) {
            long element = this.r[i];
            result = 31 * result + (int)(element ^ element >>> 32);
            ++i;
        }
        return result;
    }

    public long nval() {
        long res = 0L;
        int i = 0;
        while (i < this.sz) {
            res += this.r[i + 1] - this.r[i];
            i += 2;
        }
        return res;
    }

    private void addRemove(long a, long b, int v) {
        boolean insert_a;
        int rmstart;
        boolean insert_b;
        int rmend;
        int pos1 = this.indexOf(a);
        int pos2 = this.indexOf(b);
        if (pos1 >= 0 && this.r[pos1] == a) {
            --pos1;
        }
        if (((rmend = pos2 - ((insert_b = (pos2 & 1) == v) ? 1 : 0)) - (rmstart = pos1 + 1 + ((insert_a = (pos1 & 1) == v) ? 1 : 0)) & 1) == 0) {
            throw new IllegalArgumentException("cannot happen: " + rmstart + " " + rmend);
        }
        if (insert_a && insert_b && pos1 + 1 > pos2) {
            this.ensureCapacity(this.sz + 2);
            System.arraycopy(this.r, pos1 + 1, this.r, pos1 + 3, this.sz - pos1 - 1);
            this.r[pos1 + 1] = a;
            this.r[pos1 + 2] = b;
            this.sz += 2;
        } else {
            if (insert_a) {
                this.r[pos1 + 1] = a;
            }
            if (insert_b) {
                this.r[pos2] = b;
            }
            if (rmstart != rmend + 1) {
                System.arraycopy(this.r, rmend + 1, this.r, rmstart, this.sz - rmend - 1);
            }
            this.sz -= rmend - rmstart + 1;
        }
    }

    public void add(Range m) {
        if (m.sz == 0) {
            return;
        }
        if (this.sz == 0 || m.r[0] >= this.r[this.sz - 1]) {
            this.append(m);
        } else {
            int i = 0;
            while (i < m.sz) {
                this.addRemove(m.r[i], m.r[i + 1], 1);
                i += 2;
            }
        }
    }

    public void add(long a, long b) {
        if (this.sz == 0 || a >= this.r[this.sz - 1]) {
            this.append(a, b);
        } else {
            this.addRemove(a, b, 1);
        }
    }

    public void add(long a) {
        if (this.sz == 0 || a >= this.r[this.sz - 1]) {
            this.append(a, a + 1L);
        } else {
            this.addRemove(a, a + 1L, 1);
        }
    }

    public void remove(long a, long b) {
        this.addRemove(a, b, 0);
    }

    public void remove(long a) {
        this.addRemove(a, a + 1L, 0);
    }

    public long[] toArray() throws Exception {
        long nval = this.nval();
        if (nval > Integer.MAX_VALUE) {
            throw new Exception("Too many values");
        }
        long[] res = new long[(int)nval];
        int ofs = 0;
        int i = 0;
        while (i < this.sz) {
            long j = this.r[i];
            while (j < this.r[i + 1]) {
                res[ofs++] = j++;
            }
            i += 2;
        }
        return res;
    }

    public static Range fromArray(long[] v) {
        Range res = new Range();
        int i = 0;
        while (i < v.length) {
            res.append(v[i]);
            ++i;
        }
        return res;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("{ ");
        int i = 0;
        while (i < this.sz) {
            s.append("[").append(this.r[i]).append(";").append(this.r[i + 1]).append("[");
            if (i < this.sz - 2) {
                s.append(",");
            }
            i += 2;
        }
        s.append(" }");
        return s.toString();
    }

    public ValueIterator valueIterator() {
        if (this.sz == 0) {
            return EMPTY_ITER;
        }
        return new ValueIterator(){
            int pos = 0;
            long value;
            {
                this.value = Range.this.sz > 0 ? Range.this.r[0] : 0L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < Range.this.sz;
            }

            @Override
            public long next() {
                if (this.pos > Range.this.sz) {
                    throw new NoSuchElementException();
                }
                long ret = this.value++;
                if (this.value == Range.this.r[this.pos + 1]) {
                    this.pos += 2;
                    if (this.pos < Range.this.sz) {
                        this.value = Range.this.r[this.pos];
                    }
                }
                return ret;
            }
        };
    }

    private class Ran
    implements Comparable<Ran> {
        long min;
        long max;

        Ran(long min, long max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public int compareTo(Ran o) {
            return o.min < this.min ? 2 : (o.min > this.min ? -2 : (o.max > this.max ? 1 : (o.max < this.max ? -1 : 0)));
        }
    }

    public static interface ValueIterator {
        public boolean hasNext();

        public long next();
    }
}

