/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ecsv;

import java.lang.reflect.Array;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONString;
import org.json.JSONTokener;

public abstract class EcsvDecoder<T> {
    private final Class<T> clazz_;
    private final int[] stilShape_;
    private final String msg_;
    private static final int[] SCALAR_SHAPE = null;

    protected EcsvDecoder(Class<T> clazz, int[] stilShape, String msg) {
        this.clazz_ = clazz;
        this.stilShape_ = stilShape;
        this.msg_ = msg;
    }

    public abstract T decode(String var1);

    public Class<T> getContentClass() {
        return this.clazz_;
    }

    public int[] getShape() {
        return this.stilShape_ == null ? null : (int[])this.stilShape_.clone();
    }

    public String getWarning() {
        return this.msg_;
    }

    public static EcsvDecoder<?> createDecoder(String datatype, String subtype) {
        String igMsg;
        String string = igMsg = subtype == null ? null : "Ignoring unrecognised/unsupported subtype \"" + subtype + "\" - treating as " + datatype;
        if ("int8".equals(datatype)) {
            return EcsvDecoder.createDecoder(Byte.class, SCALAR_SHAPE, igMsg, Byte::valueOf, EcsvDecoder::resemblesInt);
        }
        if ("int16".equals(datatype) || "uint8".equals(datatype)) {
            return EcsvDecoder.createDecoder(Short.class, SCALAR_SHAPE, igMsg, Short::valueOf, EcsvDecoder::resemblesInt);
        }
        if ("int32".equals(datatype) || "uint16".equals(datatype)) {
            return EcsvDecoder.createDecoder(Integer.class, SCALAR_SHAPE, igMsg, Integer::valueOf, EcsvDecoder::resemblesInt);
        }
        if ("int64".equals(datatype) || "uint32".equals(datatype)) {
            return EcsvDecoder.createDecoder(Long.class, SCALAR_SHAPE, igMsg, Long::valueOf, EcsvDecoder::resemblesInt);
        }
        if ("float32".equals(datatype)) {
            return EcsvDecoder.createDecoder(Float.class, SCALAR_SHAPE, igMsg, EcsvDecoder::parseFloat);
        }
        if ("float64".equals(datatype)) {
            return EcsvDecoder.createDecoder(Double.class, SCALAR_SHAPE, igMsg, EcsvDecoder::parseDouble);
        }
        if ("bool".equals(datatype)) {
            return EcsvDecoder.createDecoder(Boolean.class, SCALAR_SHAPE, igMsg, txt -> {
                if ("True".equals(txt)) {
                    return Boolean.TRUE;
                }
                if ("False".equals(txt)) {
                    return Boolean.FALSE;
                }
                if (txt.equalsIgnoreCase("true") || txt.equalsIgnoreCase("T")) {
                    return Boolean.TRUE;
                }
                if (txt.equalsIgnoreCase("false") || txt.equalsIgnoreCase("F")) {
                    return Boolean.FALSE;
                }
                return null;
            });
        }
        if ("string".equals(datatype)) {
            ArrayType arraytype = EcsvDecoder.parseArraytype(subtype);
            if (arraytype != null) {
                String eltype = arraytype.elementType_;
                int[] stilShape = arraytype.stilShape_;
                if (stilShape == null) {
                    String msg = "Can't cope with variable-length higher dimensions (" + subtype + ") - treat as " + datatype;
                    return EcsvDecoder.createDecoder(String.class, SCALAR_SHAPE, msg, Function.identity());
                }
                if ("int8".equals(eltype)) {
                    return EcsvDecoder.createArrayDecoder(byte[].class, stilShape, (arr, i, jobj) -> {
                        arr[i] = jobj instanceof Number ? ((Number)jobj).byteValue() : (byte)0;
                    });
                }
                if ("int16".equals(eltype) || "uint8".equals(eltype)) {
                    return EcsvDecoder.createArrayDecoder(short[].class, stilShape, (arr, i, jobj) -> {
                        arr[i] = jobj instanceof Number ? ((Number)jobj).shortValue() : (short)0;
                    });
                }
                if ("int32".equals(eltype) || "uint16".equals(eltype)) {
                    return EcsvDecoder.createArrayDecoder(int[].class, stilShape, (arr, i, jobj) -> {
                        arr[i] = jobj instanceof Number ? ((Number)jobj).intValue() : 0;
                    });
                }
                if ("int64".equals(eltype) || "uint32".equals(eltype)) {
                    return EcsvDecoder.createArrayDecoder(long[].class, stilShape, (arr, i, jobj) -> {
                        arr[i] = jobj instanceof Number ? ((Number)jobj).longValue() : 0L;
                    });
                }
                if ("float32".equals(eltype)) {
                    return EcsvDecoder.createArrayDecoder(float[].class, stilShape, (arr, i, jobj) -> {
                        arr[i] = jobj instanceof Number ? ((Number)jobj).floatValue() : Float.NaN;
                    });
                }
                if ("float64".equals(eltype)) {
                    return EcsvDecoder.createArrayDecoder(double[].class, stilShape, (arr, i, jobj) -> {
                        arr[i] = jobj instanceof Number ? ((Number)jobj).doubleValue() : Double.NaN;
                    });
                }
                if ("bool".equals(eltype)) {
                    return EcsvDecoder.createArrayDecoder(boolean[].class, stilShape, (arr, i, jobj) -> {
                        arr[i] = jobj instanceof Boolean ? (Boolean)jobj : false;
                    });
                }
                if ("string".equals(eltype)) {
                    return EcsvDecoder.createArrayDecoder(String[].class, stilShape, (arr, i, jobj) -> {
                        arr[i] = jobj instanceof JSONString || jobj instanceof String ? jobj.toString() : null;
                    });
                }
                return EcsvDecoder.createDecoder(String.class, SCALAR_SHAPE, igMsg, Function.identity());
            }
            return EcsvDecoder.createDecoder(String.class, SCALAR_SHAPE, igMsg, Function.identity());
        }
        if ("float128".equals(datatype) || "complex64".equals(datatype) || "complex128".equals(datatype) || "complex256".equals(datatype)) {
            return EcsvDecoder.createDecoder(String.class, SCALAR_SHAPE, "Unsupported ECSV type \"" + datatype + "\" - treating as string", Function.identity());
        }
        return EcsvDecoder.createDecoder(String.class, SCALAR_SHAPE, "Unknown ECSV type \"" + datatype + "\" - treating as string", Function.identity());
    }

    private static ArrayType parseArraytype(String subtype) {
        if (subtype == null || subtype.trim().length() == 0) {
            return null;
        }
        Matcher stMatcher = Pattern.compile("\\s*([a-zA-Z0-9]+)\\s*\\[(.*)\\]\\s*").matcher(subtype);
        if (stMatcher.matches()) {
            String elType = stMatcher.group(1);
            String dimsTxt = stMatcher.group(2);
            String[] dimTxts = dimsTxt.trim().split("\\s*,\\s*", -1);
            int ndim = dimTxts.length;
            int[] dims = new int[ndim];
            for (int i = 0; i < ndim; ++i) {
                int dim;
                String dimTxt = dimTxts[i];
                if ("null".equals(dimTxt)) {
                    dim = -1;
                } else if (dimTxt.matches("[1-9][0-9]*")) {
                    dim = Integer.parseInt(dimTxt);
                } else {
                    return null;
                }
                dims[ndim - 1 - i] = dim;
            }
            boolean isLegalStil = true;
            for (int idim = 0; idim < dims.length - 1; ++idim) {
                if (dims[idim] >= 0) continue;
                isLegalStil = false;
            }
            return new ArrayType(elType, (int[])(isLegalStil ? dims : null));
        }
        return null;
    }

    private static <T> EcsvDecoder<T> createDecoder(Class<T> clazz, int[] stilShape, String msg, final Function<String, T> decode) {
        return new EcsvDecoder<T>(clazz, stilShape, msg){

            @Override
            public T decode(String txt) {
                return decode.apply(txt);
            }
        };
    }

    private static <T> EcsvDecoder<T> createDecoder(Class<T> clazz, int[] stilShape, String msg, final Function<String, T> decode, final Predicate<String> isPlausible) {
        return new EcsvDecoder<T>(clazz, stilShape, msg){

            @Override
            public T decode(String txt) {
                return isPlausible.test(txt) ? (Object)decode.apply(txt) : null;
            }
        };
    }

    private static boolean resemblesInt(String txt) {
        int len = txt.length();
        if (len == 0) {
            return false;
        }
        block3: for (int i = 0; i < len; ++i) {
            switch (txt.charAt(i)) {
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean resemblesFloat(String txt) {
        int len = txt.length();
        if (len == 0) {
            return false;
        }
        block3: for (int i = 0; i < len; ++i) {
            switch (txt.charAt(i)) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'E': 
                case 'e': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private static Float parseFloat(String txt) {
        if ("inf".equals(txt)) {
            return Float.valueOf(Float.POSITIVE_INFINITY);
        }
        if ("-inf".equals(txt)) {
            return Float.valueOf(Float.NEGATIVE_INFINITY);
        }
        return EcsvDecoder.resemblesFloat(txt) ? Float.valueOf(txt) : null;
    }

    private static Double parseDouble(String txt) {
        if ("inf".equals(txt)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-inf".equals(txt)) {
            return Double.NEGATIVE_INFINITY;
        }
        return EcsvDecoder.resemblesFloat(txt) ? Double.valueOf(txt) : null;
    }

    private static <T> EcsvDecoder<?> createArrayDecoder(Class<T> aclazz, int[] stilShape, ElementStore<T> storage) {
        int ndim = stilShape.length;
        int nel = 1;
        boolean isFixed = true;
        for (int idim = 0; idim < ndim; ++idim) {
            int dim = stilShape[idim];
            nel *= Math.abs(dim);
            isFixed = isFixed && dim > 0;
        }
        boolean isFixed0 = isFixed;
        int nel0 = nel;
        Class<?> compType = aclazz.getComponentType();
        String msg = null;
        if (ndim == 1) {
            return EcsvDecoder.createDecoder(aclazz, stilShape, msg, txt -> {
                if (txt == null || txt.trim().length() == 0) {
                    return null;
                }
                Object jvalue = new JSONTokener(txt).nextValue();
                if (jvalue instanceof JSONArray) {
                    int count;
                    int aleng;
                    JSONArray jarray = (JSONArray)jvalue;
                    int jleng = jarray.length();
                    if (isFixed0) {
                        aleng = nel0;
                        count = Math.min(aleng, jleng);
                    } else {
                        count = aleng = jleng;
                    }
                    Object array = aclazz.cast(Array.newInstance(compType, aleng));
                    for (int i = 0; i < count; ++i) {
                        storage.writeElement(array, i, jarray.get(i));
                    }
                    return array;
                }
                return null;
            });
        }
        if (isFixed) {
            return EcsvDecoder.createDecoder(aclazz, stilShape, msg, txt -> {
                if (txt == null || txt.trim().length() == 0) {
                    return null;
                }
                Object jvalue = new JSONTokener(txt).nextValue();
                if (jvalue instanceof JSONArray) {
                    JSONArray jarray = (JSONArray)jvalue;
                    Object array = aclazz.cast(Array.newInstance(compType, nel0));
                    EcsvDecoder.writeArray(array, storage, jarray, new int[1]);
                    return array;
                }
                return null;
            });
        }
        assert (false);
        return null;
    }

    private static <T> void writeArray(T array, ElementStore<T> storage, JSONArray jarray, int[] ipos) {
        int nel = jarray.length();
        Object jobj0 = jarray.get(0);
        if (jobj0 instanceof JSONArray) {
            int[] ipos1 = (int[])ipos.clone();
            for (int i = 0; i < nel; ++i) {
                EcsvDecoder.writeArray(array, storage, (JSONArray)jarray.get(i), ipos);
            }
        } else {
            for (int i = 0; i < nel; ++i) {
                int n = ipos[0];
                ipos[0] = n + 1;
                storage.writeElement(array, n, jarray.get(i));
            }
        }
    }

    private static class ArrayType {
        final String elementType_;
        final int[] stilShape_;

        ArrayType(String elementType, int[] stilShape) {
            this.elementType_ = elementType;
            this.stilShape_ = stilShape == null ? null : (int[])stilShape.clone();
        }
    }

    @FunctionalInterface
    private static interface ElementStore<T> {
        public void writeElement(T var1, int var2, Object var3);
    }
}

