/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ecsv;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Pattern;
import uk.ac.starlink.ecsv.EcsvFormatException;
import uk.ac.starlink.ecsv.LineReader;

public class EcsvHeader {
    private final String[] yamlLines_;
    private final String namesLine_;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Pattern MAGIC_REGEX = Pattern.compile("#\\s+%ECSV\\s+[0-9]+[.][0-9]+\\s*");
    private static final Pattern YAMLSTART_REGEX = Pattern.compile("---\\s*");

    public EcsvHeader(String[] yamlLines, String namesLine) {
        this.yamlLines_ = yamlLines;
        this.namesLine_ = namesLine;
    }

    public String[] getYamlLines() {
        return this.yamlLines_;
    }

    public String getNamesLine() {
        return this.namesLine_;
    }

    public static EcsvHeader readHeader(LineReader rdr) throws IOException, EcsvFormatException {
        String line;
        String line0 = rdr.readLine();
        if (!EcsvHeader.isMagic(line0.getBytes(UTF8))) {
            throw new EcsvFormatException("No ECSV identifier line");
        }
        boolean isStarted = false;
        ArrayList<String> yamlLines = new ArrayList<String>();
        while ((line = rdr.readLine()) != null) {
            if (line.length() >= 2 && line.charAt(0) == '#' && line.charAt(1) == ' ') {
                String content = line.substring(2);
                if (isStarted) {
                    yamlLines.add(content);
                    continue;
                }
                if (!YAMLSTART_REGEX.matcher(content).matches()) continue;
                yamlLines.add(content);
                isStarted = true;
                continue;
            }
            if (line.length() == 1 && line.charAt(0) == '#') continue;
            if (isStarted) {
                return new EcsvHeader(yamlLines.toArray(new String[0]), line);
            }
            throw new EcsvFormatException("No YAML --- delimiter");
        }
        throw new EcsvFormatException("No post-YAML ECSV content");
    }

    public static boolean isMagic(byte[] intro) {
        return MAGIC_REGEX.matcher(new String(intro, UTF8)).lookingAt();
    }
}

