/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ecsv;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.ecsv.EcsvColumn;
import uk.ac.starlink.ecsv.EcsvDecoder;
import uk.ac.starlink.ecsv.EcsvMeta;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;

public abstract class EcsvStarTable
extends AbstractStarTable {
    private final ColumnInfo[] colInfos_;
    public static final ValueInfo CFORMAT_INFO = new DefaultValueInfo("C_FORMAT", String.class, "Printf-style format string");
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ecsv");

    protected EcsvStarTable(EcsvMeta meta) {
        EcsvColumn<?>[] ecols = meta.getColumns();
        int ncol = ecols.length;
        this.colInfos_ = new ColumnInfo[ncol];
        for (int ic = 0; ic < ncol; ++ic) {
            this.colInfos_[ic] = EcsvStarTable.toColumnInfo(ecols[ic]);
        }
        Map<?, ?> tableMeta = meta.getTableMeta();
        if (tableMeta != null) {
            for (Map.Entry<?, ?> entry : tableMeta.entrySet()) {
                if ("name".equals(entry.getKey()) && entry.getValue() instanceof String) {
                    this.setName((String)entry.getValue());
                    continue;
                }
                DescribedValue dval = EcsvStarTable.toDescribedValue(entry);
                if (dval == null) continue;
                this.setParameter(dval);
            }
        }
    }

    @Override
    public int getColumnCount() {
        return this.colInfos_.length;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    @Override
    public long getRowCount() {
        return -1L;
    }

    private static ColumnInfo toColumnInfo(EcsvColumn<?> ecol) {
        Map<?, ?> meta;
        String format;
        String unit;
        EcsvDecoder<?> decoder = ecol.getDecoder();
        Class<?> clazz = decoder.getContentClass();
        ColumnInfo cinfo = new ColumnInfo(ecol.getName(), clazz, ecol.getDescription());
        int[] shape = decoder.getShape();
        if (shape != null) {
            cinfo.setShape(shape);
        }
        if ((unit = ecol.getUnit()) != null && unit.trim().length() > 0) {
            cinfo.setUnitString(unit);
        }
        if ((format = ecol.getFormat()) != null && format.trim().length() > 0) {
            cinfo.setAuxDatum(new DescribedValue(CFORMAT_INFO, format));
        }
        if ("uint8".equals(ecol.getDatatype()) && Short.class.equals(clazz)) {
            cinfo.setAuxDatum(new DescribedValue(Tables.UBYTE_FLAG_INFO, Boolean.TRUE));
        }
        if ((meta = ecol.getMeta()) != null) {
            Object xtypeObj;
            Object utypeObj;
            Object ucdObj = (meta = new LinkedHashMap(meta)).remove("ucd");
            if (ucdObj instanceof String) {
                cinfo.setUCD((String)ucdObj);
            }
            if ((utypeObj = meta.remove("utype")) instanceof String) {
                cinfo.setUtype((String)utypeObj);
            }
            if ((xtypeObj = meta.remove("xtype")) instanceof String) {
                cinfo.setXtype((String)xtypeObj);
            }
            for (Map.Entry<?, ?> entry : meta.entrySet()) {
                DescribedValue dval = EcsvStarTable.toDescribedValue(entry);
                if (dval == null) continue;
                cinfo.setAuxDatum(dval);
            }
        }
        return cinfo;
    }

    private static DescribedValue toDescribedValue(Map.Entry<?, ?> metaEntry) {
        Object key = metaEntry.getKey();
        Object rawValue = metaEntry.getValue();
        if (key instanceof String && rawValue != null) {
            String name = (String)key;
            Object value = EcsvStarTable.toMetaValue(rawValue);
            if (value != null) {
                Class<?> clazz = value.getClass();
                String descrip = name + " value from ECSV meta structure";
                DefaultValueInfo info = new DefaultValueInfo(name, clazz, descrip);
                return new DescribedValue(info, value);
            }
            logger_.info("Ignore metadata item " + name + " of unsupported type " + rawValue.getClass());
        }
        return null;
    }

    private static Object toMetaValue(Object rawValue) {
        if (rawValue == null) {
            return null;
        }
        if (rawValue instanceof Number || rawValue instanceof Boolean || rawValue instanceof String) {
            return rawValue;
        }
        if (rawValue instanceof byte[] || rawValue instanceof short[] || rawValue instanceof int[] || rawValue instanceof long[] || rawValue instanceof float[] || rawValue instanceof double[] || rawValue instanceof String[]) {
            return rawValue;
        }
        if (rawValue instanceof List) {
            return EcsvStarTable.toMetaArray(((List)rawValue).toArray());
        }
        Class<?> componentClass = rawValue.getClass().getComponentType();
        if (componentClass != null && Object.class.isAssignableFrom(componentClass)) {
            return EcsvStarTable.toMetaArray((Object[])rawValue);
        }
        return null;
    }

    private static Object toMetaArray(Object[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        int n = array.length;
        if (EcsvStarTable.isAllType(array, new Class[]{String.class})) {
            String[] strArray = new String[n];
            for (int i = 0; i < n; ++i) {
                strArray[i] = (String)array[i];
            }
            return strArray;
        }
        if (EcsvStarTable.isAllType(array, new Class[]{Integer.class, Short.class, Byte.class})) {
            int[] iArray = new int[n];
            for (int i = 0; i < n; ++i) {
                iArray[i] = ((Number)array[i]).intValue();
            }
            return iArray;
        }
        if (EcsvStarTable.isAllType(array, new Class[]{Number.class})) {
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = ((Number)array[i]).doubleValue();
            }
            return dArray;
        }
        return null;
    }

    private static boolean isAllType(Object[] array, Class<?>[] clazzes) {
        for (Object el : array) {
            boolean isType = false;
            if (el != null) {
                Class<?> elc = el.getClass();
                for (Class<?> clazz : clazzes) {
                    if (!clazz.isAssignableFrom(elc)) continue;
                    isType = true;
                }
            }
            if (isType) continue;
            return false;
        }
        return true;
    }
}

