/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.registry.search;

import java.net.URL;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import net.ivoa.registry.RegistryServiceException;
import net.ivoa.registry.search.IDNotFoundException;
import net.ivoa.registry.search.ServiceCaller;
import net.ivoa.registry.search.UnsupportedOperationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultServiceCaller
implements ServiceCaller {
    URL ep = null;
    protected SOAPConnection conn = null;
    public static final String SOAP_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String GENERAL_FAULT = "ErrorResponse";
    public static final String NOT_FOUND_FAULT = "NotFound";
    public static final String UNSUPPORTED_OPERATION_FAULT = "UnsupportedOperation";

    public DefaultServiceCaller(SOAPConnection connection, URL endpoint) {
        this.conn = connection;
        this.ep = endpoint;
        if (this.conn == null) {
            try {
                this.conn = SOAPConnectionFactory.newInstance().createConnection();
            }
            catch (SOAPException ex) {
                throw new InternalError("installation/config error: " + ex.getMessage());
            }
        }
    }

    public DefaultServiceCaller(URL endpoint) {
        this(null, endpoint);
    }

    public DefaultServiceCaller(SOAPConnection connection) {
        this(connection, null);
    }

    public DefaultServiceCaller() {
        this(null, null);
    }

    @Override
    public void setEndpoint(URL endpoint) {
        this.ep = endpoint;
    }

    @Override
    public URL getEndpoint() {
        return this.ep;
    }

    @Override
    public Element call(SOAPMessage msg, String actionURI) throws RegistryServiceException, SOAPException {
        return this.extractContent(this.getReplyFromCall(msg, actionURI));
    }

    protected SOAPMessage getReplyFromCall(SOAPMessage msg, String actionURI) throws SOAPException {
        MimeHeaders mh = msg.getMimeHeaders();
        mh.setHeader("SOAPAction", actionURI);
        return this.conn.call(msg, (Object)this.ep);
    }

    protected Element extractContent(SOAPMessage resp) throws RegistryServiceException, SOAPException {
        Node out;
        if (resp == null) {
            throw new RegistryServiceException("No response from registry");
        }
        for (out = resp.getSOAPBody().getFirstChild(); out != null && out.getNodeType() != 1; out = out.getNextSibling()) {
        }
        if (out == null) {
            throw new RegistryServiceException("Empty SOAP Envelope!");
        }
        DefaultServiceCaller.checkForFaults((Element)out);
        return (Element)out;
    }

    public static void checkForFaults(Element bodyelement) throws RegistryServiceException {
        if (bodyelement.getLocalName().equals("Fault") && bodyelement.getNamespaceURI().equals(SOAP_NS)) {
            Element fault = null;
            Element detail = DefaultServiceCaller.getFirstChildElement(bodyelement, "detail");
            if (detail != null) {
                fault = DefaultServiceCaller.getFirstChildElement(detail, null);
            }
            if (fault != null) {
                if (fault.getLocalName().equals(GENERAL_FAULT)) {
                    throw new RegistryServiceException(DefaultServiceCaller.getMessage(fault));
                }
                if (fault.getLocalName().equals(NOT_FOUND_FAULT)) {
                    throw new IDNotFoundException(DefaultServiceCaller.getMessage(fault));
                }
                if (fault.getLocalName().equals(UNSUPPORTED_OPERATION_FAULT)) {
                    throw new UnsupportedOperationException(DefaultServiceCaller.getMessage(fault));
                }
            }
            if ((fault = DefaultServiceCaller.getFirstChildElement(bodyelement, "faultstring")) == null) {
                throw new RegistryServiceException("unknown server error (missing faultstring)");
            }
            String msg = DefaultServiceCaller.getText(fault);
            if (msg.length() == 0) {
                msg = "unknown server error (empty faultstring)";
            }
            throw new RegistryServiceException(msg);
        }
    }

    private static Element getFirstChildElement(Element parent, String childtag) {
        Node child;
        for (child = parent.getFirstChild(); child != null && (child.getNodeType() != 1 || childtag != null && !childtag.equals(child.getLocalName())); child = child.getNextSibling()) {
        }
        return (Element)child;
    }

    public static String getMessage(Element rifault) throws DOMException {
        NodeList nl = rifault.getElementsByTagName("errorMessage");
        Node msgel = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            msgel = nl.item(i);
        }
        String msg = DefaultServiceCaller.getText((Element)msgel);
        if (msg.length() == 0) {
            msg = "Unknown error";
        }
        return msg;
    }

    private static String getText(Element txtel) {
        StringBuffer sb = new StringBuffer();
        if (txtel != null) {
            for (Node msg = txtel.getFirstChild(); msg != null; msg = msg.getNextSibling()) {
                if (msg.getNodeType() != 3) continue;
                sb.append(msg.getNodeValue());
            }
        }
        return sb.toString().trim();
    }
}

