/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Configuration {
    protected Node root = null;
    protected String name = null;

    public Configuration(InputStream strm, String name) throws IOException, SAXException {
        this.load(strm, name);
    }

    public Configuration(String config, Class appClass) throws FileNotFoundException, IOException, SAXException {
        File cfile = new File(config);
        if (cfile.isAbsolute()) {
            this.load(new FileInputStream(cfile), null);
        } else {
            InputStream cstrm = ClassLoader.getSystemResourceAsStream(config);
            if (cstrm == null && appClass != null) {
                cstrm = appClass.getResourceAsStream(config);
            }
            if (cstrm == null) {
                throw new FileNotFoundException("Can't find configuration file: " + config);
            }
            this.load(cstrm, null);
        }
    }

    public Configuration(String config) throws FileNotFoundException, IOException, SAXException {
        this(config, null);
    }

    protected Configuration(Node root, String name) {
        this.root = root;
        this.name = name;
    }

    protected void load(InputStream strm, String name) throws IOException, SAXException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(strm);
            this.root = doc.getDocumentElement();
            this.root.normalize();
        }
        catch (ParserConfigurationException e) {
            throw new Error("XML Parser Configuration problem: " + e.getMessage());
        }
        if (name == null) {
            name = "/" + this.root.getNodeName();
        }
        this.name = name;
    }

    protected Node getRoot() {
        return this.root;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected List findBlocks(String path) throws IllegalArgumentException {
        MatchedBlocks matched = new MatchedBlocks(this);
        StringTokenizer tok = new StringTokenizer(path, "/");
        while (tok.hasMoreTokens()) {
            boolean attrOnly = false;
            String name = tok.nextToken();
            if (name.startsWith("@")) {
                if (tok.hasMoreTokens()) {
                    throw new IllegalArgumentException("Illegal path: " + path);
                }
                attrOnly = true;
                name = name.substring(1);
            }
            int len = matched.size();
            for (int i = 0; i < len; ++i) {
                Node node;
                Configuration candidate = matched.popConfig();
                boolean findElements = true;
                if (!tok.hasMoreTokens()) {
                    node = ((Element)candidate.getRoot()).getAttributeNode(name);
                    if (node != null) {
                        matched.appendNode(node, candidate.getName());
                    }
                    if (attrOnly) {
                        findElements = false;
                    }
                }
                if (!findElements) continue;
                for (node = candidate.getRoot().getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1 || !node.getNodeName().equals(name)) continue;
                    matched.appendNode(node, candidate.getName());
                }
            }
        }
        return matched;
    }

    public Configuration[] getBlocks(String path) throws IllegalArgumentException {
        List matched = this.findBlocks(path);
        Configuration[] out = new Configuration[matched.size()];
        ListIterator iter = matched.listIterator();
        for (int i = 0; i < out.length && iter.hasNext(); ++i) {
            out[i] = (Configuration)iter.next();
        }
        return out;
    }

    public String[] getParameters(String path) {
        List matched = this.findBlocks(path);
        LinkedList<String> values = new LinkedList<String>();
        ListIterator iter = matched.listIterator();
        while (iter.hasNext()) {
            Node node = ((Configuration)iter.next()).getRoot();
            if (node.getNodeType() == 2) {
                values.addLast(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            for (node = node.getFirstChild(); node != null && node.getNodeType() != 3; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                node = null;
                break;
            }
            if (node == null) continue;
            values.addLast(node.getNodeValue().trim());
        }
        String[] out = new String[values.size()];
        iter = values.listIterator();
        for (int i = 0; i < out.length; ++i) {
            out[i] = (String)iter.next();
        }
        return out;
    }

    public String getParameter(String path) {
        String[] out = this.getParameters(path);
        return out != null && out.length > 0 ? out[0] : null;
    }

    class MatchedBlocks
    extends LinkedList {
        public MatchedBlocks(Configuration first) {
            this.addLast(first);
        }

        public void appendNode(Node node, String base) {
            this.addLast(new Configuration(node, base + "/" + node.getNodeName()));
        }

        public Configuration popConfig() {
            return (Configuration)this.removeFirst();
        }
    }
}

