/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.feather;

import java.io.IOException;
import java.io.OutputStream;
import uk.ac.bristol.star.feather.AbstractColumnWriter;
import uk.ac.bristol.star.feather.FeatherColumnWriter;
import uk.ac.bristol.star.feather.FeatherType;

public abstract class BooleanRandomWriter
extends AbstractColumnWriter {
    protected BooleanRandomWriter(String string, long l, boolean bl, String string2) {
        super(string, FeatherType.BOOL, l, bl, string2);
    }

    public abstract boolean getValue(long var1);

    @Override
    public boolean isNull(long l) {
        return false;
    }

    @Override
    public long writeDataBytes(OutputStream outputStream) throws IOException {
        long l = this.getRowCount();
        int n = 0;
        int n2 = 0;
        for (long i = 0L; i < l; ++i) {
            if (this.getValue(i)) {
                n |= 1 << n2;
            }
            if (++n2 != 8) continue;
            outputStream.write(n);
            n2 = 0;
            n = 0;
        }
        if (n2 > 0) {
            outputStream.write(n);
        }
        return (l + 7L) / 8L;
    }

    public static FeatherColumnWriter createBooleanWriter(String string, final boolean[] blArray, String string2) {
        return new BooleanRandomWriter(string, blArray.length, false, string2){

            @Override
            public boolean getValue(long l) {
                return blArray[this.longToInt(l)];
            }

            private int longToInt(long l) {
                int n = (int)l;
                if ((long)n == l) {
                    return n;
                }
                throw new IllegalArgumentException("integer overflow");
            }
        };
    }
}

