/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.vo.AdqlExample;
import uk.ac.starlink.vo.AdqlVersion;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.VersionedLanguage;

public abstract class AbstractAdqlExample
implements AdqlExample {
    private final String name_;
    private final String description_;
    private final URL url_;
    private static final int COL_COUNT = 3;
    private static final int ROW_COUNT = 1000;
    private static final Pattern[] RADEC_UCD_REGEXES = new Pattern[]{Pattern.compile("^pos.eq.ra[_;.]?(.*)", 2), Pattern.compile("^pos.eq.dec[_;.]?(.*)", 2)};
    private static final TableMeta DUMMY_TABLE = AbstractAdqlExample.createDummyTable();
    private static final DecimalFormat ANGLE_FORMAT = new DecimalFormat("0.0##", DecimalFormatSymbols.getInstance(Locale.UK));

    protected AbstractAdqlExample(String name, String description) {
        this.name_ = name;
        this.description_ = description;
        this.url_ = null;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    @Override
    public URL getInfoUrl() {
        return this.url_;
    }

    public static boolean isAdql21(VersionedLanguage lang) {
        return lang != null && AdqlVersion.V21.equals((Object)lang.getAdqlVersion());
    }

    public static Breaker createBreaker(boolean lineBreaks) {
        return lineBreaks ? new Breaker(){

            @Override
            public String space(int n) {
                StringBuffer sbuf = new StringBuffer(1 + n);
                sbuf.append('\n');
                for (int i = 0; i < n; ++i) {
                    sbuf.append(' ');
                }
                return sbuf.toString();
            }
        } : new Breaker(){

            @Override
            public String space(int n) {
                return " ";
            }
        };
    }

    private static TableRef createTableRef(final TableMeta table) {
        return new TableRef(){

            @Override
            public String getColumnName(String cname) {
                return cname;
            }

            @Override
            public String getIntroName() {
                return table.getName();
            }
        };
    }

    private static TableRef createAliasedTableRef(final TableMeta table, final String alias) {
        return new TableRef(){

            @Override
            public String getColumnName(String cname) {
                return alias + "." + cname;
            }

            @Override
            public String getIntroName() {
                return table.getName() + " AS " + alias;
            }
        };
    }

    private static TableRef[] createTableRefs(TableMeta[] tables) {
        int i;
        int nt = tables.length;
        String[] aliases = new String[nt];
        for (i = 0; i < nt; ++i) {
            aliases[i] = AbstractAdqlExample.getAlias(tables[i]);
        }
        if (new HashSet<String>(Arrays.asList(aliases)).size() < nt) {
            for (i = 0; i < nt; ++i) {
                aliases[i] = new StringBuffer().append((char)(97 + i)).toString();
            }
        }
        TableRef[] trefs = new TableRef[nt];
        for (int i2 = 0; i2 < nt; ++i2) {
            trefs[i2] = AbstractAdqlExample.createAliasedTableRef(tables[i2], aliases[i2]);
        }
        return trefs;
    }

    private static String getAlias(TableMeta table) {
        String tname = table.getName();
        String subname = tname == null ? null : tname.replaceFirst("^[^\\.]*\\.", "");
        char letter = '\u0000';
        if (subname != null && subname.length() > 0) {
            letter = subname.charAt(0);
        }
        if (letter >= 'a' && letter <= 'z' || letter >= 'A' && letter <= 'Z') {
            return new String(new char[]{letter});
        }
        return "t";
    }

    public static TableMeta[] toTables(TableMeta table, TableMeta[] tables) {
        ArrayList<TableMeta> tlist = new ArrayList<TableMeta>();
        if (table != null) {
            tlist.add(table);
        }
        if (tables != null) {
            for (int i = 0; i < tables.length; ++i) {
                if (tables[i] == table) continue;
                tlist.add(tables[i]);
            }
        }
        return tlist.toArray(new TableMeta[0]);
    }

    public static TableWithCols[] getRaDecTables(TableMeta[] tables, int max) {
        ArrayList<TableWithCols> tlist = new ArrayList<TableWithCols>();
        for (int i = 0; i < tables.length && tlist.size() < max; ++i) {
            String[] radec;
            TableMeta table = tables[i];
            ColumnMeta[] cols = table.getColumns();
            if (cols == null || (radec = AbstractAdqlExample.getRaDecDegreesNames(cols)) == null) continue;
            tlist.add(new TableWithCols(table, radec));
        }
        return tlist.toArray(new TableWithCols[0]);
    }

    private static String[] getRaDecDegreesNames(ColumnMeta[] cols) {
        String[] coords = new String[2];
        int[] scores = new int[2];
        for (int ic = 0; ic < cols.length; ++ic) {
            ColumnMeta col = cols[ic];
            String ucd = col.getUcd();
            String unit = col.getUnit();
            String name = col.getName();
            if (name == null || name.trim().length() <= 0 || ucd == null || ucd.trim().length() <= 0 || unit != null && unit.trim().length() != 0 && !unit.toLowerCase().startsWith("deg")) continue;
            for (int id = 0; id < 2; ++id) {
                Matcher matcher = RADEC_UCD_REGEXES[id].matcher(ucd);
                if (!matcher.matches()) continue;
                int score = 1;
                String trailer = matcher.group(1);
                if (trailer == null || trailer.trim().length() == 0) {
                    score = 2;
                } else if (trailer.toLowerCase().equals("main")) {
                    score = 4;
                } else if (trailer.toLowerCase().startsWith("main")) {
                    score = 3;
                }
                if (col.isIndexed()) {
                    score += 2;
                }
                if (score <= scores[id]) continue;
                scores[id] = score;
                coords[id] = name;
            }
        }
        return scores[0] > 0 && scores[1] > 0 ? coords : null;
    }

    public static AdqlExample createDummyExample() {
        return new AbstractAdqlExample("Dummy", "Never enabled"){

            @Override
            public String getAdqlText(boolean lineBreaks, VersionedLanguage lang, TapCapability tcap, TableMeta[] tables, TableMeta table, double[] skypos) {
                return null;
            }
        };
    }

    public static AdqlExample[] createSomeExamples() {
        return new AdqlExample[]{new AbstractAdqlExample("Full table", "All columns from a single table"){

            @Override
            public String getAdqlText(boolean lineBreaks, VersionedLanguage lang, TapCapability tcap, TableMeta[] tables, TableMeta table, double[] skypos) {
                if (table == null && tables != null && tables.length > 0) {
                    table = tables[0];
                }
                if (table == null) {
                    table = DUMMY_TABLE;
                }
                return new StringBuffer().append("SELECT TOP ").append(1000).append(" * FROM ").append(table.getName()).toString();
            }
        }, new AbstractAdqlExample("Columns from table", "Selection of columns from a single table"){

            @Override
            public String getAdqlText(boolean lineBreaks, VersionedLanguage lang, TapCapability tcap, TableMeta[] tables, TableMeta table, double[] skypos) {
                String colSelection;
                ColumnMeta[] cols;
                TableMeta ptable = this.getPopulatedTable(table, tables);
                Breaker breaker = 7.createBreaker(lineBreaks);
                TableRef tref = AbstractAdqlExample.createTableRef(ptable);
                ColumnMeta[] allCols = ptable.getColumns();
                ColumnMeta[] principalCols = allCols == null ? null : (ColumnMeta[])Arrays.stream(allCols).filter(ColumnMeta::isPrincipal).toArray(ColumnMeta[]::new);
                ColumnMeta[] columnMetaArray = cols = principalCols != null && principalCols.length >= 3 ? principalCols : allCols;
                if (cols != null && cols.length > 0) {
                    StringBuffer sbuf = new StringBuffer();
                    for (int i = 0; i < 3 && i < cols.length; ++i) {
                        if (i > 0) {
                            sbuf.append(", ");
                        }
                        sbuf.append(tref.getColumnName(cols[i].getName()));
                    }
                    colSelection = sbuf.toString();
                } else {
                    colSelection = "*";
                }
                return new StringBuffer().append("SELECT ").append("TOP ").append(1000).append(breaker.space(7)).append(colSelection).append(breaker.space(0)).append("FROM").append(' ').append(tref.getIntroName()).toString();
            }

            private TableMeta getPopulatedTable(TableMeta table, TableMeta[] tables) {
                if (this.isPopulated(table)) {
                    return table;
                }
                if (tables != null) {
                    for (TableMeta t : tables) {
                        if (!this.isPopulated(t)) continue;
                        return t;
                    }
                }
                return DUMMY_TABLE;
            }

            private boolean isPopulated(TableMeta table) {
                ColumnMeta[] cols;
                if (table != null && (cols = table.getColumns()) != null) {
                    return cols.length >= 3;
                }
                return false;
            }
        }, new AbstractAdqlExample("Count rows", "Count the rows in a table"){

            @Override
            public String getAdqlText(boolean lineBreaks, VersionedLanguage lang, TapCapability tcap, TableMeta[] tables, TableMeta table, double[] skypos) {
                if (table == null && tables != null && tables.length > 0) {
                    table = tables[0];
                }
                if (table == null) {
                    table = DUMMY_TABLE;
                }
                return new StringBuffer().append("SELECT COUNT(*) FROM ").append(table.getName()).toString();
            }
        }, new AbstractAdqlExample("Box selection", "Select rows based on rectangular RA/Dec position constraints"){

            @Override
            public String getAdqlText(boolean lineBreaks, VersionedLanguage lang, TapCapability tcap, TableMeta[] tables, TableMeta table, double[] skypos) {
                String[] decs;
                String[] ras;
                TableWithCols[] rdTabs = 9.getRaDecTables(9.toTables(table, tables), 1);
                if (rdTabs.length == 0) {
                    return null;
                }
                TableMeta rdTab = rdTabs[0].getTable();
                String[] radec = rdTabs[0].getColumns();
                String raCol = radec[0];
                String decCol = radec[1];
                Breaker breaker = 9.createBreaker(lineBreaks);
                TableRef tref = AbstractAdqlExample.createTableRef(rdTab);
                if (skypos == null) {
                    ras = new String[]{"189.1", "189.3"};
                    decs = new String[]{"62.18", "62.25"};
                } else {
                    double ra0 = skypos[0];
                    double dec0 = skypos[1];
                    double siz = 0.5;
                    double raSiz = Math.abs(siz / Math.cos(Math.toRadians(dec0)));
                    ras = new String[]{AbstractAdqlExample.formatAngle(ra0 - raSiz, false), AbstractAdqlExample.formatAngle(ra0 + raSiz, false)};
                    decs = new String[]{AbstractAdqlExample.formatAngle(dec0 - siz, true), AbstractAdqlExample.formatAngle(dec0 + siz, true)};
                }
                return new StringBuffer().append("SELECT ").append("TOP ").append(1000).append(breaker.space(7)).append("*").append(breaker.space(0)).append("FROM ").append(tref.getIntroName()).append(breaker.space(0)).append("WHERE ").append(tref.getColumnName(raCol)).append(" BETWEEN ").append(ras[0]).append(" AND ").append(ras[1]).append(breaker.space(2)).append("AND ").append(tref.getColumnName(decCol)).append(" BETWEEN ").append(decs[0]).append(" AND ").append(decs[1]).toString();
            }
        }, new AbstractAdqlExample("Cone selection", "Select rows within a given radius of a sky position"){

            @Override
            public String getAdqlText(boolean lineBreaks, VersionedLanguage lang, TapCapability tcap, TableMeta[] tables, TableMeta table, double[] skypos) {
                TableWithCols[] rdTabs = 10.getRaDecTables(10.toTables(table, tables), 1);
                if (rdTabs.length == 0) {
                    return null;
                }
                TableMeta rdTab = rdTabs[0].getTable();
                String[] radec = rdTabs[0].getColumns();
                Breaker breaker = 10.createBreaker(lineBreaks);
                TableRef tref = AbstractAdqlExample.createTableRef(rdTab);
                StringBuffer sbuf = new StringBuffer();
                sbuf.append("SELECT ").append("TOP ").append(1000).append(breaker.space(7)).append("*").append(breaker.space(0)).append("FROM ").append(tref.getIntroName()).append(breaker.space(0)).append("WHERE ");
                String raTxt = 10.formatCoord(skypos, false, 189.2);
                String decTxt = 10.formatCoord(skypos, true, 62.21);
                String radiusTxt = "0.05";
                if (10.isAdql21(lang)) {
                    sbuf.append("DISTANCE(").append(tref.getColumnName(radec[0])).append(", ").append(tref.getColumnName(radec[1])).append(", ").append(raTxt).append(", ").append(decTxt).append(") < ").append(radiusTxt);
                } else {
                    sbuf.append("1=CONTAINS(POINT('ICRS', ").append(tref.getColumnName(radec[0])).append(", ").append(tref.getColumnName(radec[1])).append("),").append(breaker.space(17)).append("CIRCLE('ICRS', ").append(raTxt).append(", ").append(decTxt).append(", ").append(radiusTxt).append("))");
                }
                return sbuf.toString();
            }
        }, new AbstractAdqlExample("Sky pair match", "Join two tables on sky position"){

            @Override
            public String getAdqlText(boolean lineBreaks, VersionedLanguage lang, TapCapability tcap, TableMeta[] tables, TableMeta table, double[] skypos) {
                TableWithCols[] rdTabs = 11.getRaDecTables(11.toTables(table, tables), 2);
                if (rdTabs.length < 2) {
                    return null;
                }
                TableRef[] trefs = AbstractAdqlExample.createTableRefs(new TableMeta[]{rdTabs[0].getTable(), rdTabs[1].getTable()});
                TableRef tref1 = trefs[0];
                TableRef tref2 = trefs[1];
                String[] radec1 = rdTabs[0].getColumns();
                String[] radec2 = rdTabs[1].getColumns();
                Breaker breaker = 11.createBreaker(lineBreaks);
                StringBuffer sbuf = new StringBuffer();
                sbuf.append("SELECT ").append("TOP ").append(1000).append(breaker.space(7)).append("*").append(breaker.space(0)).append("FROM ").append(tref1.getIntroName()).append(breaker.space(0)).append("JOIN ").append(tref2.getIntroName()).append(breaker.space(2));
                String radiusTxt = "5./3600.";
                if (11.isAdql21(lang)) {
                    sbuf.append("ON DISTANCE(").append(tref1.getColumnName(radec1[0])).append(", ").append(tref1.getColumnName(radec1[1])).append(", ").append(tref2.getColumnName(radec2[0])).append(", ").append(tref2.getColumnName(radec2[1])).append(") < ").append(radiusTxt);
                } else {
                    sbuf.append("ON 1=CONTAINS(POINT('ICRS', ").append(tref1.getColumnName(radec1[0])).append(", ").append(tref1.getColumnName(radec1[1])).append("),").append(breaker.space(17)).append("CIRCLE('ICRS', ").append(tref2.getColumnName(radec2[0])).append(", ").append(tref2.getColumnName(radec2[1])).append(", ").append(radiusTxt).append("))");
                }
                return sbuf.toString();
            }
        }};
    }

    public static AdqlExample[] createTapSchemaExamples() {
        return new AdqlExample[]{AbstractAdqlExample.createSimpleExample("Table descriptions", "Lists all tables in the service, apart from TAP_SCHEMA, along with their descriptions", new String[]{"SELECT schema_name, table_name, description", "FROM tap_schema.tables", "WHERE schema_name != 'tap_schema'", "ORDER BY schema_name, table_name"}), AbstractAdqlExample.createSimpleExample("Table column counts", "List all tables in the service along with the number of columns for each", new String[]{"SELECT table_name, count(column_name) AS ntable", "FROM TAP_SCHEMA.columns", "GROUP BY table_name", "ORDER BY ntable desc"}), AbstractAdqlExample.createSimpleExample("UCDs in use", "List all the Uniform Content Descriptors appearing in this service, with a count of how many columns each one appears in", new String[]{"SELECT ucd, count(*) AS ncol", "FROM tap_schema.columns", "GROUP BY ucd", "ORDER BY ucd"}), AbstractAdqlExample.createSimpleExample("Tables with Redshifts", "List all tables having a redshift column", new String[]{"SELECT t.table_name, t.description, c.column_name AS zcol", "FROM tap_schema.tables AS t", "JOIN tap_schema.columns AS c USING (table_name)", "WHERE c.ucd = 'src.redshift'"}), AbstractAdqlExample.createSimpleExample("X-Ray QSO observations", "List all quasar-related tables with X-ray-related columns", new String[]{"SELECT DISTINCT t.table_name", "FROM tap_schema.tables AS t", "JOIN tap_schema.columns AS c USING (table_name)", "WHERE (t.description LIKE '%qso%' OR t.description LIKE '%quasar%')", "  AND c.ucd LIKE '%em.X-ray%'"}), AbstractAdqlExample.createSimpleExample("J/H/K band observations", "List all tables with columns for all of J, H and K band magnitudes", new String[]{"SELECT t.table_name AS tname, t.description AS tdesc,", "       h.column_name AS hcol,", "       j.column_name AS jcol,", "       k.column_name AS kcol", "FROM tap_schema.tables AS t", "JOIN (SELECT table_name, column_name", "      FROM tap_schema.columns", "      WHERE ucd='phot.mag;em.IR.H') AS h USING (table_name)", "JOIN (SELECT table_name, column_name", "      FROM tap_schema.columns", "      WHERE ucd='phot.mag;em.IR.J') AS j USING (table_name)", "JOIN (SELECT table_name, column_name", "      FROM tap_schema.columns", "      WHERE ucd='phot.mag;em.IR.K') AS k USING (table_name)"})};
    }

    public static AdqlExample createSimpleExample(String name, String description, final String[] textLines) {
        return new AbstractAdqlExample(name, description){

            @Override
            public String getAdqlText(boolean lineBreaks, VersionedLanguage lang, TapCapability tcap, TableMeta[] tables, TableMeta table, double[] skypos) {
                if (lineBreaks) {
                    StringBuffer sbuf = new StringBuffer();
                    for (String line : textLines) {
                        sbuf.append(line).append('\n');
                    }
                    return sbuf.toString();
                }
                StringBuffer sbuf = new StringBuffer();
                for (String line : textLines) {
                    if (sbuf.length() != 0) {
                        sbuf.append(' ');
                    }
                    sbuf.append(line.trim().replaceAll("--.*", ""));
                }
                return sbuf.toString();
            }
        };
    }

    public static String formatCoord(double[] skypos, boolean isDec, double dflt) {
        return AbstractAdqlExample.formatAngle(skypos == null ? dflt : skypos[isDec ? 1 : 0], isDec);
    }

    private static String formatAngle(double value, boolean isDec) {
        return ANGLE_FORMAT.format(isDec ? Math.max(-90.0, Math.min(90.0, value)) : Math.max(0.0, Math.min(360.0, value)));
    }

    private static TableMeta createDummyTable() {
        TableMeta table = new TableMeta(){
            {
                this.name_ = "TAP_SCHEMA.tables";
            }
        };
        table.setColumns(new ColumnMeta[]{new ColumnMeta(){
            {
                this.name_ = "table_name";
            }
        }, new ColumnMeta(){
            {
                this.name_ = "schema_name";
            }
        }});
        return table;
    }

    public static class TableWithCols {
        private final TableMeta table_;
        private final String[] cols_;

        TableWithCols(TableMeta table, String[] cols) {
            this.table_ = table;
            this.cols_ = cols;
        }

        public TableMeta getTable() {
            return this.table_;
        }

        public String[] getColumns() {
            return this.cols_;
        }
    }

    private static abstract class TableRef {
        private TableRef() {
        }

        public abstract String getColumnName(String var1);

        public abstract String getIntroName();
    }

    public static abstract class Breaker {
        public abstract String space(int var1);
    }
}

