/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CheckBoxMenu
extends JMenu
implements ListSelectionListener {
    private ListSelectionModel selModel;

    public CheckBoxMenu() {
        this.setSelectionModel(new DefaultListSelectionModel());
    }

    public CheckBoxMenu(String name) {
        this();
        this.setText(name);
    }

    public int getEntryCount() {
        return this.getItemCount();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.selModel.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.selModel.removeListSelectionListener(listener);
    }

    public void addMenuItem(String text) {
        final int pos = this.getEntryCount();
        final JCheckBoxMenuItem item = new JCheckBoxMenuItem(text, this.selModel.isSelectedIndex(pos));
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (item.getState()) {
                    CheckBoxMenu.this.selModel.addSelectionInterval(pos, pos);
                } else {
                    CheckBoxMenu.this.selModel.removeSelectionInterval(pos, pos);
                }
            }
        });
        this.add(item);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selModel;
    }

    public void setSelectionModel(ListSelectionModel selModel) {
        if (this.selModel != null) {
            this.selModel.removeListSelectionListener(this);
        }
        this.selModel = selModel;
        for (int i = 0; i < this.getItemCount(); ++i) {
            ((JCheckBoxMenuItem)this.getItem(i)).setState(selModel.isSelectedIndex(i));
        }
        selModel.addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        int first = evt.getFirstIndex();
        int last = evt.getLastIndex();
        for (int i = first; i <= last; ++i) {
            ((JCheckBoxMenuItem)this.getItem(i)).setState(this.selModel.isSelectedIndex(i));
        }
    }
}

