/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import uk.ac.starlink.vo.AdqlFeature;
import uk.ac.starlink.vo.AdqlVersion;
import uk.ac.starlink.vo.Ivoid;
import uk.ac.starlink.vo.ResourceIcon;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapLanguage;
import uk.ac.starlink.vo.TapLanguageFeature;

public class FeatureTreeModel
implements TreeModel {
    private final List<TreeModelListener> listeners_ = new ArrayList<TreeModelListener>();
    private final NodeRenderer rootRenderer_;
    private final NodeRenderer categoryRenderer_;
    private final NodeRenderer functionRenderer_;
    private final NodeRenderer featureRenderer_;
    private final NodeRenderer signatureRenderer_;
    private final NodeRenderer plainRenderer_;
    private final NodeRenderer descriptionRenderer_;
    private TapCapability tcap_;
    private AdqlVersion adqlVersion_;
    private Node root_;
    private static final Pattern FUNC_REGEX = Pattern.compile(" *([A-Za-z0-9_-]+) *\\((.*)\\) *");
    private static final Pattern FORM_REGEX = Pattern.compile(" *([A-Za-z0-9_-]+) *\\((.*)\\) *-> *(.*?) *");

    public FeatureTreeModel(JScrollPane treeScroller) {
        final JViewport viewport = treeScroller.getViewport();
        viewport.addChangeListener(new ChangeListener(){
            int width_;

            @Override
            public void stateChanged(ChangeEvent evt) {
                int width = viewport.getExtentSize().width;
                if (width != this.width_) {
                    FeatureTreeModel.this.updateTextNodes(new TreePath(FeatureTreeModel.this.root_));
                    this.width_ = width;
                }
            }
        });
        Font labelFont = UIManager.getFont("Label.font");
        final Color sigColor = new Color(0x2020D0);
        final Color descripColor = new Color(0x707070);
        final Font sigFont = new Font("Monospaced", 0, labelFont.getSize());
        final CompoundBorder descripBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.rootRenderer_ = new NodeRenderer(){

            @Override
            public boolean isWidthSensitive() {
                return false;
            }

            @Override
            public Component renderNode(Node node, Supplier<JLabel> dfltRendering) {
                JLabel label = dfltRendering.get();
                label.setText(node.text_);
                return label;
            }
        };
        this.categoryRenderer_ = new NodeRenderer(){

            @Override
            public boolean isWidthSensitive() {
                return false;
            }

            @Override
            public Component renderNode(Node node, Supplier<JLabel> dfltRendering) {
                JLabel label = dfltRendering.get();
                label.setText(node.text_ + " (" + node.children_.size() + ")");
                return label;
            }
        };
        final Icon emptyIcon = new Icon(){

            @Override
            public int getIconHeight() {
                return 1;
            }

            @Override
            public int getIconWidth() {
                return 22;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
            }
        };
        this.plainRenderer_ = new NodeRenderer(){

            @Override
            public boolean isWidthSensitive() {
                return false;
            }

            @Override
            public Component renderNode(Node node, Supplier<JLabel> dfltRendering) {
                JLabel label = dfltRendering.get();
                label.setIcon(emptyIcon);
                return label;
            }
        };
        this.functionRenderer_ = new NodeRenderer(){
            private final Icon icon_ = ResourceIcon.NODE_FUNCTION;

            @Override
            public boolean isWidthSensitive() {
                return true;
            }

            @Override
            public Component renderNode(Node node, Supplier<JLabel> dfltRendering) {
                Matcher matcher;
                JLabel label = dfltRendering.get();
                String text = node.text_;
                label.setIcon(this.icon_);
                label.setText(text);
                int wrapWidth = viewport.getWidth() - FeatureTreeModel.getIndentX(node) - this.icon_.getIconWidth();
                int labelWidth = viewport.getGraphics().getFontMetrics(label.getFont()).stringWidth(text);
                if (labelWidth > wrapWidth && (matcher = FUNC_REGEX.matcher(node.text_)).matches()) {
                    int narg = matcher.group(2).replaceAll("[^,]", "").length() + 1;
                    String abbrev = matcher.group(1) + "(..." + narg + " args...)";
                    label.setText(abbrev);
                }
                return label;
            }
        };
        this.featureRenderer_ = new NodeRenderer(){
            private final Icon icon_ = ResourceIcon.NODE_FEATURE;

            @Override
            public boolean isWidthSensitive() {
                return false;
            }

            @Override
            public Component renderNode(Node node, Supplier<JLabel> dfltRendering) {
                JLabel label = dfltRendering.get();
                label.setIcon(this.icon_);
                return label;
            }
        };
        this.signatureRenderer_ = new NodeRenderer(){
            private final Icon icon_ = ResourceIcon.NODE_SIGNATURE;

            @Override
            public boolean isWidthSensitive() {
                return true;
            }

            @Override
            public Component renderNode(Node node, Supplier<JLabel> dfltRendering) {
                String text = node.text_.trim().replaceAll("\\s+", " ");
                return FeatureTreeModel.createWrappedTextComponent(viewport, node, text, this.icon_, sigFont, sigColor, null);
            }
        };
        this.descriptionRenderer_ = new NodeRenderer(){
            private final Icon icon_ = ResourceIcon.NODE_DOC;
            private final Font font_ = UIManager.getFont("TextArea.font");

            @Override
            public boolean isWidthSensitive() {
                return true;
            }

            @Override
            public Component renderNode(Node node, Supplier<JLabel> dfltRendering) {
                String text = node.text_.trim().replaceAll("\\t", " ").replaceAll(" *\\n *", "\n").replaceAll(" +", " ").replaceAll("([^\\n])\\n([^\\n])", "$1 $2");
                return FeatureTreeModel.createWrappedTextComponent(viewport, node, text, this.icon_, this.font_, descripColor, descripBorder);
            }
        };
        this.adqlVersion_ = AdqlVersion.V20;
        this.tcap_ = null;
        this.updateContent();
    }

    public void setCapability(TapCapability tcap) {
        this.tcap_ = tcap;
        this.updateContent();
    }

    public void setAdqlVersion(AdqlVersion adqlVersion) {
        if (!Objects.equals((Object)adqlVersion, (Object)this.adqlVersion_)) {
            this.adqlVersion_ = adqlVersion;
            this.updateContent();
        }
    }

    @Override
    public Object getRoot() {
        return this.root_;
    }

    @Override
    public int getChildCount(Object parent) {
        return ((Node)parent).children_.size();
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((Node)parent).children_.get(index);
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((Node)node).children_.isEmpty();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return parent == null || child == null ? -1 : ((Node)parent).children_.indexOf(child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners_.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners_.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        assert (false) : "Tree is not editable from GUI";
    }

    private void updateContent() {
        Node[] customFeatureNodes;
        TapLanguageFeature[] udfFeatures;
        Node mathNode = this.createFunctionsNode("ADQL Maths", AdqlFeature.getMathsFunctions());
        Node trigNode = this.createFunctionsNode("ADQL Trig", AdqlFeature.getTrigFunctions());
        Node geomNode = this.createFunctionsNode("ADQL " + this.adqlVersion_.getNumber() + " Geometry", AdqlFeature.getGeomFunctions(this.adqlVersion_, this.tcap_));
        Node optfuncNode = AdqlVersion.V20.equals((Object)this.adqlVersion_) ? null : this.createFunctionsNode("ADQL " + this.adqlVersion_.getNumber() + " Optional", AdqlFeature.getOptionalFunctions(this.tcap_));
        Node udfNode = new Node("Service-specific UDFs", this.categoryRenderer_);
        for (TapLanguageFeature feat : udfFeatures = (TapLanguageFeature[])Arrays.stream(this.tcap_ == null ? new TapLanguage[]{} : this.tcap_.getLanguages()).flatMap(lang -> lang.getFeaturesMap().entrySet().stream()).filter(entry -> AdqlFeature.UDF_FILTER.test((Ivoid)entry.getKey())).flatMap(entry -> Arrays.stream((Object[])entry.getValue())).toArray(TapLanguageFeature[]::new)) {
            udfNode.addChild(this.createUdfNode(feat));
        }
        Node functionNode = new Node("Functions", this.rootRenderer_);
        functionNode.addChild(udfNode);
        functionNode.addChild(geomNode);
        if (optfuncNode != null) {
            functionNode.addChild(optfuncNode);
        }
        functionNode.addChild(mathNode);
        functionNode.addChild(trigNode);
        Node optFeatureNode = AdqlVersion.V20.equals((Object)this.adqlVersion_) ? null : this.createFeaturesNode("ADQL " + this.adqlVersion_.getNumber() + " Optional", AdqlFeature.getOptionalFeatures(this.tcap_));
        Node customFeatureNode = new Node("Service-specific", this.categoryRenderer_);
        for (Node node : customFeatureNodes = (Node[])Arrays.stream(this.tcap_ == null ? new TapLanguage[]{} : this.tcap_.getLanguages()).flatMap(lang -> lang.getFeaturesMap().entrySet().stream()).filter(entry -> AdqlFeature.NONSTD_FILTER.test((Ivoid)entry.getKey())).flatMap(e -> Arrays.stream((Object[])e.getValue()).map(f -> this.createCustomFeatureNode((Ivoid)e.getKey(), (TapLanguageFeature)f))).toArray(Node[]::new)) {
            customFeatureNode.addChild(node);
        }
        Node featureNode = new Node("Features", this.rootRenderer_);
        featureNode.addChild(customFeatureNode);
        if (optFeatureNode != null) {
            featureNode.addChild(optFeatureNode);
        }
        this.root_ = new Node("Language Variant", this.rootRenderer_);
        this.root_.addChild(functionNode);
        this.root_.addChild(featureNode);
        TreeModelEvent evt = new TreeModelEvent((Object)this, new Object[]{this.root_});
        for (TreeModelListener l : this.listeners_) {
            l.treeStructureChanged(evt);
        }
    }

    private void updateTextNodes(TreePath path) {
        Node node = (Node)path.getLastPathComponent();
        if (node.renderer_.isWidthSensitive()) {
            TreeModelEvent evt = new TreeModelEvent((Object)this, path);
            for (TreeModelListener l : this.listeners_) {
                l.treeNodesChanged(evt);
            }
        }
        for (Node child : node.children_) {
            this.updateTextNodes(path.pathByAddingChild(child));
        }
    }

    private Node createUdfNode(TapLanguageFeature feature) {
        String label;
        String form = feature.getForm();
        Signature sig = FeatureTreeModel.createSignature(form);
        String string = label = sig == null ? null : sig.toCompactString();
        if (label == null || label.trim().length() == 0) {
            label = form;
        }
        Node signatureNode = new Node(form, this.signatureRenderer_);
        if (sig != null) {
            int iarg = 0;
            for (Arg arg : sig.getArgs()) {
                String argTxt = Integer.toString(++iarg) + ": " + arg.getArgName() + " " + arg.getArgType();
                signatureNode.addChild(new Node(argTxt, this.plainRenderer_));
            }
            signatureNode.addChild(new Node("return: " + sig.getReturnType(), this.plainRenderer_));
        }
        Node udfNode = new Node(label, this.functionRenderer_);
        udfNode.addChild(signatureNode);
        udfNode.addChild(new Node(feature.getDescription(), this.descriptionRenderer_));
        return udfNode;
    }

    private Node createCustomFeatureNode(Ivoid ivoid, TapLanguageFeature feature) {
        Node node = new Node(feature.getForm(), this.featureRenderer_);
        if (ivoid != null) {
            node.addChild(new Node(ivoid.toString(), this.plainRenderer_));
        }
        node.addChild(new Node(feature.getDescription(), this.descriptionRenderer_));
        return node;
    }

    private Node createFunctionsNode(String name, AdqlFeature.Function[] funcs) {
        Node funcsNode = new Node(name, this.categoryRenderer_);
        for (AdqlFeature.Function func : funcs) {
            String fname = func.getName();
            AdqlFeature.Arg[] args = func.getArgs();
            int narg = args.length;
            StringBuffer lbuf = new StringBuffer(fname).append('(');
            StringBuffer sbuf = new StringBuffer(fname).append('(');
            for (int iarg = 0; iarg < narg; ++iarg) {
                AdqlFeature.Arg arg = args[iarg];
                if (iarg > 0) {
                    lbuf.append(", ");
                    sbuf.append(", ");
                }
                lbuf.append(arg.getName());
                sbuf.append(arg.getName());
                if (arg.getType() == null) continue;
                sbuf.append(' ').append((Object)arg.getType());
            }
            lbuf.append(')');
            sbuf.append(") -> ").append((Object)func.getReturnType());
            String label = lbuf.toString();
            String sig = sbuf.toString();
            Node funcNode = new Node(label, this.functionRenderer_);
            funcNode.addChild(new Node(sig, this.signatureRenderer_));
            funcNode.addChild(new Node(func.getDescription(), this.descriptionRenderer_));
            funcsNode.addChild(funcNode);
        }
        return funcsNode;
    }

    private Node createFeaturesNode(String name, AdqlFeature[] features) {
        Node featsNode = new Node(name, this.categoryRenderer_);
        for (AdqlFeature feat : features) {
            Node featNode = new Node(feat.getName(), this.featureRenderer_);
            featNode.addChild(new Node(feat.getDescription(), this.descriptionRenderer_));
            featsNode.addChild(featNode);
        }
        return featsNode;
    }

    public static TreeCellRenderer createRenderer() {
        return new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSel, boolean isExp, boolean isLeaf, int irow, boolean hasFocus) {
                Node node = (Node)value;
                Supplier<JLabel> dfltRendering = () -> (JLabel)super.getTreeCellRendererComponent(tree, node.text_, isSel, isExp, isLeaf, irow, hasFocus);
                return node.renderer_.renderNode(node, dfltRendering);
            }
        };
    }

    private static JComponent createWrappedTextComponent(JViewport viewport, Node node, String text, Icon icon, Font font, Color color, Border border) {
        JLabel textLabel = new JLabel();
        if (font != null) {
            textLabel.setFont(font);
        }
        if (color != null) {
            textLabel.setForeground(color);
        }
        int wrapWidth = viewport.getWidth() - FeatureTreeModel.getIndentX(node);
        if (icon != null) {
            wrapWidth -= icon.getIconWidth();
        }
        textLabel.setText(new StringBuffer().append("<html><body width='").append(wrapWidth).append("'><p>").append(FeatureTreeModel.escapeHtml(text)).append("</p></body></html>").toString());
        JPanel panel = new JPanel(new BorderLayout());
        if (icon != null) {
            Box iconBox = Box.createVerticalBox();
            JLabel iconLabel = new JLabel(icon);
            iconBox.add(iconLabel);
            iconBox.add(Box.createVerticalGlue());
            iconBox.setOpaque(false);
            iconLabel.setOpaque(false);
            panel.add((Component)iconBox, "West");
        }
        panel.add((Component)textLabel, "Center");
        panel.setOpaque(false);
        if (border != null) {
            textLabel.setBorder(border);
        }
        return panel;
    }

    private static String escapeHtml(String txt) {
        return txt.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static int getIndentX(Node node) {
        int indentPerLevel = 24;
        int indent = 0;
        while ((node = node.parent_) != null) {
            indent += indentPerLevel;
        }
        return indent;
    }

    static Signature createSignature(String form) {
        Matcher matcher = FORM_REGEX.matcher(form);
        if (matcher.matches()) {
            final String name = matcher.group(1);
            String[] argTxts = matcher.group(2).split("\\s*,\\s*", -1);
            final String type = matcher.group(3);
            final Arg[] args = (Arg[])Arrays.stream(argTxts).map(txt -> FeatureTreeModel.createArg(txt)).toArray(Arg[]::new);
            final String compactString = name != null && name.trim().length() > 0 ? new StringBuffer().append(name).append("(").append(Arrays.stream(args).map(Arg::getArgName).collect(Collectors.joining(", "))).append(")").toString() : form;
            return new Signature(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public Arg[] getArgs() {
                    return args;
                }

                @Override
                public String getReturnType() {
                    return type;
                }

                @Override
                public String toCompactString() {
                    return compactString;
                }
            };
        }
        return null;
    }

    private static Arg createArg(String txt) {
        String[] words = txt.trim().split("\\s+", 2);
        final String name = words.length > 0 ? words[0] : null;
        final String type = words.length > 1 ? words[1].replaceAll("\\s+", " ") : null;
        return new Arg(){

            @Override
            public String getArgName() {
                return name;
            }

            @Override
            public String getArgType() {
                return type;
            }
        };
    }

    static interface Arg {
        public String getArgName();

        public String getArgType();
    }

    static interface Signature {
        public String getName();

        public Arg[] getArgs();

        public String getReturnType();

        public String toCompactString();
    }

    private static interface NodeRenderer {
        public boolean isWidthSensitive();

        public Component renderNode(Node var1, Supplier<JLabel> var2);
    }

    private static class Node {
        final String text_;
        final NodeRenderer renderer_;
        final List<Node> children_;
        Node parent_;
        private final List<Node> mutableChildren_;

        public Node(String text, NodeRenderer renderer) {
            this.text_ = text;
            this.renderer_ = renderer;
            this.mutableChildren_ = new ArrayList<Node>();
            this.children_ = Collections.unmodifiableList(this.mutableChildren_);
        }

        public void addChild(Node child) {
            child.parent_ = this;
            this.mutableChildren_.add(child);
        }
    }
}

