/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Ivoid {
    private final String txt_;
    private final String registryPart_;
    private final String registrypart_;
    private final String localPart_;
    private static final Pattern IVOID_REGEX = Pattern.compile("(ivo://[^?#]+)(.*)");
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");
    private static boolean hasWarned_;

    public Ivoid(String txt) {
        this.txt_ = txt;
        Matcher matcher = IVOID_REGEX.matcher(txt == null ? "" : txt);
        if (matcher.matches()) {
            this.registryPart_ = matcher.group(1);
            this.registrypart_ = this.registryPart_.toLowerCase();
            this.localPart_ = matcher.group(2);
        } else {
            this.registryPart_ = null;
            this.registrypart_ = null;
            this.localPart_ = null;
        }
    }

    public String getRegistryPart() {
        return this.registryPart_;
    }

    public String getLocalPart() {
        return this.localPart_;
    }

    public boolean matchesRegistryPart(String regPart) {
        return regPart != null && regPart.equalsIgnoreCase(this.registryPart_);
    }

    public boolean isValid() {
        return this.registryPart_ != null;
    }

    public String toRegtapString() {
        return this.registryPart_ == null ? this.txt_ : this.registryPart_.toLowerCase() + this.localPart_;
    }

    public boolean equalsIvoid(Ivoid other) {
        return this.equals(other);
    }

    public int hashCode() {
        return this.registrypart_ == null ? Objects.hash(this.txt_) : Objects.hash(this.registrypart_, this.localPart_);
    }

    public boolean equals(Object o) {
        if (o instanceof Ivoid) {
            Ivoid other = (Ivoid)o;
            return this.registrypart_ == null ? other.registrypart_ == null && Objects.equals(this.txt_, other.txt_) : this.registrypart_.equals(other.registrypart_) && Objects.equals(this.localPart_, other.localPart_);
        }
        if (o != null && !hasWarned_) {
            hasWarned_ = true;
            String msg = new StringBuffer().append("At least one Ivoid/").append(o.getClass().getName()).append(" equality comparison").append(" - possible programming error").toString();
            logger_.warning(msg);
        }
        return false;
    }

    public String toString() {
        return this.txt_;
    }
}

