/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.Border;
import uk.ac.starlink.table.gui.AbstractTableLoadDialog;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.vo.RegistryPanel;
import uk.ac.starlink.vo.RegistryQuery;
import uk.ac.starlink.vo.RegistryQueryFactory;
import uk.ac.starlink.vo.RegistrySelector;

public abstract class RegistryServiceTableLoadDialog
extends AbstractTableLoadDialog {
    private final String protoName_;
    private final RegistryQueryFactory queryFactory_;
    private final boolean showCapabilities_;
    private final JMenuItem[] menuItems_;
    private JComponent controlBox_;
    private RegistryPanel regPanel_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public RegistryServiceTableLoadDialog(String name, String protoName, String description, RegistryQueryFactory queryFactory, boolean showCapabilities) {
        super(name, description);
        this.protoName_ = protoName;
        this.queryFactory_ = queryFactory;
        this.showCapabilities_ = showCapabilities;
        ArrayList<JMenuItem> menuItemList = new ArrayList<JMenuItem>();
        RegistrySelector regSel = queryFactory.getRegistrySelector();
        menuItemList.add(new JMenuItem(regSel.getRegistryUpdateAction()));
        this.menuItems_ = menuItemList.toArray(new JMenuItem[0]);
    }

    public JMenuItem[] getRegistryMenuItems() {
        return this.menuItems_;
    }

    public boolean acceptResourceIdList(String[] ivoids, String msg) {
        if (this.isComponentShowing()) {
            RegistryQuery query;
            try {
                query = this.queryFactory_.getIdListQuery(ivoids);
            }
            catch (MalformedURLException e) {
                logger_.warning("Resource ID list not accepted: bad registry endpoint " + e);
                return false;
            }
            if (query != null) {
                this.getRegistryPanel().performQuery(query, msg);
                return true;
            }
            return false;
        }
        return false;
    }

    protected Component createQueryComponent() {
        JPanel queryPanel = new JPanel(new BorderLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                RegistryServiceTableLoadDialog.this.regPanel_.setEnabled(enabled);
            }
        };
        this.regPanel_ = new RegistryPanel(this.queryFactory_, this.showCapabilities_){

            @Override
            public RegCapabilityInterface[] getCapabilities(RegResource res) {
                return RegistryServiceTableLoadDialog.this.getCapabilities(res);
            }
        };
        this.regPanel_.getResourceSelectionModel().setSelectionMode(0);
        queryPanel.add((Component)this.regPanel_, "Center");
        this.controlBox_ = Box.createVerticalBox();
        queryPanel.add((Component)this.controlBox_, "South");
        if (this.queryFactory_.getComponent() == null) {
            String msg = "Searching registry for " + this.protoName_ + " services";
            this.regPanel_.performAutoQuery(msg);
        }
        JMenu metaMenu = this.regPanel_.makeColumnVisibilityMenu("Columns");
        metaMenu.setMnemonic(67);
        this.setMenus(new JMenu[]{metaMenu});
        Border lineBorder = BorderFactory.createLineBorder(Color.BLACK);
        Border gapBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border etchedBorder = BorderFactory.createEtchedBorder();
        this.regPanel_.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(lineBorder, gapBorder), "Available " + this.protoName_ + " Services"));
        this.controlBox_.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(lineBorder, gapBorder), this.protoName_ + " Parameters"));
        queryPanel.setBorder(gapBorder);
        Dimension prefSize = new Dimension(600, 400);
        if (this.showCapabilities_) {
            prefSize.height += 70;
        }
        if (this.queryFactory_.getComponent() != null) {
            prefSize.height += 100;
        }
        queryPanel.setPreferredSize(prefSize);
        return queryPanel;
    }

    protected JComponent getControlBox() {
        return this.controlBox_;
    }

    public RegistryPanel getRegistryPanel() {
        return this.regPanel_;
    }

    public RegCapabilityInterface[] getCapabilities(RegResource resource) {
        return resource.getCapabilities();
    }

    public RegistryQueryFactory getQueryFactory() {
        return this.queryFactory_;
    }
}

