/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.TableLoader;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.gui.ShrinkWrapper;
import uk.ac.starlink.vo.Capability;
import uk.ac.starlink.vo.DoubleValueField;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegistryPanel;
import uk.ac.starlink.vo.ResourceIcon;
import uk.ac.starlink.vo.SiaFormatOption;
import uk.ac.starlink.vo.SiaVersion;
import uk.ac.starlink.vo.SkyDalTableLoadDialog;
import uk.ac.starlink.vo.SkyPositionEntry;

public class SiapTableLoadDialog
extends SkyDalTableLoadDialog {
    private final ContentCoding coding_ = ContentCoding.GZIP;
    private DoubleValueField raField_;
    private DoubleValueField decField_;
    private DoubleValueField sizeField_;
    private JComboBox<Object> formatSelector_;
    private JComboBox<SiaVersion> versionSelector_;
    private static final ValueInfo SIZE_INFO = new DefaultValueInfo("Angular Size", Double.class, "Angular size of the search region in RA and Dec");

    public SiapTableLoadDialog() {
        super("Simple Image Access (SIA) Query", "SIA", "Get results of a Simple Image Access Protocol query", Capability.SIA, true, true);
        this.setIcon(ResourceIcon.TLD_SIA);
    }

    @Override
    protected Component createQueryComponent() {
        Component queryPanel = super.createQueryComponent();
        SkyPositionEntry skyEntry = this.getSkyEntry();
        this.raField_ = skyEntry.getRaDegreesField();
        this.decField_ = skyEntry.getDecDegreesField();
        this.sizeField_ = DoubleValueField.makeSizeDegreesField(SIZE_INFO);
        this.sizeField_.getEntryField().setText("0");
        skyEntry.addField(this.sizeField_);
        this.versionSelector_ = new JComboBox<SiaVersion>(SiaVersion.values());
        final RegistryPanel regPanel = this.getRegistryPanel();
        ListSelectionListener serviceListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SiaVersion version;
                RegCapabilityInterface[] intfs = regPanel.getSelectedCapabilities();
                if (intfs.length == 1 && (version = SiaVersion.forInterface(intfs[0])) != null) {
                    SiapTableLoadDialog.this.versionSelector_.setSelectedItem((Object)version);
                }
            }
        };
        regPanel.getResourceSelectionModel().addListSelectionListener(serviceListener);
        regPanel.getCapabilitySelectionModel().addListSelectionListener(serviceListener);
        Box versionLine = Box.createHorizontalBox();
        versionLine.add(Box.createHorizontalStrut(10));
        versionLine.add(new JLabel("SIA Version: "));
        versionLine.add((Component)new ShrinkWrapper(this.versionSelector_));
        this.getServiceUrlBox().add(versionLine);
        Box formatLine = Box.createHorizontalBox();
        this.formatSelector_ = new JComboBox<SiaFormatOption>(SiaFormatOption.getStandardOptions());
        this.formatSelector_.setEditable(true);
        this.formatSelector_.setSelectedIndex(0);
        formatLine.add(new JLabel("Image Format: "));
        formatLine.add((Component)new ShrinkWrapper(this.formatSelector_));
        formatLine.add(Box.createHorizontalGlue());
        this.getControlBox().add(Box.createVerticalStrut(5));
        this.getControlBox().add(formatLine);
        return queryPanel;
    }

    public TableLoader createTableLoader() {
        final String serviceUrl = this.getServiceUrl();
        this.checkUrl(serviceUrl);
        final double ra = this.raField_.getValue();
        final double dec = this.decField_.getValue();
        final double size = this.sizeField_.getValue();
        final SiaVersion siaVersion = this.getSiaVersion();
        final SiaFormatOption format = this.getFormat();
        final ArrayList<DescribedValue> metadata = new ArrayList<DescribedValue>();
        metadata.addAll(Arrays.asList(this.raField_.getDescribedValue(), this.decField_.getDescribedValue(), this.sizeField_.getDescribedValue()));
        metadata.addAll(Arrays.asList(this.getResourceMetadata(serviceUrl)));
        final String summary = this.getQuerySummary(serviceUrl, size);
        return new TableLoader(){

            public TableSequence loadTables(StarTableFactory factory) throws IOException {
                StarTable st = siaVersion.executeQuery(serviceUrl, ra, dec, size, format, factory, SiapTableLoadDialog.this.coding_);
                st.getParameters().addAll(metadata);
                return Tables.singleTableSequence((StarTable)st);
            }

            public String getLabel() {
                return summary;
            }
        };
    }

    public SiaVersion getSiaVersion() {
        return this.versionSelector_.getItemAt(this.versionSelector_.getSelectedIndex());
    }

    public SiaFormatOption getFormat() {
        return SiaFormatOption.fromObject(this.formatSelector_.getSelectedItem());
    }

    public double getSizeDeg() {
        try {
            return this.sizeField_.getValue();
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public JComboBox<Object> getFormatSelector() {
        return this.formatSelector_;
    }

    public JComboBox<SiaVersion> getVersionSelector() {
        return this.versionSelector_;
    }
}

