/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.TableLoader;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.gui.ShrinkWrapper;
import uk.ac.starlink.vo.Capability;
import uk.ac.starlink.vo.DalQuery;
import uk.ac.starlink.vo.DoubleValueField;
import uk.ac.starlink.vo.ResourceIcon;
import uk.ac.starlink.vo.SkyDalTableLoadDialog;
import uk.ac.starlink.vo.SkyPositionEntry;

public class SsapTableLoadDialog
extends SkyDalTableLoadDialog {
    private final ContentCoding coding_ = ContentCoding.GZIP;
    private DoubleValueField raField_;
    private DoubleValueField decField_;
    private DoubleValueField sizeField_;
    private JComboBox<String> formatSelector_;
    private static final ValueInfo SIZE_INFO = new DefaultValueInfo("Diameter", Double.class, "Angular diameter of the search region");

    public SsapTableLoadDialog() {
        super("Simple Spectral Access (SSA) Query", "SSA", "Get results of a Simple Spectrum Access Protocol query", Capability.SSA, true, true);
        this.setIcon(ResourceIcon.TLD_SSA);
    }

    @Override
    protected Component createQueryComponent() {
        Component queryPanel = super.createQueryComponent();
        SkyPositionEntry skyEntry = this.getSkyEntry();
        this.raField_ = skyEntry.getRaDegreesField();
        this.decField_ = skyEntry.getDecDegreesField();
        this.sizeField_ = DoubleValueField.makeSizeDegreesField(SIZE_INFO);
        skyEntry.addField(this.sizeField_);
        Box formatLine = Box.createHorizontalBox();
        this.formatSelector_ = new JComboBox<String>(SsapTableLoadDialog.getFormatOptions());
        this.formatSelector_.setEditable(true);
        this.formatSelector_.setSelectedIndex(0);
        formatLine.add(new JLabel("Spectrum Format: "));
        formatLine.add((Component)new ShrinkWrapper(this.formatSelector_));
        formatLine.add(Box.createHorizontalGlue());
        this.getControlBox().add(Box.createVerticalStrut(5));
        this.getControlBox().add(formatLine);
        return queryPanel;
    }

    public TableLoader createTableLoader() {
        double dec;
        double ra;
        String serviceUrl = this.getServiceUrl();
        this.checkUrl(serviceUrl);
        String raString = this.raField_.getEntryField().getText();
        String decString = this.decField_.getEntryField().getText();
        String sizeString = this.sizeField_.getEntryField().getText();
        if (!(raString != null && raString.trim().length() != 0 || decString != null && decString.trim().length() != 0)) {
            ra = Double.NaN;
            dec = Double.NaN;
        } else {
            ra = this.raField_.getValue();
            dec = this.decField_.getValue();
        }
        double size = sizeString == null || sizeString.trim().length() == 0 ? Double.NaN : this.sizeField_.getValue();
        final DalQuery query = new DalQuery(serviceUrl, "SSA", ra, dec, size, this.coding_);
        query.addArgument("REQUEST", "queryData");
        String format = this.getFormat();
        if (format != null && format.toString().trim().length() > 0) {
            query.addArgument("FORMAT", format.toString());
        }
        final ArrayList<DescribedValue> metadata = new ArrayList<DescribedValue>();
        metadata.addAll(Arrays.asList(this.raField_.getDescribedValue(), this.decField_.getDescribedValue(), this.sizeField_.getDescribedValue()));
        metadata.addAll(Arrays.asList(this.getResourceMetadata(serviceUrl)));
        final String summary = this.getQuerySummary(serviceUrl, size);
        return new TableLoader(){

            public TableSequence loadTables(StarTableFactory factory) throws IOException {
                StarTable st = query.execute(factory);
                st.getParameters().addAll(metadata);
                return Tables.singleTableSequence((StarTable)st);
            }

            public String getLabel() {
                return summary;
            }
        };
    }

    public double getSearchDiameter() {
        try {
            return this.sizeField_.getValue();
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public String getFormat() {
        Object format = this.formatSelector_.getSelectedItem();
        return format == null ? null : format.toString();
    }

    public JComboBox<String> getFormatSelector() {
        return this.formatSelector_;
    }

    public static String[] getFormatOptions() {
        return new String[]{"", "all", "compliant", "native", "graphic", "votable", "fits", "xml"};
    }
}

