/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.MetaNameFixer;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TableSetSaxHandler;
import uk.ac.starlink.vo.TapMetaPolicy;
import uk.ac.starlink.vo.TapMetaReader;

public class TableSetTapMetaReader
implements TapMetaReader {
    private final URL url_;
    private final MetaNameFixer fixer_;
    private final ContentCoding coding_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public TableSetTapMetaReader(URL tablesetUrl, MetaNameFixer fixer, ContentCoding coding) {
        this.url_ = tablesetUrl;
        this.fixer_ = fixer;
        this.coding_ = coding;
    }

    @Override
    public SchemaMeta[] readSchemas() throws IOException {
        SchemaMeta[] schemas;
        logger_.info("Reading table metadata from " + this.url_);
        try {
            schemas = TableSetSaxHandler.readTableSet(this.url_, this.coding_);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("Invalid TableSet XML document").initCause(e);
        }
        if (this.fixer_ != null) {
            this.fixer_.fixSchemas(schemas);
        }
        TapMetaPolicy.sortSchemas(schemas);
        for (SchemaMeta smeta : schemas) {
            TableMeta[] tmetas = smeta.getTables();
            if (tmetas == null) continue;
            TapMetaPolicy.sortTables(tmetas);
        }
        return schemas;
    }

    @Override
    public TableMeta[] readTables(SchemaMeta schema) {
        throw this.readNotNeeded();
    }

    @Override
    public ColumnMeta[] readColumns(TableMeta table) {
        throw this.readNotNeeded();
    }

    @Override
    public ForeignMeta[] readForeignKeys(TableMeta table) {
        throw this.readNotNeeded();
    }

    @Override
    public String getSource() {
        return this.url_.toString();
    }

    @Override
    public String getMeans() {
        return "VOSI TableSet, preload everything";
    }

    private UnsupportedOperationException readNotNeeded() {
        String msg = "readSchemas method returns fully populated schemas; you should not need to call this method";
        return new UnsupportedOperationException(msg);
    }
}

