/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.Capability;
import uk.ac.starlink.vo.Ivoid;
import uk.ac.starlink.vo.OutputFormat;
import uk.ac.starlink.vo.StdCapabilityInterface;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapLanguage;
import uk.ac.starlink.vo.TapLanguageFeature;
import uk.ac.starlink.vo.TapLimit;
import uk.ac.starlink.vo.TapVersion;

public class TapCapabilitiesDoc {
    private final TapCapability tapCapability_;
    private final StdCapabilityInterface[] intfs_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public TapCapabilitiesDoc(TapCapability tapCapability, StdCapabilityInterface[] intfs) {
        this.tapCapability_ = tapCapability;
        this.intfs_ = intfs;
    }

    public TapCapability getTapCapability() {
        return this.tapCapability_;
    }

    public StdCapabilityInterface[] getInterfaces() {
        return this.intfs_;
    }

    public static URL getCapabilitiesUrl(URL baseUrl) {
        if (baseUrl == null) {
            throw new NullPointerException();
        }
        try {
            return URLUtils.newURL((String)(baseUrl + (baseUrl.toString().endsWith("/") ? "" : "/") + "capabilities"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Surely not");
        }
    }

    public static TapCapabilitiesDoc readCapabilities(URL capsUrl) throws IOException, SAXException {
        TapCapability tapCap;
        Element capsEl;
        try (BufferedInputStream in = new BufferedInputStream(AuthManager.getInstance().openStream(capsUrl));){
            capsEl = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in).getDocumentElement();
        }
        String elName = capsEl.getTagName().replaceFirst(".*:", "");
        boolean isCapabilities = elName.equals("capabilities");
        StdCapabilityInterface[] intfs = TapCapabilitiesDoc.getInterfaces(capsEl);
        try {
            tapCap = TapCapabilitiesDoc.getTapCapability(capsEl);
        }
        catch (XPathExpressionException e) {
            throw (IOException)new IOException("XPath programming error?").initCause(e);
        }
        if (tapCap != null || intfs.length > 0) {
            return new TapCapabilitiesDoc(tapCap, intfs);
        }
        if (isCapabilities) {
            logger_.warning("No TAP capabilities content at " + capsUrl);
            return new TapCapabilitiesDoc(tapCap, intfs);
        }
        throw new IOException("Doesn't appear to be a TAP capabilities document at " + capsUrl);
    }

    public static TapCapability getTapCapability(Element capsEl) throws XPathExpressionException {
        String capXpath;
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node capNode = (Node)xpath.evaluate(capXpath = "capability[translate(@standardID,'IVOANETSDP','ivoanetsdp')='ivo://ivoa.net/std/tap']", capsEl, XPathConstants.NODE);
        if (capNode == null) {
            return null;
        }
        String versionTxt = null;
        for (StdCapabilityInterface intf : TapCapabilitiesDoc.getInterfaces(capsEl)) {
            if (!Capability.TAP_IVOID.equalsIvoid(new Ivoid(intf.getStandardId())) || !"std".equals(intf.getRole()) || versionTxt != null) continue;
            versionTxt = intf.getVersion();
        }
        final TapVersion version = TapVersion.fromString(versionTxt);
        NodeList upNodeList = (NodeList)xpath.evaluate("uploadMethod/@ivo-id", capNode, XPathConstants.NODESET);
        ArrayList<Ivoid> upList = new ArrayList<Ivoid>();
        for (int i = 0; i < upNodeList.getLength(); ++i) {
            upList.add(new Ivoid(upNodeList.item(i).getNodeValue()));
        }
        final Ivoid[] uploadMethods = upList.toArray(new Ivoid[0]);
        NodeList dmNodeList = (NodeList)xpath.evaluate("dataModel/@ivo-id", capNode, XPathConstants.NODESET);
        ArrayList<Ivoid> dmList = new ArrayList<Ivoid>();
        for (int i = 0; i < dmNodeList.getLength(); ++i) {
            dmList.add(new Ivoid(dmNodeList.item(i).getNodeValue()));
        }
        final Ivoid[] dataModels = dmList.toArray(new Ivoid[0]);
        NodeList langNodeList = (NodeList)xpath.evaluate("language", capNode, XPathConstants.NODESET);
        ArrayList<TapLanguage> langList = new ArrayList<TapLanguage>();
        for (int il = 0; il < langNodeList.getLength(); ++il) {
            Node lang = langNodeList.item(il);
            if (!(lang instanceof Element)) continue;
            langList.add(TapCapabilitiesDoc.getLanguage((Element)lang));
        }
        final TapLanguage[] languages = langList.toArray(new TapLanguage[0]);
        NodeList ofmtNodeList = (NodeList)xpath.evaluate("outputFormat", capNode, XPathConstants.NODESET);
        ArrayList<OutputFormat> ofmtList = new ArrayList<OutputFormat>();
        for (int i = 0; i < ofmtNodeList.getLength(); ++i) {
            Node ofmt = ofmtNodeList.item(i);
            if (!(ofmt instanceof Element)) continue;
            ofmtList.add(TapCapabilitiesDoc.getOutputFormat((Element)ofmt));
        }
        final OutputFormat[] outputFormats = ofmtList.toArray(new OutputFormat[0]);
        final TapLimit[] outputLimits = TapCapabilitiesDoc.getLimits((NodeList)xpath.evaluate("outputLimit/*", capNode, XPathConstants.NODESET), null);
        final TapLimit[] uploadLimits = TapCapabilitiesDoc.getLimits((NodeList)xpath.evaluate("uploadLimit/*", capNode, XPathConstants.NODESET), null);
        final TapLimit[] retentionLimits = TapCapabilitiesDoc.getLimits((NodeList)xpath.evaluate("retentionPeriod/*", capNode, XPathConstants.NODESET), "seconds");
        final TapLimit[] executionLimits = TapCapabilitiesDoc.getLimits((NodeList)xpath.evaluate("executionDuration/*", capNode, XPathConstants.NODESET), "seconds");
        return new TapCapability(){

            @Override
            public TapVersion getTapVersion() {
                return version;
            }

            @Override
            public Ivoid[] getUploadMethods() {
                return uploadMethods;
            }

            @Override
            public TapLanguage[] getLanguages() {
                return languages;
            }

            @Override
            public OutputFormat[] getOutputFormats() {
                return outputFormats;
            }

            @Override
            public Ivoid[] getDataModels() {
                return dataModels;
            }

            @Override
            public TapLimit[] getOutputLimits() {
                return outputLimits;
            }

            @Override
            public TapLimit[] getUploadLimits() {
                return uploadLimits;
            }

            @Override
            public TapLimit[] getExecutionLimits() {
                return executionLimits;
            }

            @Override
            public TapLimit[] getRetentionLimits() {
                return retentionLimits;
            }

            public String toString() {
                return "uploadMethods: " + Arrays.asList(uploadMethods) + "; languages: " + Arrays.asList(languages) + "; outputFormats: " + Arrays.asList(outputFormats) + "; dataModels: " + Arrays.asList(dataModels) + "; outputLimits: " + Arrays.asList(outputLimits) + "; uploadLimits: " + Arrays.asList(uploadLimits) + "; execLimits: " + Arrays.asList(executionLimits) + "; retentLimits: " + Arrays.asList(retentionLimits);
            }
        };
    }

    public static StdCapabilityInterface[] getInterfaces(Element capsEl) {
        ArrayList<2> intfList = new ArrayList<2>();
        NodeList capEls = capsEl.getElementsByTagName("capability");
        for (int ic = 0; ic < capEls.getLength(); ++ic) {
            Element capEl = (Element)capEls.item(ic);
            final String stdId = capEl.getAttribute("standardID");
            final String capType = capEl.getAttribute("xsi:type");
            Element descEl = DOMUtils.getChildElementByName((Node)capEl, (String)"description");
            final String description = descEl == null ? null : DOMUtils.getTextContent((Element)descEl);
            NodeList intfEls = capEl.getElementsByTagName("interface");
            for (int ii = 0; ii < intfEls.getLength(); ++ii) {
                Element intfEl = (Element)intfEls.item(ii);
                final String intfType = intfEl.getAttribute("xsi:type");
                final String version = intfEl.getAttribute("version");
                final String role = intfEl.getAttribute("role");
                Element accessEl = DOMUtils.getChildElementByName((Node)intfEl, (String)"accessURL");
                final String accessUrl = accessEl == null ? null : DOMUtils.getTextContent((Element)accessEl);
                NodeList secEls = intfEl.getElementsByTagName("securityMethod");
                ArrayList<String> smids = new ArrayList<String>();
                for (int is = 0; is < secEls.getLength(); ++is) {
                    Element secmethEl = (Element)secEls.item(is);
                    smids.add(secmethEl.getAttribute("standardID"));
                }
                final String[] secmethIds = smids.toArray(new String[0]);
                intfList.add(new StdCapabilityInterface(){

                    @Override
                    public String getStandardId() {
                        return stdId;
                    }

                    @Override
                    public String getXsiType() {
                        return capType;
                    }

                    @Override
                    public String getDescription() {
                        return description;
                    }

                    @Override
                    public String getInterfaceType() {
                        return intfType;
                    }

                    @Override
                    public String getAccessUrl() {
                        return accessUrl;
                    }

                    @Override
                    public String[] getSecurityMethodIds() {
                        return secmethIds;
                    }

                    @Override
                    public String getVersion() {
                        return version;
                    }

                    @Override
                    public String getRole() {
                        return role;
                    }

                    public String toString() {
                        return new StringBuffer().append(capType).append("; ").append(intfType).append("; ").append(Arrays.toString(secmethIds)).append("; ").append(accessUrl).toString();
                    }
                });
            }
        }
        return intfList.toArray(new StdCapabilityInterface[0]);
    }

    private static TapLimit[] getLimits(NodeList nodeList, String fixedUnit) {
        ArrayList<TapLimit> limitList = new ArrayList<TapLimit>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            String tagName = el.getTagName();
            Boolean isHard = null;
            if ("hard".equals(tagName)) {
                isHard = Boolean.TRUE;
            } else if ("default".equals(tagName)) {
                isHard = Boolean.FALSE;
            }
            if (isHard == null) continue;
            String unit = fixedUnit == null ? el.getAttribute("unit") : fixedUnit;
            String text = DOMUtils.getTextContent((Element)el);
            try {
                long value = Long.parseLong(text.trim());
                limitList.add(new TapLimit(value, isHard, unit));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return limitList.toArray(new TapLimit[0]);
    }

    private static TapLanguage getLanguage(Element langEl) {
        String langName = null;
        String langDesc = null;
        ArrayList<String> versionList = new ArrayList<String>();
        ArrayList<Ivoid> versionIdList = new ArrayList<Ivoid>();
        final LinkedHashMap<Ivoid, TapLanguageFeature[]> featureMap = new LinkedHashMap<Ivoid, TapLanguageFeature[]>();
        for (Node langChild = langEl.getFirstChild(); langChild != null; langChild = langChild.getNextSibling()) {
            if (!(langChild instanceof Element)) continue;
            Element childEl = (Element)langChild;
            String childName = childEl.getTagName();
            if ("name".equals(childName)) {
                langName = DOMUtils.getTextContent((Element)childEl);
                continue;
            }
            if ("description".equals(childName)) {
                langDesc = DOMUtils.getTextContent((Element)childEl);
                continue;
            }
            if ("version".equals(childName)) {
                String idTxt = childEl.getAttribute("ivo-id");
                versionIdList.add(idTxt == null ? null : new Ivoid(idTxt));
                versionList.add(DOMUtils.getTextContent((Element)childEl));
                continue;
            }
            if (!"languageFeatures".equals(childName)) continue;
            Ivoid featType = new Ivoid(childEl.getAttribute("type"));
            ArrayList<3> featList = new ArrayList<3>();
            NodeList featNodeList = childEl.getElementsByTagName("feature");
            for (int ifeat = 0; ifeat < featNodeList.getLength(); ++ifeat) {
                Element featEl = (Element)featNodeList.item(ifeat);
                Element formEl = DOMUtils.getChildElementByName((Node)featEl, (String)"form");
                Element descEl = DOMUtils.getChildElementByName((Node)featEl, (String)"description");
                final String form = formEl == null ? null : DOMUtils.getTextContent((Element)formEl);
                final String desc = descEl == null ? null : DOMUtils.getTextContent((Element)descEl);
                featList.add(new TapLanguageFeature(){

                    @Override
                    public String getForm() {
                        return form;
                    }

                    @Override
                    public String getDescription() {
                        return desc;
                    }

                    public String toString() {
                        return form;
                    }
                });
            }
            TapLanguageFeature[] features = featList.toArray(new TapLanguageFeature[0]);
            featureMap.put(featType, features);
        }
        final String name = langName;
        final String description = langDesc;
        final String[] versions = versionList.toArray(new String[0]);
        final Ivoid[] versionIds = versionIdList.toArray(new Ivoid[0]);
        return new TapLanguage(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String[] getVersions() {
                return versions;
            }

            @Override
            public Ivoid[] getVersionIds() {
                return versionIds;
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public Map<Ivoid, TapLanguageFeature[]> getFeaturesMap() {
                return featureMap;
            }

            public String toString() {
                return name + "-" + Arrays.asList(versions);
            }
        };
    }

    private static OutputFormat getOutputFormat(Element ofmtEl) {
        String idTxt = ofmtEl.getAttribute("ivo-id");
        final Ivoid ivoid = idTxt == null ? null : new Ivoid(idTxt);
        String ofmtMime = null;
        ArrayList<String> aliasList = new ArrayList<String>();
        for (Node ofmtChild = ofmtEl.getFirstChild(); ofmtChild != null; ofmtChild = ofmtChild.getNextSibling()) {
            if (!(ofmtChild instanceof Element)) continue;
            Element childEl = (Element)ofmtChild;
            String childName = childEl.getTagName();
            if ("mime".equals(childName)) {
                ofmtMime = DOMUtils.getTextContent((Element)childEl);
                continue;
            }
            if (!"alias".equals(childName)) continue;
            aliasList.add(DOMUtils.getTextContent((Element)childEl));
        }
        final String mime = ofmtMime;
        final String[] aliases = aliasList.toArray(new String[0]);
        return new OutputFormat(){

            @Override
            public String getMime() {
                return mime;
            }

            @Override
            public String[] getAliases() {
                return aliases;
            }

            @Override
            public Ivoid getIvoid() {
                return ivoid;
            }

            public String toString() {
                if (aliases.length > 0) {
                    return aliases[0];
                }
                if (mime != null) {
                    return mime;
                }
                if (ivoid != null) {
                    return ivoid.toString();
                }
                return "?output-format?";
            }
        };
    }
}

