/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;

public interface TapServiceFinder {
    public Service[] readAllServices() throws IOException;

    public Table[] readSelectedTables(Constraint var1) throws IOException;

    public static enum Target {
        TABLE_NAME("Table Name", false, "table_name", "table_name", "table_name"),
        TABLE_DESCRIP("Table Description", true, "table_desc", "table_description", "table_description"),
        SERVICE_META("Service", false, null, null, null);

        private final String displayName_;
        private final boolean isWords_;
        private final String glotsTablesCol_;
        private final String rrTablesCol_;
        private final String rrTapTablesCol_;

        private Target(String displayName, boolean isWords, String glotsTablesCol, String rrTablesCol, String rrTapTablesCol) {
            this.displayName_ = displayName;
            this.isWords_ = isWords;
            this.glotsTablesCol_ = glotsTablesCol;
            this.rrTablesCol_ = rrTablesCol;
            this.rrTapTablesCol_ = rrTapTablesCol;
        }

        public String getDisplayName() {
            return this.displayName_;
        }

        boolean isWords() {
            return this.isWords_;
        }

        boolean isServiceMeta() {
            return this.glotsTablesCol_ == null;
        }

        String getGlotsTablesCol() {
            return this.glotsTablesCol_;
        }

        String getRrTablesCol() {
            return this.rrTablesCol_;
        }

        String getRrTapTablesCol() {
            return this.rrTapTablesCol_;
        }

        boolean matchesService(Service service, String[] keywords, boolean isAnd) {
            if (this.isServiceMeta()) {
                String[] kws = (String[])keywords.clone();
                for (int i = 0; i < kws.length; ++i) {
                    kws[i] = kws[i].toLowerCase();
                }
                return Target.matchText(service.getId(), kws, isAnd) || Target.matchText(service.getName(), kws, isAnd) || Target.matchText(service.getTitle(), kws, isAnd);
            }
            throw new UnsupportedOperationException("Wrong target type");
        }

        private static boolean matchText(String txt, String[] lcKeywords, boolean isAnd) {
            txt = txt.toLowerCase();
            if (isAnd) {
                for (String kw : lcKeywords) {
                    if (txt.indexOf(kw) >= 0) continue;
                    return false;
                }
                return true;
            }
            for (String kw : lcKeywords) {
                if (txt.indexOf(kw) < 0) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Constraint {
        public String[] getKeywords();

        public Target[] getTargets();

        public boolean isAndKeywords();
    }

    public static interface Table {
        public String getServiceId();

        public String getName();

        public String getDescription();
    }

    public static interface Service {
        public String getId();

        public String getName();

        public String getTitle();

        public String getDescription();

        public String getServiceUrl();

        public int getTableCount();
    }
}

