/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.me.nxg.unity.OneUnit;
import uk.me.nxg.unity.Syntax;
import uk.me.nxg.unity.UnitDefinition;
import uk.me.nxg.unity.UnitExpr;
import uk.me.nxg.unity.UnitParser;
import uk.me.nxg.unity.UnitParserException;
import uk.me.nxg.unity.UnitRepresentation;

public class UnitStatus {
    private final Code code_;
    private final String message_;
    private static final Map<String, UnitStatus> statusMap_ = UnitStatus.createCache(200);

    protected UnitStatus(Code code, String message) {
        this.code_ = code;
        this.message_ = message;
    }

    public Code getCode() {
        return this.code_;
    }

    public String getMessage() {
        return this.message_;
    }

    public static UnitStatus getStatus(String unit) {
        return statusMap_.computeIfAbsent(unit, UnitStatus::createStatus);
    }

    private static UnitStatus createStatus(String unit) {
        String guess;
        UnitExpr punit;
        Syntax syntax = Syntax.VOUNITS;
        if (unit == null || unit.trim().length() == 0) {
            return null;
        }
        String cunit = unit.replaceAll("\\s", "");
        boolean hasWhitespace = !cunit.equals(unit);
        try {
            UnitParser parser = new UnitParser(syntax);
            parser.setGuessing(true);
            punit = parser.parse(cunit);
        }
        catch (UnitParserException e) {
            return new UnitStatus(Code.BAD_SYNTAX, e.getMessage());
        }
        catch (Throwable e) {
            return new UnitStatus(Code.PARSE_ERROR, e.toString());
        }
        if (hasWhitespace) {
            return new UnitStatus(Code.WHITESPACE, "Whitespace illegal at VOUnits 1.0");
        }
        LinkedHashMap<Object, String> unknown = new LinkedHashMap<Object, String>();
        ArrayList<String> deprecated = new ArrayList<String>();
        for (OneUnit word : punit) {
            if (!word.isRecognisedUnit(syntax) || word.wasGuessed()) {
                String utxt = word.getOriginalUnitString();
                UnitDefinition unitDefinition = word.getBaseUnitDefinition();
                UnitRepresentation urep = unitDefinition == null ? null : unitDefinition.getRepresentation(syntax);
                guess = urep == null ? null : urep.toString();
                unknown.put(utxt, guess);
            }
            if (word.isRecommendedUnit(syntax)) continue;
            deprecated.add(word.getBaseUnitName());
        }
        if (unknown.size() > 0) {
            ArrayList<String> items = new ArrayList<String>();
            boolean allGuessed = true;
            for (Map.Entry entry : unknown.entrySet()) {
                String utxt = (String)entry.getKey();
                guess = (String)entry.getValue();
                StringBuffer sbuf = new StringBuffer().append('\"').append(utxt).append('\"');
                if (guess != null) {
                    sbuf.append(" (").append("-> \"").append(guess).append("\"?)");
                } else {
                    allGuessed = false;
                }
                items.add(sbuf.toString());
            }
            String txt = (unknown.size() == 1 ? "Unknown unit " : "Unknown units ") + String.join((CharSequence)", ", items);
            return new UnitStatus(allGuessed ? Code.GUESSED_UNIT : Code.UNKNOWN_UNIT, txt);
        }
        if (!punit.allUsageConstraintsSatisfied(syntax)) {
            return new UnitStatus(Code.USAGE, "Usage constraints violated");
        }
        if (deprecated.size() > 0) {
            String txt = deprecated.size() == 1 ? "Deprecated unit \"" + (String)deprecated.get(0) + "\"" : "Deprecated units " + deprecated;
            return new UnitStatus(Code.DEPRECATED, txt);
        }
        assert (punit.isFullyConformant(syntax));
        return new UnitStatus(Code.OK, null);
    }

    private static Map<String, UnitStatus> createCache(final int limit) {
        return Collections.synchronizedMap(new LinkedHashMap<String, UnitStatus>(){

            @Override
            public boolean removeEldestEntry(Map.Entry<String, UnitStatus> entry) {
                return this.size() > limit;
            }
        });
    }

    public static enum Code {
        OK(' '),
        DEPRECATED(' '),
        UNKNOWN_UNIT('W'),
        GUESSED_UNIT('W'),
        BAD_SYNTAX('E'),
        PARSE_ERROR('E'),
        USAGE('E'),
        WHITESPACE('E');

        private final char stat_;

        private Code(char stat) {
            this.stat_ = stat;
            switch (stat) {
                case ' ': 
                case 'E': 
                case 'W': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public boolean isError() {
            return this.stat_ == 'E';
        }

        public boolean isWarning() {
            return this.stat_ == 'W';
        }
    }
}

