/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.VocabTerm;

public class Vocabulary {
    private final String uri_;
    private final String flavour_;
    private final Map<String, VocabTerm> termMap_;

    public Vocabulary(String uri, VocabTerm[] terms, String flavour) {
        this.uri_ = uri;
        this.flavour_ = flavour;
        LinkedHashMap<String, VocabTerm> tmap = new LinkedHashMap<String, VocabTerm>();
        for (VocabTerm term : terms) {
            tmap.put(term.getTerm(), term);
        }
        this.termMap_ = Collections.unmodifiableMap(tmap);
    }

    public String getUri() {
        return this.uri_;
    }

    public String getFlavour() {
        return this.flavour_;
    }

    public Map<String, VocabTerm> getTerms() {
        return this.termMap_;
    }

    public static Vocabulary readVocabulary(URL vocabUrl) throws IOException {
        return Vocabulary.readVocabularyDesise(vocabUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vocabulary readVocabularyDesise(URL vocabUrl) throws IOException {
        URLConnection conn = vocabUrl.openConnection();
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).setInstanceFollowRedirects(true);
        }
        conn.setRequestProperty("Accept", "application/x-desise+json");
        try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());){
            JSONTokener jt = new JSONTokener((InputStream)in);
            Object top = jt.nextValue();
            if (top instanceof JSONObject) {
                JSONObject topObj = (JSONObject)top;
                Object uriObj = topObj.opt("uri");
                String uri = uriObj instanceof String ? (String)uriObj : null;
                Object flavourObj = topObj.opt("flavour");
                String flavour = flavourObj instanceof String ? (String)flavourObj : null;
                Object termsObj = topObj.get("terms");
                if (termsObj instanceof JSONObject) {
                    JSONObject termsJson = (JSONObject)termsObj;
                    ArrayList<JsonVocabTerm> list = new ArrayList<JsonVocabTerm>();
                    Iterator it = termsJson.keys();
                    while (it.hasNext()) {
                        String term;
                        Object termObj;
                        Object key = it.next();
                        if (!(key instanceof String) || !((termObj = termsJson.get(term = (String)key)) instanceof JSONObject)) continue;
                        JSONObject termJson = (JSONObject)termObj;
                        list.add(new JsonVocabTerm(term, termJson));
                    }
                    VocabTerm[] terms = list.toArray(new VocabTerm[0]);
                    Vocabulary vocabulary = new Vocabulary(uri, terms, flavour);
                    return vocabulary;
                }
            }
        }
        throw new IOException("JSON doesn't seem to follow desise syntax");
    }

    @Deprecated
    public static Vocabulary readVocabularyRdfXml(URL vocabUrl) throws IOException {
        SAXParser parser;
        SAXParserFactory spfact = SAXParserFactory.newInstance();
        try {
            spfact.setNamespaceAware(false);
            spfact.setValidating(false);
            parser = spfact.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw (IOException)new IOException("SAX trouble").initCause(e);
        }
        VocabSaxHandler vHandler = new VocabSaxHandler(vocabUrl + "#");
        URLConnection conn = vocabUrl.openConnection();
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).setInstanceFollowRedirects(true);
        }
        conn.setRequestProperty("Accept", "application/rdf+xml");
        try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());){
            parser.parse((InputStream)in, (DefaultHandler)vHandler);
        }
        String uri = vocabUrl.toString();
        VocabTerm[] terms = vHandler.terms_.toArray(new VocabTerm[0]);
        String flavour = null;
        return new Vocabulary(uri, terms, flavour);
    }

    public static void main(String[] args) throws IOException {
        String url = args.length > 0 ? args[0] : "http://www.ivoa.net/rdf/timescale";
        Vocabulary vocab = Vocabulary.readVocabulary(URLUtils.newURL((String)url));
        System.out.println(vocab.getUri());
        for (VocabTerm term : vocab.getTerms().values()) {
            System.out.println("   " + term);
        }
    }

    private static class JsonVocabTerm
    extends AbstractVocabTerm {
        private final String label_;
        private final String description_;
        private final boolean isPreliminary_;
        private final boolean isDeprecated_;
        private final String[] wider_;
        private final String[] narrower_;
        private final String useInstead_;

        JsonVocabTerm(String term, JSONObject json) {
            super(term);
            this.label_ = JsonVocabTerm.getString(json, "label");
            this.description_ = JsonVocabTerm.getString(json, "description");
            this.isPreliminary_ = json.has("preliminary");
            this.isDeprecated_ = json.has("deprecated");
            this.wider_ = JsonVocabTerm.getStrings(json, "wider");
            this.narrower_ = JsonVocabTerm.getStrings(json, "narrower");
            this.useInstead_ = JsonVocabTerm.getString(json, "useInstead");
        }

        @Override
        public String getLabel() {
            return this.label_;
        }

        @Override
        public String getDescription() {
            return this.description_;
        }

        @Override
        public boolean isPreliminary() {
            return this.isPreliminary_;
        }

        @Override
        public boolean isDeprecated() {
            return this.isDeprecated_;
        }

        @Override
        public String[] getWider() {
            return this.wider_;
        }

        @Override
        public String[] getNarrower() {
            return this.narrower_;
        }

        @Override
        public String getUseInstead() {
            return this.useInstead_;
        }

        private static String getString(JSONObject json, String key) {
            Object value = json.opt(key);
            return value instanceof String ? (String)value : null;
        }

        private static String[] getStrings(JSONObject json, String key) {
            Object value = json.opt(key);
            ArrayList<String> list = new ArrayList<String>();
            if (value instanceof JSONArray) {
                JSONArray jarray = (JSONArray)value;
                for (int i = 0; i < jarray.length(); ++i) {
                    Object el = jarray.get(i);
                    if (!(el instanceof String)) continue;
                    list.add((String)el);
                }
            }
            return list.toArray(new String[0]);
        }

        public String toString() {
            return this.getTerm() + "(" + this.getLabel() + ")";
        }
    }

    private static class BasicVocabTerm
    extends AbstractVocabTerm {
        BasicVocabTerm(String term) {
            super(term);
        }

        @Override
        public String getLabel() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public boolean isPreliminary() {
            return false;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }

        @Override
        public String[] getWider() {
            return new String[0];
        }

        @Override
        public String[] getNarrower() {
            return new String[0];
        }

        @Override
        public String getUseInstead() {
            return null;
        }

        public String toString() {
            return this.getTerm();
        }
    }

    private static abstract class AbstractVocabTerm
    implements VocabTerm {
        private final String term_;

        AbstractVocabTerm(String term) {
            this.term_ = term;
        }

        @Override
        public String getTerm() {
            return this.term_;
        }
    }

    private static class VocabSaxHandler
    extends DefaultHandler {
        private final String termPrefix_;
        List<VocabTerm> terms_;

        VocabSaxHandler(String termPrefix) {
            this.termPrefix_ = termPrefix;
        }

        @Override
        public void startDocument() {
            this.terms_ = new ArrayList<VocabTerm>();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            for (int ia = 0; ia < atts.getLength(); ++ia) {
                String value;
                String lname = atts.getLocalName(ia);
                String qname = atts.getQName(ia);
                if (!"about".equals(lname) && !"about".equals(qname) && (qname == null || !qname.endsWith(":about")) || !(value = atts.getValue(ia)).startsWith(this.termPrefix_)) continue;
                String term = value.substring(this.termPrefix_.length());
                this.terms_.add(new BasicVocabTerm(term));
            }
        }
    }
}

