/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo.datalink;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;

public class LinkColMap {
    private final Map<ColDef<?>, Integer> icolMap_;
    public static final ColDef<String> COL_ID;
    public static final ColDef<String> COL_ACCESSURL;
    public static final ColDef<String> COL_SERVICEDEF;
    public static final ColDef<String> COL_ERRORMESSAGE;
    public static final ColDef<String> COL_DESCRIPTION;
    public static final ColDef<String> COL_SEMANTICS;
    public static final ColDef<String> COL_CONTENTTYPE;
    public static final ColDef<Number> COL_CONTENTLENGTH;
    public static final ColDef<String> COL_CONTENTQUALIFIER;
    public static final ColDef<Object> COL_LOCALSEMANTICS;
    public static final ColDef<String> COL_LINKAUTH;
    public static final ColDef<Boolean> COL_LINKAUTHORIZED;
    public static final Map<String, ColDef<?>> COLDEF_MAP;
    private static final Logger logger_;

    protected LinkColMap(Map<ColDef<?>, Integer> icolMap) {
        this.icolMap_ = icolMap;
    }

    public String getId(Object[] row) {
        return this.getValue(COL_ID, row);
    }

    public String getAccessUrl(Object[] row) {
        return this.getValue(COL_ACCESSURL, row);
    }

    public String getServiceDef(Object[] row) {
        return this.getValue(COL_SERVICEDEF, row);
    }

    public String getErrorMessage(Object[] row) {
        return this.getValue(COL_ERRORMESSAGE, row);
    }

    public String getDescription(Object[] row) {
        return this.getValue(COL_DESCRIPTION, row);
    }

    public String getSemantics(Object[] row) {
        return this.getValue(COL_SEMANTICS, row);
    }

    public String getContentType(Object[] row) {
        return this.getValue(COL_CONTENTTYPE, row);
    }

    public Long getContentLength(Object[] row) {
        Number cleng = this.getValue(COL_CONTENTLENGTH, row);
        if (cleng == null) {
            return null;
        }
        if (cleng instanceof Long) {
            return (Long)cleng;
        }
        if (Double.isNaN(cleng.doubleValue())) {
            return null;
        }
        return cleng.longValue();
    }

    public String getContentQualifier(Object[] row) {
        return this.getValue(COL_CONTENTQUALIFIER, row);
    }

    public Object getLocalSemantics(Object[] row) {
        return this.getValue(COL_LOCALSEMANTICS, row);
    }

    public String getLinkAuth(Object[] row) {
        return this.getValue(COL_LINKAUTH, row);
    }

    public Boolean getLinkAuthorized(Object[] row) {
        return this.getValue(COL_LINKAUTHORIZED, row);
    }

    public <C> C getValue(ColDef<C> col, Object[] row) {
        Integer icol = this.icolMap_.get(col);
        if (icol == null) {
            return null;
        }
        Object value = ((ColDef)col).clazz_.cast(row[icol]);
        return Tables.isBlank(value) ? null : (C)value;
    }

    public static LinkColMap getMap(StarTable table) {
        if (table == null) {
            return new LinkColMap(new HashMap());
        }
        int ncol = table.getColumnCount();
        LinkedHashMap icolMap = new LinkedHashMap();
        for (int ic = 0; ic < ncol; ++ic) {
            ColumnInfo info = table.getColumnInfo(ic);
            String name = info.getName();
            ColDef<?> coldef = COLDEF_MAP.get(name);
            if (coldef == null) continue;
            String ucd = info.getUCD();
            String stdUcd = coldef.getUcd();
            Class clazz = info.getContentClass();
            boolean isCorrectUcd = stdUcd == null || stdUcd.equals(ucd);
            boolean isCorrectClazz = coldef.getContentClass().isAssignableFrom(clazz);
            boolean hasValue = icolMap.containsKey(coldef);
            if (hasValue) {
                logger_.warning("Duplicate column \"" + name + "\" in DataLink table");
                continue;
            }
            if (!isCorrectClazz) {
                logger_.warning("Wrong type for DataLink column " + name + " (" + clazz.getSimpleName() + ")");
                continue;
            }
            icolMap.put(coldef, ic);
            if (isCorrectUcd) continue;
            if (ucd == null) {
                logger_.warning("Missing UCD for DataLink column " + name);
                continue;
            }
            logger_.warning("Wrong UCD for DataLink column " + name + ": " + ucd + " != " + stdUcd);
        }
        return new LinkColMap(icolMap);
    }

    static {
        ColDef[] coldefs;
        LinkedHashMap<String, ColDef> map = new LinkedHashMap<String, ColDef>();
        ColDef[] colDefArray = new ColDef[12];
        COL_ID = new ColDef("ID", "meta.id;meta.main", true, String.class);
        colDefArray[0] = COL_ID;
        COL_ACCESSURL = new ColDef("access_url", "meta.ref.url", true, String.class);
        colDefArray[1] = COL_ACCESSURL;
        COL_SERVICEDEF = new ColDef("service_def", "meta.ref", true, String.class);
        colDefArray[2] = COL_SERVICEDEF;
        COL_ERRORMESSAGE = new ColDef("error_message", "meta.code.error", true, String.class);
        colDefArray[3] = COL_ERRORMESSAGE;
        COL_DESCRIPTION = new ColDef("description", "meta.note", true, String.class);
        colDefArray[4] = COL_DESCRIPTION;
        COL_SEMANTICS = new ColDef("semantics", "meta.code", true, String.class);
        colDefArray[5] = COL_SEMANTICS;
        COL_CONTENTTYPE = new ColDef("content_type", "meta.code.mime", true, String.class);
        colDefArray[6] = COL_CONTENTTYPE;
        COL_CONTENTLENGTH = new ColDef("content_length", "phys.size;meta.file", true, Number.class);
        colDefArray[7] = COL_CONTENTLENGTH;
        COL_CONTENTQUALIFIER = new ColDef("content_qualifier", null, false, String.class);
        colDefArray[8] = COL_CONTENTQUALIFIER;
        COL_LOCALSEMANTICS = new ColDef("local_semantics", "meta.id.assoc", false, Object.class);
        colDefArray[9] = COL_LOCALSEMANTICS;
        COL_LINKAUTH = new ColDef("link_auth", "meta.code", false, String.class);
        colDefArray[10] = COL_LINKAUTH;
        COL_LINKAUTHORIZED = new ColDef("link_authorized", "meta.code", false, Boolean.class);
        colDefArray[11] = COL_LINKAUTHORIZED;
        for (ColDef coldef : coldefs = colDefArray) {
            map.put(coldef.getName(), coldef);
        }
        COLDEF_MAP = Collections.unmodifiableMap(map);
        logger_ = Logger.getLogger("uk.ac.starlink.vo.datalink");
    }

    public static class ColDef<C> {
        private final String name_;
        private final String ucd_;
        private final boolean isRequired_;
        private final Class<C> clazz_;

        private ColDef(String name, String ucd, boolean isRequired, Class<C> clazz) {
            this.name_ = name;
            this.ucd_ = ucd;
            this.isRequired_ = isRequired;
            this.clazz_ = clazz;
        }

        public String getName() {
            return this.name_;
        }

        public String getUcd() {
            return this.ucd_;
        }

        public boolean isRequired() {
            return this.isRequired_;
        }

        public Class<C> getContentClass() {
            return this.clazz_;
        }
    }
}

