/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.fits.AbstractWideFits;
import uk.ac.starlink.fits.BasicInput;
import uk.ac.starlink.fits.BasicInputThreadLocal;
import uk.ac.starlink.fits.BintableColumnHeader;
import uk.ac.starlink.fits.ColumnReader;
import uk.ac.starlink.fits.FitsHeader;
import uk.ac.starlink.fits.FitsUtil;
import uk.ac.starlink.fits.InputFactory;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.HealpixTableInfo;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;

public abstract class BintableStarTable
extends AbstractStarTable {
    private final int ncol_;
    private final long nrow_;
    private final ColumnInfo[] colInfos_;
    private final ColumnReader[] colReaders_;
    private final long rowLength_;
    private final long[] colOffsets_;
    public static final ValueInfo TNULL_INFO = new DefaultValueInfo(Tables.NULL_VALUE_INFO.getName(), Tables.NULL_VALUE_INFO.getContentClass(), "Bad value indicator (TNULLn card)");
    public static final ValueInfo TSCAL_INFO = new DefaultValueInfo("Scale", Double.class, "Multiplier for values (TSCALn card)");
    public static final ValueInfo TZERO_INFO = new DefaultValueInfo("Zero", Number.class, "Offset for values (TZEROn card)");
    public static final ValueInfo TDISP_INFO = new DefaultValueInfo("Format", String.class, "Display format in FORTRAN notation (TDISPn card)");
    public static final ValueInfo TBCOL_INFO = new DefaultValueInfo("Start column", Integer.class, "Start column for data (TBCOLn card)");
    public static final ValueInfo TFORM_INFO = new DefaultValueInfo("Format code", String.class, "Data type code (TFORMn card)");
    public static final ValueInfo LONGOFF_INFO = new DefaultValueInfo("LONG_OFFSET", String.class, "Offset value added when turning 64-bit integer into string; only present for stringified long values with non-zero offset");
    private static final ValueInfo[] AUX_DATA_INFOS = new ValueInfo[]{TNULL_INFO, TSCAL_INFO, TZERO_INFO, TDISP_INFO, TBCOL_INFO, TFORM_INFO, LONGOFF_INFO};
    static final BigInteger TWO63 = BigInteger.ONE.shiftLeft(63);
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    protected BintableStarTable(FitsHeader hdr, boolean isRandom, WideFits wide) throws IOException {
        Long theap;
        boolean hasExtCol;
        if (!hdr.getStringValue("XTENSION").equals("BINTABLE")) {
            throw new TableFormatException("Not a binary table header");
        }
        this.nrow_ = hdr.getRequiredLongValue("NAXIS2");
        int ncolStd = hdr.getRequiredIntValue("TFIELDS");
        this.ncol_ = wide != null ? wide.getExtendedColumnCount(hdr, ncolStd) : ncolStd;
        boolean bl = hasExtCol = this.ncol_ > ncolStd;
        if (hasExtCol) {
            assert (wide != null);
            AbstractWideFits.logWideRead(logger_, ncolStd, this.ncol_);
        }
        long heapOffset = isRandom ? ((theap = hdr.getLongValue("THEAP")) != null ? theap : this.nrow_ * hdr.getRequiredLongValue("NAXIS1")) : -1L;
        this.colInfos_ = new ColumnInfo[this.ncol_];
        this.colReaders_ = new ColumnReader[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            BigInteger longOff;
            ColumnReader reader;
            String txtype;
            String tutype;
            String tucd;
            Number zero;
            double scale;
            Double tScal;
            String[] sdims;
            boolean hasBlank;
            long blank;
            Long tnull;
            String tdisp;
            String tunit;
            int jcol = icol + 1;
            BintableColumnHeader colhead = hasExtCol && jcol >= ncolStd ? wide.createExtendedHeader(ncolStd, jcol) : BintableColumnHeader.createStandardHeader(jcol);
            ColumnInfo cinfo = new ColumnInfo("col" + jcol);
            List<DescribedValue> auxdata = cinfo.getAuxData();
            this.colInfos_[icol] = cinfo;
            String ttype = hdr.getStringValue(colhead.getKeyName("TTYPE"));
            if (ttype != null) {
                cinfo.setName(ttype);
            }
            if ((tunit = hdr.getStringValue(colhead.getKeyName("TUNIT"))) != null) {
                cinfo.setUnitString(tunit);
            }
            if ((tdisp = hdr.getStringValue(colhead.getKeyName("TDISP"))) != null) {
                auxdata.add(new DescribedValue(TDISP_INFO, tdisp));
            }
            if ((tnull = hdr.getLongValue(colhead.getKeyName("TNULL"))) != null) {
                blank = tnull;
                hasBlank = true;
                auxdata.add(new DescribedValue(TNULL_INFO, tnull));
            } else {
                cinfo.setNullable(false);
                blank = 0L;
                hasBlank = false;
            }
            int[] dims = null;
            String tdim = hdr.getStringValue(colhead.getKeyName("TDIM"));
            if (tdim != null && (tdim = tdim.trim()).charAt(0) == '(' && tdim.charAt(tdim.length() - 1) == ')' && (sdims = (tdim = tdim.substring(1, tdim.length() - 1).trim()).split(",")).length > 0) {
                try {
                    dims = new int[sdims.length];
                    for (int i = 0; i < sdims.length; ++i) {
                        dims[i] = Integer.parseInt(sdims[i].trim());
                    }
                }
                catch (NumberFormatException e) {
                    dims = null;
                }
            }
            if ((tScal = hdr.getDoubleValue(colhead.getKeyName("TSCAL"))) != null) {
                scale = tScal;
                auxdata.add(new DescribedValue(TSCAL_INFO, tScal));
            } else {
                scale = 1.0;
            }
            Number tZero = hdr.getNumberValue(colhead.getKeyName("TZERO"));
            if (tZero != null) {
                Number zval;
                boolean zInLongRange;
                BigDecimal zbig = new BigDecimal(tZero.toString());
                boolean zIsInt = zbig.compareTo(new BigDecimal(zbig.toBigInteger())) == 0;
                boolean bl2 = zInLongRange = zbig.compareTo(new BigDecimal(BigInteger.valueOf(Long.MIN_VALUE))) >= 0 && zbig.compareTo(new BigDecimal(BigInteger.valueOf(Long.MAX_VALUE))) <= 0;
                if (zbig.compareTo(new BigDecimal(TWO63)) == 0) {
                    zero = TWO63;
                    zval = tZero;
                } else if (zIsInt && zInLongRange) {
                    zero = zbig.longValue();
                    zval = zero;
                } else {
                    zero = zbig.doubleValue();
                    zval = zero;
                }
                DefaultValueInfo zInfo = new DefaultValueInfo(TZERO_INFO);
                zInfo.setContentClass(zval.getClass());
                auxdata.add(new DescribedValue(zInfo, zval));
            } else {
                zero = 0L;
            }
            String tbcol = hdr.getStringValue(colhead.getKeyName("TBCOL"));
            if (tbcol != null) {
                int bcolval = Integer.parseInt(tbcol);
                auxdata.add(new DescribedValue(TBCOL_INFO, bcolval));
            }
            String tform = hdr.getRequiredStringValue(colhead.getKeyName("TFORM"));
            auxdata.add(new DescribedValue(TFORM_INFO, tform));
            String tcomm = hdr.getStringValue(colhead.getKeyName("TCOMM"));
            if (tcomm != null) {
                cinfo.setDescription(tcomm);
            }
            if ((tucd = hdr.getStringValue(colhead.getKeyName("TUCD"))) != null) {
                cinfo.setUCD(tucd);
            }
            if ((tutype = hdr.getStringValue(colhead.getKeyName("TUTYP"))) != null) {
                cinfo.setUtype(tutype);
            }
            if ((txtype = hdr.getStringValue(colhead.getKeyName("TXTYP"))) != null) {
                cinfo.setXtype(txtype);
            }
            try {
                reader = ColumnReader.createColumnReader(tform, scale, zero, hasBlank, blank, dims, ttype, heapOffset);
            }
            catch (TableFormatException e) {
                throw new TableFormatException("Error parsing header line TFORM" + jcol + " = " + tform, e);
            }
            if (reader.getContentClass().equals(String.class)) {
                cinfo.setNullable(true);
            }
            cinfo.setContentClass(reader.getContentClass());
            if (reader.getLength() > 0) {
                cinfo.setShape(reader.getShape());
            }
            cinfo.setElementSize(reader.getElementSize());
            if (reader.isUnsignedByte()) {
                cinfo.setAuxDatum(new DescribedValue(Tables.UBYTE_FLAG_INFO, Boolean.TRUE));
            }
            if ((longOff = reader.getLongOffset()) != null) {
                assert (!BigInteger.ZERO.equals(longOff));
                cinfo.setAuxDatum(new DescribedValue(LONGOFF_INFO, longOff.toString()));
            }
            this.colReaders_[icol] = reader;
        }
        long leng = 0L;
        this.colOffsets_ = new long[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            this.colOffsets_[icol] = leng;
            leng += (long)this.colReaders_[icol].getLength();
        }
        this.rowLength_ = hdr.getRequiredLongValue("NAXIS1");
        if (!hasExtCol && this.rowLength_ != leng) {
            throw new TableFormatException("Got wrong row length: " + this.rowLength_ + " != " + leng);
        }
        String extname = hdr.getStringValue("EXTNAME");
        if (extname != null) {
            String tname = extname;
            String extver = hdr.getStringValue("EXTVER");
            if (extver != null) {
                tname = tname + "-" + extver;
            }
            this.setName(tname);
        }
        if ("HEALPIX".equals(hdr.getStringValue("PIXTYPE")) && hdr.getIntValue("MOCORDER") == null && hdr.getStringValue("MOCVERS") == null) {
            HealpixTableInfo hpxInfo = null;
            try {
                hpxInfo = BintableStarTable.extractHealpixInfo(hdr, this.colInfos_);
            }
            catch (Exception e) {
                logger_.log(Level.WARNING, "HEALPix header parse failure: " + e.getMessage(), e);
            }
            if (hpxInfo != null) {
                this.getParameters().addAll(Arrays.asList(hpxInfo.toParams()));
            }
        }
        List<DescribedValue> params = this.getParameters();
        for (DescribedValue dval0 : hdr.getUnusedParams()) {
            DescribedValue dval1 = BintableStarTable.adjustParameter(dval0);
            if (dval1 == null) continue;
            params.add(dval1);
        }
    }

    @Override
    public long getRowCount() {
        return this.nrow_;
    }

    @Override
    public int getColumnCount() {
        return this.ncol_;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    @Override
    public List<ValueInfo> getColumnAuxDataInfos() {
        return Arrays.asList(AUX_DATA_INFOS);
    }

    protected Object readCell(BasicInput stream, int icol) throws IOException {
        return this.colReaders_[icol].readValue(stream);
    }

    protected Object[] readRow(BasicInput stream) throws IOException {
        Object[] row = new Object[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            row[icol] = this.colReaders_[icol].readValue(stream);
        }
        return row;
    }

    protected long getRowLength() {
        return this.rowLength_;
    }

    protected long[] getColumnOffsets() {
        return this.colOffsets_;
    }

    public static BintableStarTable createTable(FitsHeader hdr, InputFactory inputFact, WideFits wide) throws IOException {
        return inputFact.isRandom() ? new RandomBintableStarTable(hdr, inputFact, wide) : new SequentialBintableStarTable(hdr, inputFact, wide);
    }

    public static void streamStarTable(FitsHeader hdr, BasicInput input, WideFits wide, TableSink sink) throws IOException {
        InputFactory dummyFact = new InputFactory(){

            @Override
            public boolean isRandom() {
                return false;
            }

            @Override
            public BasicInput createInput(boolean isSeq) {
                throw new UnsupportedOperationException("Metadata only");
            }

            @Override
            public void close() {
            }
        };
        SequentialBintableStarTable meta = new SequentialBintableStarTable(hdr, dummyFact, wide);
        sink.acceptMetadata(meta);
        long nrow = meta.getRowCount();
        for (long i = 0L; i < nrow; ++i) {
            Object[] row = meta.readRow(input);
            sink.acceptRow(row);
        }
        sink.endRows();
    }

    private static HealpixTableInfo extractHealpixInfo(FitsHeader hdr, ColumnInfo[] infos) {
        HealpixTableInfo.HpxCoordSys csys;
        String ipixColName;
        boolean isNest;
        Long nSide = hdr.getLongValue("NSIDE");
        if (nSide == null) {
            throw new IllegalStateException("No HEALPix NSIDE header");
        }
        long nside = nSide;
        int level = Long.numberOfTrailingZeros(nside);
        if ((long)(1 << level) != nside) {
            throw new IllegalStateException("Invalid HEALPix header value NSIDE=" + nside);
        }
        String ordering = hdr.getStringValue("ORDERING");
        if (ordering == null) {
            throw new IllegalStateException("Missing HEALPix header ORDERING");
        }
        if ("NESTED".equals(ordering)) {
            isNest = true;
        } else if ("RING".equals(ordering)) {
            isNest = false;
        } else {
            throw new IllegalStateException("Unrecognised HEALPix header ORDERING='" + ordering + "'");
        }
        String indxschm = hdr.getStringValue("INDXSCHM");
        if (indxschm == null) {
            logger_.warning("Missing nominally required HEALPix header INDXSCHM, assuming IMPLICIT");
            ipixColName = null;
        } else if ("IMPLICIT".equals(indxschm)) {
            ipixColName = null;
        } else if ("EXPLICIT".equals(indxschm)) {
            ipixColName = infos[0].getName();
        } else {
            throw new IllegalStateException("Unrecognised HEALPix header INDXSCHM='" + indxschm + "'");
        }
        String coordsys = hdr.getStringValue("COORDSYS");
        if (coordsys != null) {
            if (coordsys.trim().length() == 1) {
                csys = HealpixTableInfo.HpxCoordSys.fromCharacter(coordsys.charAt(0));
            } else {
                csys = BintableStarTable.guessHealpixCoordSys(coordsys.trim());
                if (csys != null) {
                    logger_.warning("Guessing HEALPix header COORDSYS='" + coordsys + "' -> " + csys.getWord());
                }
            }
            if (csys == null) {
                logger_.warning("Unknown HEALPix header COORDSYS='" + coordsys + "'");
            }
        } else {
            csys = null;
        }
        return new HealpixTableInfo(level, isNest, ipixColName, csys);
    }

    private static HealpixTableInfo.HpxCoordSys guessHealpixCoordSys(String coordsysTxt) {
        String ctxt = coordsysTxt.toUpperCase();
        if (ctxt.startsWith("GAL")) {
            return HealpixTableInfo.HpxCoordSys.GALACTIC;
        }
        if (ctxt.startsWith("ECL")) {
            return HealpixTableInfo.HpxCoordSys.ECLIPTIC;
        }
        if (ctxt.startsWith("EQU") || ctxt.startsWith("CEL")) {
            return HealpixTableInfo.HpxCoordSys.CELESTIAL;
        }
        return null;
    }

    private static DescribedValue adjustParameter(DescribedValue dval0) {
        Object value = dval0.getValue();
        if (value instanceof String) {
            Object array = FitsUtil.asNumericArray((String)value);
            if (array instanceof int[] || array instanceof double[]) {
                ValueInfo info0 = dval0.getInfo();
                DefaultValueInfo info1 = new DefaultValueInfo(info0.getName(), array.getClass(), info0.getDescription());
                info1.setShape(new int[]{Array.getLength(array)});
                return new DescribedValue(info1, array);
            }
            return dval0;
        }
        return dval0;
    }

    private static class RandomBintableStarTable
    extends BintableStarTable {
        private final InputFactory inputFact_;
        private final BasicInputThreadLocal randomInputThreadLocal_;
        private final long rowLength_;
        private final long[] colOffsets_;

        RandomBintableStarTable(FitsHeader hdr, InputFactory inputFact, WideFits wide) throws IOException {
            super(hdr, true, wide);
            this.inputFact_ = inputFact;
            if (!inputFact.isRandom()) {
                throw new IllegalArgumentException("not random");
            }
            this.rowLength_ = this.getRowLength();
            this.colOffsets_ = this.getColumnOffsets();
            this.randomInputThreadLocal_ = new BasicInputThreadLocal(inputFact, false);
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public Object getCell(long lrow, int icol) throws IOException {
            BasicInput randomInput = (BasicInput)this.randomInputThreadLocal_.get();
            randomInput.seek(lrow * this.rowLength_ + this.colOffsets_[icol]);
            return this.readCell(randomInput, icol);
        }

        @Override
        public Object[] getRow(long lrow) throws IOException {
            BasicInput randomInput = (BasicInput)this.randomInputThreadLocal_.get();
            randomInput.seek(lrow * this.rowLength_);
            return this.readRow(randomInput);
        }

        @Override
        public RowSequence getRowSequence() throws IOException {
            final BasicInput input = this.inputFact_.createInput(true);
            assert (input.isRandom());
            final long endPos = this.getRowCount() * this.rowLength_;
            return new RowSequence(){
                long pos;
                {
                    this.pos = -rowLength_;
                }

                @Override
                public boolean next() {
                    this.pos += rowLength_;
                    return this.pos < endPos;
                }

                @Override
                public Object getCell(int icol) throws IOException {
                    if (this.pos >= 0L && this.pos < endPos) {
                        input.seek(this.pos + colOffsets_[icol]);
                        return this.readCell(input, icol);
                    }
                    throw new IllegalStateException();
                }

                @Override
                public Object[] getRow() throws IOException {
                    if (this.pos >= 0L && this.pos < endPos) {
                        input.seek(this.pos);
                        return this.readRow(input);
                    }
                    throw new IllegalStateException();
                }

                @Override
                public void close() throws IOException {
                    input.close();
                }
            };
        }

        @Override
        public RowAccess getRowAccess() throws IOException {
            final BasicInput input = this.inputFact_.createInput(false);
            assert (input.isRandom());
            return new RowAccess(){
                long irow_ = -1L;

                @Override
                public void setRowIndex(long irow) {
                    this.irow_ = irow;
                }

                @Override
                public Object getCell(int icol) throws IOException {
                    input.seek(this.irow_ * rowLength_ + colOffsets_[icol]);
                    return this.readCell(input, icol);
                }

                @Override
                public Object[] getRow() throws IOException {
                    input.seek(this.irow_ * rowLength_);
                    return this.readRow(input);
                }

                @Override
                public void close() throws IOException {
                    input.close();
                }
            };
        }

        @Override
        public void close() throws IOException {
            this.randomInputThreadLocal_.close();
            this.inputFact_.close();
        }
    }

    private static class SequentialBintableStarTable
    extends BintableStarTable {
        private final InputFactory inputFact_;

        public SequentialBintableStarTable(FitsHeader hdr, InputFactory inputFact, WideFits wide) throws IOException {
            super(hdr, false, wide);
            this.inputFact_ = inputFact;
        }

        @Override
        public boolean isRandom() {
            return false;
        }

        @Override
        public Object getCell(long lrow, int icol) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] getRow(long lrow) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public RowSequence getRowSequence() throws IOException {
            final BasicInput input = this.inputFact_.createInput(true);
            final Object[] beforeStart = new Object[]{};
            final long nrow = this.getRowCount();
            final long rowLength = this.getRowLength();
            return new RowSequence(){
                long lrow_ = -1L;
                Object[] row_ = beforeStart;
                long nskip_ = 0L;

                @Override
                public boolean next() throws IOException {
                    if (this.lrow_ < nrow - 1L) {
                        if (this.row_ == null) {
                            this.nskip_ += rowLength;
                        }
                        this.row_ = null;
                        ++this.lrow_;
                        return true;
                    }
                    return false;
                }

                @Override
                public Object getCell(int icol) throws IOException {
                    return this.getRow()[icol];
                }

                @Override
                public Object[] getRow() throws IOException {
                    if (this.row_ == beforeStart) {
                        throw new IllegalStateException();
                    }
                    if (this.row_ == null) {
                        if (this.nskip_ != 0L) {
                            input.skip(this.nskip_);
                            this.nskip_ = 0L;
                        }
                        this.row_ = this.readRow(input);
                    }
                    return this.row_;
                }

                @Override
                public void close() throws IOException {
                    if (this.nskip_ != 0L) {
                        input.skip(this.nskip_);
                        this.nskip_ = 0L;
                    }
                    input.close();
                }
            };
        }

        @Override
        public void close() throws IOException {
            this.inputFact_.close();
        }
    }
}

