/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.nio.channels.FileChannel;
import uk.ac.starlink.fits.BufferManager;
import uk.ac.starlink.fits.Unmapper;

public class BlockManager {
    private final int nblock_;
    private final int blockSize_;
    private final BufferManager[] bufManagers_;
    public static final int DEFAULT_BLOCKSIZE = 0x10000000;

    public BlockManager(FileChannel chan, long offset, long size, String logName, Unmapper unmapper, int blockSize) {
        this.blockSize_ = blockSize;
        long blockSizeL = blockSize;
        long nb = (size - 1L) / blockSizeL + 1L;
        this.nblock_ = (int)nb;
        if ((long)this.nblock_ != nb) {
            throw new IllegalArgumentException("Block count " + nb + " too high");
        }
        this.bufManagers_ = new BufferManager[this.nblock_];
        for (int ib = 0; ib < this.nblock_; ++ib) {
            long off1 = (long)ib * blockSizeL;
            long leng1 = Math.min(blockSizeL, size - off1);
            int ileng1 = (int)leng1;
            assert ((long)ileng1 == leng1);
            String label1 = "file region " + (ib + 1) + "/" + this.nblock_ + " of " + logName;
            this.bufManagers_[ib] = new BufferManager(chan, offset + off1, ileng1, label1, unmapper);
        }
    }

    public int getBlockCount() {
        return this.nblock_;
    }

    public int getBlockSize() {
        return this.blockSize_;
    }

    public BufferManager getBufferManager(int ib) {
        return this.bufManagers_[ib];
    }

    public void close() {
        for (BufferManager bufMan : this.bufManagers_) {
            bufMan.close();
        }
    }
}

