/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import uk.ac.starlink.fits.BasicInput;
import uk.ac.starlink.fits.BlockManager;
import uk.ac.starlink.fits.BlockMappedInput;
import uk.ac.starlink.fits.BufferManager;
import uk.ac.starlink.fits.BufferedRandomInput;
import uk.ac.starlink.fits.ByteBufferInput;
import uk.ac.starlink.fits.MultiByteBufferInput;
import uk.ac.starlink.fits.SimpleMappedInput;
import uk.ac.starlink.fits.Unmapper;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.DataBufferedInputStream;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.util.Loader;

public abstract class InputFactory
implements Closeable {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    public abstract boolean isRandom();

    public abstract BasicInput createInput(boolean var1) throws IOException;

    public static InputFactory createFactory(DataSource datsrc, long offset, long leng) throws IOException {
        boolean isFile = datsrc instanceof FileDataSource;
        if (isFile && datsrc.getCompression() == Compression.NONE) {
            File uncompressedFile = ((FileDataSource)datsrc).getFile();
            return InputFactory.createFileFactory(uncompressedFile, offset, leng);
        }
        if (isFile) {
            logger_.warning("Can't map compressed file " + datsrc.getName() + " - uncompressing may improve performance");
        } else {
            logger_.info("Will read stream (not random-access): " + datsrc);
        }
        return InputFactory.createSequentialFactory(datsrc, offset, leng);
    }

    public static InputFactory createSequentialFactory(final DataSource datsrc, final long offset, long leng) {
        return new AbstractInputFactory(false){

            @Override
            public BasicInput createInput(boolean isSeq) throws IOException {
                InputStream in = datsrc.getInputStream();
                IOUtils.skip((InputStream)in, (long)offset);
                return 1.createSequentialInput(in);
            }

            @Override
            public void close() {
                datsrc.close();
            }
        };
    }

    public static InputFactory createFileFactory(File uncompressedFile, final long offset, long leng) throws IOException {
        final File file = uncompressedFile;
        String logName = file.getName();
        Unmapper unmapper = Unmapper.getInstance();
        if (leng <= 0x20000000L) {
            logger_.info("Will map as single block: " + logName);
            int ileng = (int)leng;
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            final FileChannel chan = raf.getChannel();
            final BufferManager bufManager = new BufferManager(chan, offset, ileng, logName, unmapper);
            return new AbstractInputFactory(true){

                @Override
                public BasicInput createInput(boolean isSeq) throws IOException {
                    return new SimpleMappedInput(bufManager);
                }

                @Override
                public void close() throws IOException {
                    chan.close();
                    bufManager.close();
                }
            };
        }
        if (Loader.is64Bit()) {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            final FileChannel chan = raf.getChannel();
            final BlockManager blockManager = new BlockManager(chan, offset, leng, logName, unmapper, 0x10000000);
            logger_.info("Will map as multiple blocks (" + blockManager.getBlockCount() + " * " + blockManager.getBlockSize() + "): " + logName);
            return new AbstractInputFactory(true){

                @Override
                public BasicInput createInput(boolean isSeq) throws IOException {
                    return BlockMappedInput.createInput(blockManager, !isSeq);
                }

                @Override
                public void close() throws IOException {
                    chan.close();
                    blockManager.close();
                }
            };
        }
        logger_.info("Will read as BufferedRandomInput: " + file + " (avoid too much mapping on 32-bit OS");
        return new AbstractInputFactory(true){

            @Override
            public BasicInput createInput(boolean isSeq) throws IOException {
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                return new BufferedRandomInput(raf, offset);
            }

            @Override
            public void close() {
            }
        };
    }

    public static InputFactory createRandomFactory(DataSource datsrc, long offset, long leng, StoragePolicy policy) throws IOException {
        boolean isFile = datsrc instanceof FileDataSource;
        if (isFile && datsrc.getCompression() == Compression.NONE) {
            File uncompressedFile = ((FileDataSource)datsrc).getFile();
            return InputFactory.createFileFactory(uncompressedFile, offset, leng);
        }
        logger_.warning("Caching non-random FITS data");
        ByteStore byteStore = (policy == null ? StoragePolicy.getDefaultPolicy() : policy).makeByteStore();
        try (InputStream in = datsrc.getInputStream();
             OutputStream out = byteStore.getOutputStream();){
            IOUtils.skip((InputStream)in, (long)offset);
            byte[] buf = new byte[65536];
            while (leng > 0L) {
                int nb = in.read(buf, 0, (int)Math.min(leng, (long)buf.length));
                if (nb < 0) {
                    throw new EOFException("FITS file too short");
                }
                out.write(buf, 0, nb);
                leng -= (long)nb;
            }
        }
        return InputFactory.createByteStoreFactory(byteStore);
    }

    public static InputFactory createByteStoreFactory(final ByteStore byteStore) throws IOException {
        final ByteBuffer[] bbufs = byteStore.toByteBuffers();
        final int nbuf = bbufs.length;
        if (nbuf == 1) {
            final ByteBuffer bbuf = bbufs[0];
            return new AbstractInputFactory(true){

                @Override
                public BasicInput createInput(boolean isSeq) {
                    return new ByteBufferInput(bbuf.duplicate());
                }

                @Override
                public void close() throws IOException {
                    byteStore.close();
                }
            };
        }
        return new AbstractInputFactory(true){

            @Override
            public BasicInput createInput(boolean isSeq) {
                ByteBuffer[] bbufs1 = new ByteBuffer[nbuf];
                for (int ib = 0; ib < nbuf; ++ib) {
                    bbufs1[ib] = bbufs[ib].duplicate();
                }
                return new MultiByteBufferInput(bbufs1);
            }

            @Override
            public void close() throws IOException {
                byteStore.close();
            }
        };
    }

    public static BasicInput createSequentialInput(InputStream in) {
        final DataBufferedInputStream dataIn = new DataBufferedInputStream(in);
        return new BasicInput(){

            @Override
            public byte readByte() throws IOException {
                return dataIn.readByte();
            }

            @Override
            public short readShort() throws IOException {
                return dataIn.readShort();
            }

            @Override
            public int readInt() throws IOException {
                return dataIn.readInt();
            }

            @Override
            public long readLong() throws IOException {
                return dataIn.readLong();
            }

            @Override
            public float readFloat() throws IOException {
                return dataIn.readFloat();
            }

            @Override
            public double readDouble() throws IOException {
                return dataIn.readDouble();
            }

            @Override
            public void readBytes(byte[] bbuf) throws IOException {
                dataIn.readFully(bbuf);
            }

            @Override
            public void skip(long nbyte) throws IOException {
                IOUtils.skip((InputStream)dataIn, (long)nbyte);
            }

            @Override
            public boolean isRandom() {
                return false;
            }

            @Override
            public void seek(long offset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getOffset() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
            }
        };
    }

    private static abstract class AbstractInputFactory
    extends InputFactory {
        private final boolean isRandom_;

        AbstractInputFactory(boolean isRandom) {
            this.isRandom_ = isRandom;
        }

        @Override
        public boolean isRandom() {
            return this.isRandom_;
        }
    }
}

