/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.MultiTableBuilder;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.formats.LineSequence;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.URLUtils;

public class VerTableBuilder
implements MultiTableBuilder {
    private static final int POS_VERTEX_DFLT = 1;
    private static final int POS_PLATE = 2;

    @Override
    public String getFormatName() {
        return "ver";
    }

    @Override
    public boolean looksLikeFile(String location) {
        return location.endsWith(".ver");
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    public boolean canStream() {
        return false;
    }

    @Override
    public void streamStarTable(InputStream in, TableSink sink, String pos) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TableSequence makeStarTables(DataSource datsrc, StoragePolicy policy) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(datsrc.getInputStream());){
            NumReader rdr = new NumReader(in);
            int[] counts = rdr.readInts(true, 2);
            int nVertex = counts[0];
            int nPlate = counts[1];
            RowStore vertexStore = policy.makeRowStore();
            this.streamVertexTable(rdr, nVertex, vertexStore);
            final StarTable vertexTable = vertexStore.getStarTable();
            this.setVertexMeta(vertexTable, datsrc);
            assert (vertexTable.isRandom());
            VertexStore vertices = new VertexStore(){

                @Override
                public double getCoord(int iv, int ic) throws IOException {
                    return ((Number)vertexTable.getCell(iv, ic)).doubleValue();
                }
            };
            RowStore plateStore = policy.makeRowStore();
            this.streamPlateTable(rdr, nPlate, vertices, plateStore);
            StarTable plateTable = plateStore.getStarTable();
            this.setPlateMeta(plateTable, datsrc);
            TableSequence tableSequence = Tables.arrayTableSequence(new StarTable[]{vertexTable, plateTable});
            return tableSequence;
        }
    }

    @Override
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storagePolicy) throws IOException {
        int ipos;
        String pos = datsrc.getPosition();
        if (pos == null || pos.trim().length() == 0) {
            ipos = 1;
        } else if (pos.trim().matches("[0-9]+")) {
            ipos = Integer.parseInt(pos.trim());
        } else {
            throw new TableFormatException("Unknown pos: " + pos + "; should be " + 1 + " or " + 2);
        }
        if (ipos == 1) {
            try (BufferedInputStream in = new BufferedInputStream(datsrc.getInputStream());){
                NumReader rdr = new NumReader(in);
                int[] counts = rdr.readInts(true, 2);
                int nVertex = counts[0];
                int nPlate = counts[1];
                RowStore vertexStore = storagePolicy.makeRowStore();
                this.streamVertexTable(rdr, nVertex, vertexStore);
                StarTable vertexTable = vertexStore.getStarTable();
                this.setVertexMeta(vertexTable, datsrc);
                StarTable starTable = vertexTable;
                return starTable;
            }
        }
        if (ipos == 2) {
            TableSequence tseq = this.makeStarTables(datsrc, storagePolicy);
            tseq.nextTable();
            return tseq.nextTable();
        }
        throw new TableFormatException("Unknown pos: " + ipos + "; should be " + 1 + " or " + 2);
    }

    private ColumnInfo[] createVertexTableInfos() {
        ColumnInfo[] infos = new ColumnInfo[3];
        for (int ic = 0; ic < 3; ++ic) {
            String letter = (new String[]{"X", "Y", "Z"})[ic];
            ColumnInfo info = new ColumnInfo(letter, Double.class, letter + " coordinate");
            info.setUCD("pos.cartesian." + letter.toLowerCase());
            infos[ic] = info;
        }
        return infos;
    }

    private void streamVertexTable(NumReader rdr, int nVertex, TableSink sink) throws IOException {
        sink.acceptMetadata(VerTableBuilder.createDummyTable(this.createVertexTableInfos(), nVertex));
        for (int i = 0; i < nVertex; ++i) {
            int ic;
            double[] values = rdr.readDoubles(true, -1);
            int nval = values.length;
            switch (values.length) {
                case 3: {
                    ic = 0;
                    break;
                }
                case 4: {
                    ic = 1;
                    break;
                }
                default: {
                    throw new TableFormatException("Expecting 3 or 4 values, found " + values.length + rdr.atRow());
                }
            }
            double x = values[ic + 0];
            double y = values[ic + 1];
            double z = values[ic + 2];
            sink.acceptRow(new Object[]{x, y, z});
        }
        sink.endRows();
    }

    private ColumnInfo[] createPlateTableInfos() {
        ArrayList<ColumnInfo> infos = new ArrayList<ColumnInfo>();
        infos.addAll(Arrays.asList(this.createVertexTableInfos()));
        ColumnInfo othersInfo = new ColumnInfo("others", double[].class, "other coords in plate");
        othersInfo.setShape(new int[]{6});
        infos.add(othersInfo);
        return infos.toArray(new ColumnInfo[0]);
    }

    private void streamPlateTable(NumReader rdr, int nPlate, VertexStore vertices, TableSink sink) throws IOException {
        sink.acceptMetadata(VerTableBuilder.createDummyTable(this.createPlateTableInfos(), nPlate));
        for (int i = 0; i < nPlate; ++i) {
            int[] iv1s;
            int[] values = rdr.readInts(true, -1);
            switch (values.length) {
                case 1: {
                    int nv = values[0];
                    iv1s = rdr.readInts(true, nv);
                    break;
                }
                case 3: {
                    iv1s = new int[]{values[0], values[1], values[2]};
                    break;
                }
                case 4: {
                    int index = values[0];
                    iv1s = new int[]{values[1], values[2], values[3]};
                    break;
                }
                default: {
                    throw new TableFormatException("Found " + values.length + " values, expecting 1, 3 or 4" + rdr.atRow());
                }
            }
            int iv0 = iv1s[0] - 1;
            double x0 = vertices.getCoord(iv0, 0);
            double y0 = vertices.getCoord(iv0, 1);
            double z0 = vertices.getCoord(iv0, 2);
            int nv = iv1s.length;
            double[] otherCoords = new double[(nv - 1) * 3];
            for (int iv = 1; iv < nv; ++iv) {
                int ic3 = (iv - 1) * 3;
                iv0 = iv1s[iv] - 1;
                otherCoords[ic3 + 0] = vertices.getCoord(iv0, 0);
                otherCoords[ic3 + 1] = vertices.getCoord(iv0, 1);
                otherCoords[ic3 + 2] = vertices.getCoord(iv0, 2);
            }
            sink.acceptRow(new Object[]{x0, y0, z0, otherCoords});
        }
        sink.endRows();
    }

    private void setVertexMeta(StarTable table, DataSource datsrc) {
        this.setTableMeta(table, datsrc, "vertex", 1);
    }

    private void setPlateMeta(StarTable table, DataSource datsrc) {
        this.setTableMeta(table, datsrc, "plate", 2);
    }

    private void setTableMeta(StarTable table, DataSource datsrc, String type, int ipos) {
        int idot;
        String name = datsrc.getName();
        String tail = new File(name).getName();
        if (tail.length() < name.length()) {
            name = tail;
        }
        if ((idot = name.lastIndexOf(46)) >= 0) {
            name = name.substring(0, idot);
        }
        table.setName(name + "-" + type);
        URL srcUrl = datsrc.getURL();
        if (srcUrl != null) {
            String outTxt = srcUrl.toString().replaceAll("#.*", "");
            if (ipos != 1) {
                outTxt = outTxt + "#" + ipos;
            }
            table.setURL(URLUtils.makeURL(outTxt));
        }
    }

    private static StarTable createDummyTable(final ColumnInfo[] infos, final long nrow) {
        return new AbstractStarTable(){

            @Override
            public int getColumnCount() {
                return infos.length;
            }

            @Override
            public ColumnInfo getColumnInfo(int ic) {
                return infos[ic];
            }

            @Override
            public long getRowCount() {
                return nrow;
            }

            @Override
            public RowSequence getRowSequence() {
                throw new UnsupportedOperationException("Metadata only");
            }
        };
    }

    private static class NumReader {
        final LineSequence lseq_;
        long iline_;

        NumReader(InputStream in) {
            this.lseq_ = new LineSequence(in);
        }

        int[] readInts(boolean isReq, int nValue) throws IOException {
            String[] tokens = this.readTokens(isReq);
            if (tokens == null) {
                return null;
            }
            int ntok = tokens.length;
            int[] values = new int[ntok];
            for (int i = 0; i < ntok; ++i) {
                try {
                    values[i] = Integer.parseInt(tokens[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new TableFormatException("Not integer" + this.atRow() + ": " + tokens[i]);
                }
            }
            if (nValue >= 0 && nValue != ntok) {
                throw new TableFormatException("Expecting " + nValue + " values, found " + ntok + this.atRow());
            }
            return values;
        }

        double[] readDoubles(boolean isReq, int nValue) throws IOException {
            String[] tokens = this.readTokens(isReq);
            if (tokens == null) {
                return null;
            }
            int ntok = tokens.length;
            double[] values = new double[ntok];
            for (int i = 0; i < ntok; ++i) {
                try {
                    values[i] = Double.parseDouble(tokens[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new TableFormatException("Not numeric" + this.atRow() + ": " + tokens[i]);
                }
            }
            if (nValue >= 0 && nValue != ntok) {
                throw new TableFormatException("Expecting " + nValue + " values, found " + ntok + this.atRow());
            }
            return values;
        }

        String[] readTokens(boolean isRequired) throws IOException {
            String line = this.lseq_.nextLine();
            if (line == null) {
                if (isRequired) {
                    throw new TableFormatException("Premature file end" + this.atRow());
                }
                return null;
            }
            ++this.iline_;
            return line.trim().split("\\s+", 0);
        }

        private String atRow() {
            return " at row " + this.iline_;
        }
    }

    private static interface VertexStore {
        public double getCoord(int var1, int var2) throws IOException;
    }
}

