/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.starlink.table.gui.ViewHugeTableModel;

public class ViewHugeSelectionModel
implements ListSelectionModel {
    private final ListSelectionModel hugeModel_;
    private final Map<ListSelectionListener, HugeListener> listenerMap_;
    private int viewBase_;

    public ViewHugeSelectionModel(ListSelectionModel hugeModel, final ViewHugeTableModel tmodel) {
        this.hugeModel_ = hugeModel;
        this.listenerMap_ = new LinkedHashMap<ListSelectionListener, HugeListener>();
        tmodel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("viewBase".equals(evt.getPropertyName())) {
                    int vbase = tmodel.getViewBase();
                    assert (ViewHugeSelectionModel.this.viewBase_ == ((Number)evt.getOldValue()).intValue());
                    assert (vbase == ((Number)evt.getNewValue()).intValue());
                    assert (vbase != ViewHugeSelectionModel.this.viewBase_);
                    ViewHugeSelectionModel.this.viewBase_ = vbase;
                    ListSelectionEvent sevt = new ListSelectionEvent(ViewHugeSelectionModel.this, 0, tmodel.getRowCount(), false);
                    for (ListSelectionListener lnr : ViewHugeSelectionModel.this.listenerMap_.keySet()) {
                        lnr.valueChanged(sevt);
                    }
                }
            }
        });
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        this.hugeModel_.setSelectionInterval(this.toHuge(index0), this.toHuge(index1));
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        this.hugeModel_.addSelectionInterval(this.toHuge(index0), this.toHuge(index1));
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        this.hugeModel_.removeSelectionInterval(this.toHuge(index0), this.toHuge(index1));
    }

    @Override
    public int getMinSelectionIndex() {
        return this.fromHuge(this.hugeModel_.getMinSelectionIndex());
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.fromHuge(this.hugeModel_.getMaxSelectionIndex());
    }

    @Override
    public boolean isSelectedIndex(int index) {
        return this.hugeModel_.isSelectedIndex(this.toHuge(index));
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.fromHuge(this.hugeModel_.getAnchorSelectionIndex());
    }

    @Override
    public void setAnchorSelectionIndex(int index) {
        this.hugeModel_.setAnchorSelectionIndex(this.toHuge(index));
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.fromHuge(this.hugeModel_.getLeadSelectionIndex());
    }

    @Override
    public void setLeadSelectionIndex(int index) {
        this.hugeModel_.setLeadSelectionIndex(this.toHuge(index));
    }

    @Override
    public void clearSelection() {
        this.hugeModel_.clearSelection();
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.hugeModel_.isSelectionEmpty();
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
        this.hugeModel_.insertIndexInterval(this.toHuge(index), length, before);
    }

    @Override
    public void removeIndexInterval(int index0, int index1) {
        this.hugeModel_.removeIndexInterval(this.toHuge(index0), this.toHuge(index1));
    }

    @Override
    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.hugeModel_.setValueIsAdjusting(valueIsAdjusting);
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.hugeModel_.getValueIsAdjusting();
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        this.hugeModel_.setSelectionMode(selectionMode);
    }

    @Override
    public int getSelectionMode() {
        return this.hugeModel_.getSelectionMode();
    }

    @Override
    public void addListSelectionListener(ListSelectionListener viewLnr) {
        HugeListener hugeLnr = new HugeListener(viewLnr);
        this.listenerMap_.put(viewLnr, hugeLnr);
        this.hugeModel_.addListSelectionListener(hugeLnr);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener viewLnr) {
        HugeListener hugeLnr = this.listenerMap_.remove(viewLnr);
        this.hugeModel_.removeListSelectionListener(hugeLnr);
    }

    private int toHuge(int viewIndex) {
        return viewIndex >= 0 ? viewIndex + this.viewBase_ : viewIndex;
    }

    private int fromHuge(int hugeIndex) {
        return hugeIndex >= 0 ? hugeIndex - this.viewBase_ : hugeIndex;
    }

    private class HugeListener
    implements ListSelectionListener {
        final ListSelectionListener viewListener_;

        HugeListener(ListSelectionListener viewListener) {
            this.viewListener_ = viewListener;
        }

        @Override
        public void valueChanged(ListSelectionEvent hugeEvt) {
            ListSelectionEvent viewEvt = new ListSelectionEvent(this, ViewHugeSelectionModel.this.fromHuge(hugeEvt.getFirstIndex()), ViewHugeSelectionModel.this.fromHuge(hugeEvt.getLastIndex()), hugeEvt.getValueIsAdjusting());
            this.viewListener_.valueChanged(viewEvt);
        }
    }
}

