/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import uk.ac.starlink.table.ByteStore;

public class LimitByteStore
implements ByteStore {
    private final ByteStore base_;
    private final long limit_;
    private final OutputStream out_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.storage");

    public LimitByteStore(ByteStore base, long limit) {
        this.base_ = base;
        this.limit_ = limit;
        final OutputStream baseOut = this.base_.getOutputStream();
        this.out_ = new FilterOutputStream(baseOut){
            private long count_;

            @Override
            public void write(byte[] buf, int off, int leng) throws IOException {
                this.preWrite(leng);
                baseOut.write(buf, off, leng);
                this.count_ += (long)leng;
            }

            @Override
            public void write(byte[] buf) throws IOException {
                this.preWrite(buf.length);
                baseOut.write(buf);
                this.count_ += (long)buf.length;
            }

            @Override
            public void write(int b) throws IOException {
                this.preWrite(1);
                baseOut.write(b);
                ++this.count_;
            }

            private void preWrite(int n) throws IOException {
                if (this.count_ + (long)n > LimitByteStore.this.limit_) {
                    throw new IOException("Write size limit of " + LimitByteStore.this.limit_ + " exceeded");
                }
            }
        };
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out_;
    }

    @Override
    public long getLength() {
        return this.base_.getLength();
    }

    @Override
    public void copy(OutputStream out) throws IOException {
        this.base_.copy(out);
    }

    @Override
    public ByteBuffer[] toByteBuffers() throws IOException {
        return this.base_.toByteBuffers();
    }

    @Override
    public void close() {
        try {
            this.out_.close();
            this.base_.close();
        }
        catch (IOException e) {
            logger_.warning("close error: " + e);
        }
    }
}

