/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.logging.Logger;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;

public class MonitorStoragePolicy
extends StoragePolicy {
    private final StoragePolicy base_;
    private final TableSink sink_;
    private boolean interrupted_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table");

    public MonitorStoragePolicy(StoragePolicy base, TableSink sink) {
        this.base_ = base;
        this.sink_ = sink;
    }

    public void interrupt() {
        this.interrupted_ = true;
    }

    public boolean isInterrupted() {
        return this.interrupted_;
    }

    public StoragePolicy getBasePolicy() {
        return this.base_;
    }

    @Override
    public RowStore makeRowStore() {
        return new TeeRowStore(this.base_.makeRowStore(), this.sink_);
    }

    @Override
    public RowStore makeConfiguredRowStore(StarTable meta) {
        TeeRowStore store = new TeeRowStore(this.base_.makeConfiguredRowStore(meta), this.sink_);
        try {
            this.sink_.acceptMetadata(meta);
        }
        catch (TableFormatException e) {
            logger_.warning("Table monitor failed: " + e);
        }
        return store;
    }

    @Override
    public ByteStore makeByteStore() {
        return this.base_.makeByteStore();
    }

    private class TeeRowStore
    implements RowStore {
        private final RowStore baseStore_;
        private final TableSink sink_;
        private long irow_;

        TeeRowStore(RowStore base, TableSink sink) {
            this.baseStore_ = base;
            this.sink_ = sink;
        }

        @Override
        public void acceptMetadata(StarTable meta) throws TableFormatException {
            this.baseStore_.acceptMetadata(meta);
            this.sink_.acceptMetadata(meta);
        }

        @Override
        public void acceptRow(Object[] row) throws IOException {
            if (MonitorStoragePolicy.this.interrupted_) {
                throw new InterruptedIOException();
            }
            this.baseStore_.acceptRow(row);
            this.sink_.acceptRow(row);
        }

        @Override
        public void endRows() throws IOException {
            this.baseStore_.endRows();
            this.sink_.endRows();
        }

        @Override
        public StarTable getStarTable() {
            return this.baseStore_.getStarTable();
        }
    }
}

