/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.storage.ColumnWidth;

abstract class Offsets {
    Offsets() {
    }

    public abstract long getRowOffset(long var1);

    public abstract long getCellOffset(long var1, int var3);

    public abstract long getLength();

    public abstract boolean isFixed();

    public static Offsets getOffsets(ColumnWidth[] widths, long nrow) {
        boolean allFixed = true;
        for (int icol = 0; icol < widths.length; ++icol) {
            allFixed = allFixed && widths[icol].isConstant();
        }
        return allFixed ? new FixedOffsets(widths, nrow) : new VariableOffsets(widths, nrow);
    }

    private static class VariableOffsets
    extends Offsets {
        final ColumnWidth[] widths_;
        final int nrow_;
        final long[] rowOffsets_;
        final long leng_;

        VariableOffsets(ColumnWidth[] widths, long nrow) {
            this.widths_ = widths;
            this.nrow_ = Tables.checkedLongToInt(nrow);
            this.rowOffsets_ = new long[this.nrow_];
            int ncol = widths.length;
            long pos = 0L;
            for (int irow = 0; irow < this.nrow_; ++irow) {
                this.rowOffsets_[irow] = pos;
                for (int icol = 0; icol < ncol; ++icol) {
                    pos += (long)widths[icol].getWidth(irow);
                }
            }
            this.leng_ = pos;
        }

        @Override
        public long getRowOffset(long lrow) {
            int irow = Tables.checkedLongToInt(lrow);
            return this.rowOffsets_[irow];
        }

        @Override
        public long getCellOffset(long lrow, int icol) {
            long off = this.getRowOffset(lrow);
            for (int ic = 0; ic < icol; ++ic) {
                off += (long)this.widths_[ic].getWidth(lrow);
            }
            return off;
        }

        @Override
        public long getLength() {
            return this.leng_;
        }

        @Override
        public boolean isFixed() {
            return false;
        }
    }

    private static class FixedOffsets
    extends Offsets {
        final long[] colOffs_;
        final long rowSize_;
        final long leng_;

        FixedOffsets(ColumnWidth[] widths, long nrow) {
            int ncol = widths.length;
            this.colOffs_ = new long[ncol];
            long pos = 0L;
            for (int icol = 0; icol < ncol; ++icol) {
                this.colOffs_[icol] = pos;
                pos += (long)widths[icol].getWidth(0L);
            }
            this.rowSize_ = pos;
            this.leng_ = nrow * this.rowSize_;
        }

        @Override
        public long getRowOffset(long lrow) {
            return this.rowSize_ * lrow;
        }

        @Override
        public long getCellOffset(long lrow, int icol) {
            return this.rowSize_ * lrow + this.colOffs_[icol];
        }

        @Override
        public long getLength() {
            return this.leng_;
        }

        @Override
        public boolean isFixed() {
            return true;
        }
    }
}

