/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry;

import skyview.data.CoordinateFormatter;
import skyview.geometry.Converter;
import skyview.geometry.CoordinateSystem;
import skyview.geometry.TransformationException;
import skyview.geometry.Util;

public class Position {
    private double[] coords = new double[2];
    private double[] orig = new double[2];
    private String origFrame;

    public Position(double l, double b) throws TransformationException {
        this(l, b, "J2000");
    }

    public Position(double l, double b, String frame) throws TransformationException {
        this.orig[0] = l;
        this.orig[1] = b;
        this.origFrame = frame;
        if (frame == null || frame.toUpperCase().equals("J2000")) {
            this.coords[0] = l;
            this.coords[1] = b;
        } else {
            CoordinateSystem csys = CoordinateSystem.factory(frame);
            double[] unit = Util.unit(Math.toRadians(l), Math.toRadians(b));
            Converter conv = new Converter();
            if (csys.getRotater() != null) {
                conv.add(csys.getRotater().inverse());
            }
            if (csys.getSphereDistorter() != null) {
                conv.add(csys.getSphereDistorter().inverse());
            }
            double[] j2000Unit = conv.transform(unit);
            double[] j2000C = Util.coord(j2000Unit);
            this.coords[0] = Math.toDegrees(j2000C[0]);
            this.coords[1] = Math.toDegrees(j2000C[1]);
        }
    }

    public double[] getCoordinates() throws TransformationException {
        return this.getCoordinates("J2000");
    }

    public double[] getCoordinates(String frame) throws TransformationException {
        if (frame == null || frame.toUpperCase().equals("J2000")) {
            return this.coords;
        }
        if (frame.equals(this.origFrame)) {
            return (double[])this.orig.clone();
        }
        CoordinateSystem csys = CoordinateSystem.factory(frame);
        double[] unit = Util.unit(Math.toRadians(this.coords[0]), Math.toRadians(this.coords[1]));
        Converter conv = new Converter();
        if (csys.getSphereDistorter() != null) {
            conv.add(csys.getSphereDistorter());
        }
        if (csys.getRotater() != null) {
            conv.add(csys.getRotater());
        }
        double[] xUnit = conv.transform(unit);
        double[] xCoords = Util.coord(xUnit);
        xCoords[0] = Math.toDegrees(xCoords[0]);
        xCoords[1] = Math.toDegrees(xCoords[1]);
        if (xCoords[0] < 0.0) {
            xCoords[0] = xCoords[0] + 360.0;
        } else if (xCoords[0] >= 360.0) {
            xCoords[0] = xCoords[0] - 360.0;
        }
        return xCoords;
    }

    public String formatted(String coords, int precision, boolean sexagesimal) {
        String value;
        CoordinateFormatter cf = new CoordinateFormatter();
        double[] vals = null;
        try {
            vals = this.getCoordinates(coords);
        }
        catch (Exception e) {
            return null;
        }
        if (sexagesimal) {
            if (coords.charAt(0) == 'B' || coords.charAt(0) == 'J') {
                vals[0] = vals[0] / 15.0;
            }
            cf.setZeroFill(true);
            value = cf.sexagesimal(vals[0], precision) + ", " + cf.sexagesimal(vals[1], precision);
        } else {
            value = cf.decimal(vals[0], precision) + ", " + cf.decimal(vals[1], precision);
        }
        return value;
    }

    public static void main(String[] args) throws Exception {
        double l = Double.parseDouble(args[0]);
        double b = Double.parseDouble(args[1]);
        Position p = new Position(l, b, args[2]);
        double[] out = p.getCoordinates(args[3]);
        System.out.println("Output:" + out[0] + "," + out[1]);
    }
}

