/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry;

import skyview.Component;
import skyview.geometry.TransformationException;
import skyview.geometry.Transformer;

public class Rotater
extends Transformer
implements Component {
    private double[][] matrix;
    private Rotater transRot;
    private double[] temp = new double[3];

    public Rotater(double[][] vectors) throws TransformationException {
        if (vectors.length != 3) {
            throw new TransformationException("Rotation not 3x3 matrix");
        }
        this.matrix = (double[][])vectors.clone();
        for (int i = 0; i < this.matrix.length; ++i) {
            if (vectors[i].length != 3) {
                throw new TransformationException("Rotation not 3x3 matrix");
            }
            this.matrix[i] = (double[])vectors[i].clone();
        }
    }

    protected int getInputDimension() {
        return 3;
    }

    protected int getOutputDimension() {
        return 3;
    }

    public String getName() {
        return "Rotater";
    }

    public String getDescription() {
        return "An object that rotates 3-d vectors in space.";
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public Rotater transpose() {
        if (this.transRot == null) {
            double[][] trans = new double[3][3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    trans[i][j] = this.matrix[j][i];
                }
            }
            try {
                this.transRot = new Rotater(trans);
            }
            catch (Exception e) {
                System.err.println("Should be 3x3 matrix, but transpose failed?");
            }
        }
        return this.transRot;
    }

    public Rotater inverse() {
        return this.transpose();
    }

    public Rotater add(Rotater r) {
        if (r == null) {
            try {
                return new Rotater(this.matrix);
            }
            catch (Exception e) {
                throw new Error("Unexpected error:" + e);
            }
        }
        double[][] a = this.matrix;
        double[][] b = r.matrix;
        double[][] result = new double[a.length][b[0].length];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < b.length; ++k) {
                    double[] dArray = result[i];
                    int n = j;
                    dArray[n] = dArray[n] + b[i][k] * a[k][j];
                }
            }
        }
        Rotater res = null;
        try {
            res = new Rotater(result);
        }
        catch (Exception e) {
            System.err.println("Add resulted in non 3x3 matrix!");
        }
        return res;
    }

    public void transform(double[] in, double[] out) {
        if (in == out) {
            System.arraycopy(in, 0, this.temp, 0, in.length);
            in = this.temp;
        }
        for (int i = 0; i < in.length; ++i) {
            out[i] = 0.0;
            for (int j = 0; j < this.matrix[0].length; ++j) {
                int n = i;
                out[n] = out[n] + this.matrix[i][j] * in[j];
            }
        }
    }

    public Rotater(String order, double phi, double theta, double psi) {
        this.matrix = new double[3][3];
        double[][] rotn = new double[3][3];
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 3; ++i) {
                this.matrix[i][j] = i != j ? 0.0 : 1.0;
            }
        }
        int l = order.length();
        for (int n = 0; n < 3 && n < l; ++n) {
            for (int j = 0; j < 3; ++j) {
                for (int i = 0; i < 3; ++i) {
                    rotn[i][j] = i != j ? 0.0 : 1.0;
                }
            }
            double angle = n == 0 ? phi : (n == 1 ? theta : psi);
            double s = Math.sin(angle);
            double c = Math.cos(angle);
            char axis = order.charAt(n);
            if (axis == 'x' || axis == 'X' || axis == '1') {
                rotn[1][1] = c;
                rotn[1][2] = s;
                rotn[2][1] = -s;
                rotn[2][2] = c;
            } else if (axis == 'y' || axis == 'Y' || axis == '2') {
                rotn[0][0] = c;
                rotn[0][2] = -s;
                rotn[2][0] = s;
                rotn[2][2] = c;
            } else if (axis == 'z' || axis == 'Z' || axis == '3') {
                rotn[0][0] = c;
                rotn[0][1] = s;
                rotn[1][0] = -s;
                rotn[1][1] = c;
            }
            double[][] wm = new double[3][3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    double w = 0.0;
                    for (int k = 0; k < 3; ++k) {
                        w += rotn[i][k] * this.matrix[k][j];
                    }
                    wm[i][j] = w;
                }
            }
            for (int j = 0; j < 3; ++j) {
                for (int i = 0; i < 3; ++i) {
                    this.matrix[i][j] = wm[i][j];
                }
            }
        }
    }

    public boolean isInverse(Transformer trans) {
        if (!(trans instanceof Rotater)) {
            return false;
        }
        Rotater rx = (Rotater)trans;
        Rotater sum = this.add((Rotater)trans);
        return sum.isUnit();
    }

    private boolean isUnit() {
        double delta = Math.abs(1.0 - this.matrix[0][0]) + Math.abs(1.0 - this.matrix[1][1]) + Math.abs(1.0 - this.matrix[2][2]) + Math.abs(this.matrix[0][1]) + Math.abs(this.matrix[0][2]) + Math.abs(this.matrix[1][0]) + Math.abs(this.matrix[1][2]) + Math.abs(this.matrix[2][0]) + Math.abs(this.matrix[2][1]);
        return delta < 1.0E-10;
    }

    public void printOut() {
        System.err.println("\nRotation:" + this + "\n" + this.matrix[0][0] + " " + this.matrix[0][1] + " " + this.matrix[0][2] + "\n" + "         " + this.matrix[1][0] + " " + this.matrix[1][1] + " " + this.matrix[1][2] + "\n" + "         " + this.matrix[2][0] + " " + this.matrix[2][1] + " " + this.matrix[2][2] + "\n");
    }
}

