/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;

public final class Csc
extends Projecter {
    private static final int[] posIndex = new int[]{1, 2, 0};
    private static final int[] negIndex = new int[]{3, 4, 5};
    private static final int[] epsIndex = new int[]{1, 1, 0, 1, 0, 1};
    private static final int[] zetIndex = new int[]{0, 2, 2, 2, 2, 0};
    private static final int[] etaIndex = new int[]{2, 0, 1, 0, 1, 2};
    private static final int[] epsSign = new int[]{1, 1, -1, -1, 1, 1};
    private static final int[] zetSign = new int[]{-1, 1, 1, 1, 1, 1};
    private static final int[] etaSign = new int[]{1, 1, 1, -1, -1, -1};
    private static double[][] faceCenter = new double[][]{{0.0, 1.5707963267948966}, {0.0, 0.0}, {1.5707963267948966, 0.0}, {Math.PI, 0.0}, {4.71238898038469, 0.0}, {0.0, -1.5707963267948966}};
    private static final double r_0 = 0.577350269;
    private static final double gam_s = 1.37484847732;
    private static final double em = 0.004869491981;
    private static final double gam = -0.13161671474;
    private static final double ome = -0.159596235474;
    private static final double d_0 = 0.0759196200467;
    private static final double d_1 = -0.0217762490699;
    private static final double c_00 = 0.141189631152;
    private static final double c_10 = 0.0809701286525;
    private static final double c_01 = -0.281528535557;
    private static final double c_20 = -0.178251207466;
    private static final double c_11 = 0.15384112876;
    private static final double c_02 = 0.106959469314;
    private static final double[][] p = new double[][]{{-0.27292696, -0.02819452, 0.2705816, -0.6044156, 0.93412077, -0.63915306, 0.14381585}, {-0.07629969, -0.01471565, -0.56800938, 1.50880086, -1.4160192, 0.52032238}, {-0.22797056, 0.48051509, 0.30803317, -0.93678576, 0.33887446}, {0.54852384, -1.74114454, 0.98938102, 0.08693841}, {-0.62930065, 1.71547508, -0.83180469}, {0.25795794, -0.53022337}, {0.02584375}};

    public String getName() {
        return "Csc";
    }

    public String getDescription() {
        return "Project from a sphere to the surface of a cube using the COBE projection.";
    }

    public Deprojecter inverse() {
        return new CscDeproj();
    }

    public boolean isInverse(Transformer t) {
        return t.getName().equals("CscDeproj");
    }

    public double getXTiling() {
        return Math.PI * 2;
    }

    public final void transform(double[] sphere, double[] plane) {
        if (Double.isNaN(sphere[2])) {
            plane[0] = Double.NaN;
            plane[1] = Double.NaN;
        } else {
            int face = -1;
            double max = 0.0;
            for (int i = 0; i < 3; ++i) {
                if (!(Math.abs(sphere[i]) > max)) continue;
                max = Math.abs(sphere[i]);
                face = i;
            }
            face = sphere[face] < 0.0 ? negIndex[face] : posIndex[face];
            double eps = sphere[epsIndex[face]] * (double)epsSign[face];
            double zet = sphere[zetIndex[face]] * (double)zetSign[face];
            double eta = sphere[etaIndex[face]] * (double)etaSign[face];
            double alpha = eps / eta;
            double beta = zet / eta;
            plane[0] = Csc.f(alpha, beta) + faceCenter[face][0];
            plane[1] = Csc.f(beta, alpha) + faceCenter[face][1];
        }
    }

    private static double f(double alpha, double beta) {
        double alpha2 = alpha * alpha;
        double alpha4 = alpha2 * alpha2;
        double beta2 = beta * beta;
        double beta4 = beta2 * beta2;
        double res = alpha * 1.37484847732 + alpha2 * alpha * -0.37484847732000004 + alpha * beta2 * (1.0 - alpha2) * (-0.13161671474 + 0.136486206721 * alpha2 + (1.0 - beta2) * (0.141189631152 + 0.0809701286525 * alpha2 + -0.281528535557 * beta2 + -0.178251207466 * alpha4 + 0.15384112876 * alpha2 * beta2 + 0.106959469314 * beta4)) + alpha * alpha2 * (1.0 - alpha2) * (-0.159596235474 - (1.0 - alpha2) * (0.0759196200467 + -0.0217762490699 * alpha2));
        return 0.7853981633974483 * res;
    }

    public boolean validPosition(double[] plane) {
        double x = plane[0];
        double y = plane[1];
        double p4 = 0.7853981633974483;
        return super.validPosition(plane) && (x >= p4 && x <= 7.0 * p4 && y >= -p4 && y <= p4 || x >= -p4 && x <= p4 && y >= -3.0 * p4 && y <= 3.0 * p4);
    }

    public class CscDeproj
    extends Deprojecter {
        public String getName() {
            return "CscDeproj";
        }

        public String getDescription() {
            return "Transform from the surface of the plane to the celestial sphere using the COBE algorithm";
        }

        public Projecter inverse() {
            return Csc.this;
        }

        public boolean isInverse(Transformer t) {
            return t.getName().equals("Csc");
        }

        public final void transform(double[] plane, double[] sphere) {
            if (Double.isNaN(plane[0])) {
                sphere[0] = Double.NaN;
                sphere[1] = Double.NaN;
                sphere[2] = Double.NaN;
            } else {
                double x = plane[0];
                double y = plane[1];
                int face = this.findFace(x, y);
                if (face < 0) {
                    sphere[0] = Double.NaN;
                    sphere[1] = Double.NaN;
                    sphere[2] = Double.NaN;
                    return;
                }
                x = (x - faceCenter[face][0]) / 0.7853981633974483;
                y = (y - faceCenter[face][1]) / 0.7853981633974483;
                double alpha = this.g(x, y);
                double beta = this.g(y, x);
                sphere[epsIndex[face]] = alpha * (double)epsSign[face];
                sphere[zetIndex[face]] = beta * (double)zetSign[face];
                sphere[etaIndex[face]] = 1 * etaSign[face];
                double norm = 1.0 / Math.sqrt(alpha * alpha + beta * beta + 1.0);
                int i = 0;
                while (i < 3) {
                    int n = i++;
                    sphere[n] = sphere[n] * norm;
                }
            }
        }

        private final double g(double x, double y) {
            double sum = 0.0;
            double yp = 1.0;
            for (int j = 0; j < 7; ++j) {
                double xp = 1.0;
                for (int i = 0; i < 7 - j; ++i) {
                    sum += p[i][j] * xp * yp;
                    xp *= x * x;
                }
                yp *= y * y;
            }
            sum = x + x * (1.0 - x * x) * sum;
            return sum;
        }

        private int findFace(double x, double y) {
            double p4 = 0.7853981633974483;
            if (7.0 * p4 >= x && x > -p4 && Math.abs(y) <= p4) {
                if (x > 5.0 * p4) {
                    return 4;
                }
                if (x > 3.0 * p4) {
                    return 3;
                }
                if (x > p4) {
                    return 2;
                }
                return 1;
            }
            if (Math.abs(x) <= p4) {
                if (y <= 3.0 * p4 && y >= p4) {
                    return 0;
                }
                if (y <= -p4 && y >= -3.0 * p4) {
                    return 5;
                }
            }
            return -1;
        }
    }
}

