/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;

public class Zea
extends Projecter {
    public String getName() {
        return "Zea";
    }

    public String getDescription() {
        return "Zenithal Equal Area projecter";
    }

    public Deprojecter inverse() {
        return new ZeaDeproj();
    }

    public boolean isInverse(Transformer t) {
        return t.getName().equals("ZeaDeproj");
    }

    public final void transform(double[] sphere, double[] plane) {
        if (Double.isNaN(sphere[2])) {
            plane[0] = Double.NaN;
            plane[1] = Double.NaN;
        } else {
            double denom;
            double num = 2.0 * (1.0 - sphere[2]);
            if (num < 0.0) {
                num = 0.0;
            }
            if ((denom = sphere[0] * sphere[0] + sphere[1] * sphere[1]) == 0.0) {
                plane[0] = 0.0;
                plane[1] = 0.0;
            } else {
                double ratio = Math.sqrt(num) / Math.sqrt(sphere[0] * sphere[0] + sphere[1] * sphere[1]);
                plane[0] = ratio * sphere[0];
                plane[1] = ratio * sphere[1];
            }
        }
    }

    public boolean validPosition(double[] plane) {
        return super.validPosition(plane) && plane[0] * plane[0] + plane[1] * plane[1] <= 4.0;
    }

    public class ZeaDeproj
    extends Deprojecter {
        public String getName() {
            return "ZeaDeproj";
        }

        public String getDescription() {
            return "Zenithal equal area deprojecter";
        }

        public Projecter inverse() {
            return Zea.this;
        }

        public boolean isInverse(Transformer t) {
            return t.getName().equals("Zea");
        }

        public final void transform(double[] plane, double[] sphere) {
            if (!Zea.this.validPosition(plane)) {
                sphere[0] = Double.NaN;
                sphere[1] = Double.NaN;
                sphere[2] = Double.NaN;
            } else {
                double r = Math.sqrt(plane[0] * plane[0] + plane[1] * plane[1]);
                sphere[2] = 1.0 - r * r / 2.0;
                double ratio = 1.0 - sphere[2] * sphere[2];
                ratio = ratio > 0.0 ? Math.sqrt(ratio) / r : 0.0;
                sphere[0] = ratio * plane[0];
                sphere[1] = ratio * plane[1];
            }
        }
    }
}

