/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess.table;

import gov.nasa.pds.objectAccess.table.DefaultFieldAdapter;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class NumericTextFieldAdapter
extends DefaultFieldAdapter {
    public final int radix;

    public NumericTextFieldAdapter(int radix) {
        this.radix = radix;
    }

    @Override
    public byte getByte(byte[] buf, int offset, int length, int startBit, int stopBit) {
        int value = this.getBigInteger(buf, offset, length, startBit, stopBit).intValue();
        if (value < -128 || value > 127) {
            throw new NumberFormatException("Value is out of range of a byte (" + value + ")");
        }
        return (byte)value;
    }

    @Override
    public short getShort(byte[] buf, int offset, int length, int startBit, int stopBit) {
        int value = this.getBigInteger(buf, offset, length, startBit, stopBit).intValue();
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new NumberFormatException("Value is out of range of a short (" + value + ")");
        }
        return (short)value;
    }

    @Override
    public int getInt(byte[] buf, int offset, int length, int startBit, int stopBit) {
        return this.getBigInteger(buf, offset, length, startBit, stopBit).intValue();
    }

    @Override
    public long getLong(byte[] buf, int offset, int length, int startBit, int stopBit) {
        return this.getBigInteger(buf, offset, length, startBit, stopBit).longValue();
    }

    @Override
    public float getFloat(byte[] buf, int offset, int length, int startBit, int stopBit) {
        return Float.parseFloat(this.getString(buf, offset, length, startBit, stopBit).trim());
    }

    @Override
    public double getDouble(byte[] buf, int offset, int length, int startBit, int stopBit) {
        return Double.parseDouble(this.getString(buf, offset, length, startBit, stopBit).trim());
    }

    @Override
    public BigInteger getBigInteger(byte[] buf, int offset, int length, int startBit, int stopBit) {
        return new BigInteger(this.getString(buf, offset, length, startBit, stopBit).trim(), this.radix);
    }

    @Override
    public void setByte(byte value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        this.setString(Integer.toString(value, this.radix), offset, length, buffer, isRightJustified);
    }

    @Override
    public void setShort(short value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        this.setString(Integer.toString(value, this.radix), offset, length, buffer, isRightJustified);
    }

    @Override
    public void setInt(int value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        this.setString(Integer.toString(value, this.radix), offset, length, buffer, isRightJustified);
    }

    @Override
    public void setLong(long value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        this.setString(Long.toString(value, this.radix), offset, length, buffer, isRightJustified);
    }

    @Override
    public void setFloat(float value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        this.setString(Float.toString(value), offset, length, buffer, isRightJustified);
    }

    @Override
    public void setDouble(double value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        this.setString(Double.toString(value), offset, length, buffer, isRightJustified);
    }

    @Override
    public void setBigInteger(BigInteger value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        this.setString(value.toString(this.radix), offset, length, buffer, isRightJustified);
    }
}

