/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.client;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.ErrInfo;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.SampMap;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.MessageHandler;
import org.astrogrid.samp.client.SampException;

public abstract class AbstractMessageHandler
implements MessageHandler {
    private Subscriptions subscriptions_;
    private final Logger logger_ = Logger.getLogger(AbstractMessageHandler.class.getName());

    protected AbstractMessageHandler(Map subscriptions) {
        this.setSubscriptions(subscriptions);
    }

    protected AbstractMessageHandler(String[] mtypes) {
        HashMap subs = new HashMap();
        for (int i = 0; i < mtypes.length; ++i) {
            subs.put(mtypes[i], new HashMap());
        }
        this.setSubscriptions(subs);
    }

    protected AbstractMessageHandler(String mtype) {
        this(new String[]{mtype});
    }

    public abstract Map processCall(HubConnection var1, String var2, Message var3) throws Exception;

    protected Response createResponse(Map processOutput) {
        Map result = processOutput == null ? SampMap.EMPTY : processOutput;
        return Response.createSuccessResponse(result);
    }

    public void setSubscriptions(Map subscriptions) {
        Subscriptions subs = Subscriptions.asSubscriptions(subscriptions);
        subs.check();
        this.subscriptions_ = subs;
    }

    public Map getSubscriptions() {
        return this.subscriptions_;
    }

    public void receiveNotification(HubConnection connection, String senderId, Message message) {
        try {
            this.processCall(connection, senderId, message);
        }
        catch (Throwable e) {
            this.logger_.log(Level.INFO, "Error processing notification " + message.getMType() + " - ignored", e);
        }
    }

    public void receiveCall(HubConnection connection, String senderId, String msgId, Message message) throws SampException {
        Response response;
        try {
            response = this.createResponse(this.processCall(connection, senderId, message));
        }
        catch (Throwable e) {
            response = Response.createErrorResponse(new ErrInfo(e));
        }
        connection.reply(msgId, response);
    }
}

