/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.gui.ErrorDialog;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.gui.SendActionManager;
import org.astrogrid.samp.gui.SubscribedClientListModel;

public abstract class NotifyActionManager
extends SendActionManager {
    private final Component parent_;
    private final GuiHubConnector connector_;
    private final String sendType_;
    private static final Logger logger_ = Logger.getLogger(NotifyActionManager.class.getName());

    public NotifyActionManager(Component parent, GuiHubConnector connector, String mtype, String sendType) {
        super(connector, new SubscribedClientListModel(connector, mtype));
        this.parent_ = parent;
        this.connector_ = connector;
        this.sendType_ = sendType;
        this.updateState();
    }

    protected abstract Map createMessage() throws Exception;

    protected void messageSent(HubConnection connection, Message msg, Client[] recipients) {
        for (int i = 0; i < recipients.length; ++i) {
            logger_.info("Message " + msg.getMType() + " sent to " + recipients[i]);
        }
    }

    protected Action createBroadcastAction() {
        AbstractAction act = new AbstractAction(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void actionPerformed(ActionEvent evt) {
                List recipientIdList = null;
                Message msg = null;
                HubConnection connection = null;
                try {
                    msg = Message.asMessage(NotifyActionManager.this.createMessage());
                    msg.check();
                    connection = NotifyActionManager.this.connector_.getConnection();
                    if (connection != null) {
                        recipientIdList = connection.notifyAll(msg);
                    }
                }
                catch (Exception e) {
                    ErrorDialog.showError(NotifyActionManager.this.parent_, "Send Error", "Send failure " + e.getMessage(), e);
                }
                if (recipientIdList != null) {
                    if (!$assertionsDisabled && connection == null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && msg == null) {
                        throw new AssertionError();
                    }
                    ArrayList<Client> recipientList = new ArrayList<Client>();
                    Map clientMap = NotifyActionManager.this.connector_.getClientMap();
                    Iterator it = recipientIdList.iterator();
                    while (it.hasNext()) {
                        String id = (String)it.next();
                        Client recipient = (Client)clientMap.get(id);
                        if (recipient == null) continue;
                        recipientList.add(recipient);
                    }
                    NotifyActionManager.this.messageSent(connection, msg, recipientList.toArray(new Client[0]));
                }
            }

            static {
                $assertionsDisabled = !(class$org$astrogrid$samp$gui$NotifyActionManager == null ? (class$org$astrogrid$samp$gui$NotifyActionManager = NotifyActionManager.class$("org.astrogrid.samp.gui.NotifyActionManager")) : class$org$astrogrid$samp$gui$NotifyActionManager).desiredAssertionStatus();
            }
        };
        act.putValue("Name", "Broadcast " + this.sendType_);
        act.putValue("ShortDescription", "Transmit " + this.sendType_ + " to all applications listening using the SAMP protocol");
        act.putValue("SmallIcon", NotifyActionManager.getBroadcastIcon());
        return act;
    }

    public JMenu createSendMenu() {
        JMenu menu = super.createSendMenu("Send " + this.sendType_ + " to...");
        menu.setIcon(NotifyActionManager.getSendIcon());
        return menu;
    }

    protected Action getSendAction(Client client) {
        return new SendAction(client);
    }

    private class SendAction
    extends AbstractAction {
        private final Client client_;
        private final String cName_;
        static final /* synthetic */ boolean $assertionsDisabled;

        SendAction(Client client) {
            this.client_ = client;
            this.cName_ = client.toString();
            this.putValue("Name", this.cName_);
            this.putValue("ShortDescription", "Transmit " + NotifyActionManager.this.sendType_ + " to " + this.cName_ + " using SAMP protocol");
        }

        public void actionPerformed(ActionEvent evt) {
            boolean sent = false;
            Message msg = null;
            HubConnection connection = null;
            try {
                msg = Message.asMessage(NotifyActionManager.this.createMessage());
                msg.check();
                connection = NotifyActionManager.this.connector_.getConnection();
                if (connection != null) {
                    connection.notify(this.client_.getId(), msg);
                    sent = true;
                }
            }
            catch (Exception e) {
                ErrorDialog.showError(NotifyActionManager.this.parent_, "Send Error", "Send failure " + e.getMessage(), e);
            }
            if (sent) {
                if (!$assertionsDisabled && connection == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && msg == null) {
                    throw new AssertionError();
                }
                NotifyActionManager.this.messageSent(connection, msg, new Client[]{this.client_});
            }
        }

        public boolean equals(Object o) {
            if (o instanceof SendAction) {
                SendAction other = (SendAction)o;
                return this.client_.equals(other.client_) && this.cName_.equals(other.cName_);
            }
            return false;
        }

        public int hashCode() {
            return this.client_.hashCode() * 23 + this.cName_.hashCode();
        }

        static {
            $assertionsDisabled = !(class$org$astrogrid$samp$gui$NotifyActionManager == null ? (class$org$astrogrid$samp$gui$NotifyActionManager = NotifyActionManager.class$("org.astrogrid.samp.gui.NotifyActionManager")) : class$org$astrogrid$samp$gui$NotifyActionManager).desiredAssertionStatus();
        }
    }
}

